/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.users;

import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;

public class UsersTreeBuilder
implements TreeBuilder {
    public void buildTree(TreeControl treeControl, ApplicationServlet servlet, HttpServletRequest request) {
        MessageResources resources = (MessageResources)servlet.getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        this.addSubtree(treeControl.getRoot(), resources, locale);
    }

    protected void addSubtree(TreeControlNode root, MessageResources resources, Locale locale) {
        String databaseName = URLEncoder.encode("Users:type=UserDatabase,database=UserDatabase");
        TreeControlNode subtree = new TreeControlNode("Global User and Group Administration", "folder_16_pad.gif", resources.getMessage(locale, "users.treeBuilder.subtreeNode"), null, "content", true, "Users");
        TreeControlNode groups = new TreeControlNode("Global Administer Groups", "Groups.gif", resources.getMessage(locale, "users.treeBuilder.groupsNode"), "users/listGroups.do?databaseName=" + URLEncoder.encode(databaseName) + "&forward=" + URLEncoder.encode("Groups List Setup"), "content", false, "Users");
        TreeControlNode roles = new TreeControlNode("Global Administer Roles", "Roles.gif", resources.getMessage(locale, "users.treeBuilder.rolesNode"), "users/listRoles.do?databaseName=" + URLEncoder.encode(databaseName) + "&forward=" + URLEncoder.encode("Roles List Setup"), "content", false, "Users");
        TreeControlNode users = new TreeControlNode("Global Administer Users", "Users.gif", resources.getMessage(locale, "users.treeBuilder.usersNode"), "users/listUsers.do?databaseName=" + URLEncoder.encode(databaseName) + "&forward=" + URLEncoder.encode("Users List Setup"), "content", false, "Users");
        root.addChild(subtree);
        subtree.addChild(users);
        subtree.addChild(groups);
        subtree.addChild(roles);
    }
}

