/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.ResourceLinkForm;
import org.apache.webapp.admin.resources.ResourceUtils;

public final class SaveResourceLinkAction
extends Action {
    private MessageResources resources = null;
    private MBeanServer mserver = null;

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        if (this.resources == null) {
            this.resources = this.getServlet().getResources();
        }
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (this.isCancelled(request)) {
            return mapping.findForward("List ResourceLinks Setup");
        }
        if (!this.isTokenValid(request)) {
            response.sendError(400, this.resources.getMessage(locale, "users.error.token"));
            return null;
        }
        ResourceLinkForm resourceLinkForm = (ResourceLinkForm)form;
        String objectName = resourceLinkForm.getObjectName();
        if (objectName == null) {
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{resourceLinkForm.getName(), resourceLinkForm.getType()};
            String resourcetype = resourceLinkForm.getResourcetype();
            String path = resourceLinkForm.getPath();
            String host = resourceLinkForm.getHost();
            String domain = resourceLinkForm.getDomain();
            ObjectName oname = null;
            try {
                if (resourcetype.equals("Global")) {
                    oname = new ObjectName(domain + ":type=ResourceLink" + ",resourcetype=Global" + ",name=" + params[0]);
                } else if (resourcetype.equals("Context")) {
                    oname = new ObjectName(domain + ":type=ResourceLink" + ",resourcetype=Context" + ",path=" + path + ",host=" + host + ",name=" + params[0]);
                }
                if (this.mserver.isRegistered(oname)) {
                    ActionErrors errors = new ActionErrors();
                    errors.add("name", new ActionError("resources.invalid.name"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                oname = ResourceUtils.getNamingResourceObjectName(domain, resourcetype, path, host);
                objectName = (String)this.mserver.invoke(oname, "addResourceLink", params, signature);
            }
            catch (Exception e) {
                this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", (Object)"addResourceLink"), (Throwable)e);
                response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", (Object)"addResourceLink"));
                return null;
            }
        }
        String attribute = null;
        try {
            ObjectName oname = new ObjectName(objectName);
            attribute = "global";
            this.mserver.setAttribute(oname, new Attribute(attribute, resourceLinkForm.getGlobal()));
            attribute = "type";
            this.mserver.setAttribute(oname, new Attribute(attribute, resourceLinkForm.getType()));
        }
        catch (Exception e) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.set.attribute", (Object)attribute), (Throwable)e);
            response.sendError(500, this.resources.getMessage(locale, "users.error.set.attribute", (Object)attribute));
            return null;
        }
        return mapping.findForward("ResourceLinks List Setup");
    }
}

