/*
 * Decompiled with CFR 0.152.
 */
package org.globus.bootstrap;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.globus.bootstrap.BootstrapException;

public class BootstrapBase {
    private static final Class[] MAIN_PARAMS_TYPE = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = BootstrapBase.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
    private ArrayList libs = new ArrayList();
    static /* synthetic */ Class array$Ljava$lang$String;

    private File getDirectory(String dir) throws BootstrapException {
        File baseDir = new File(dir);
        if (!(baseDir.exists() && baseDir.isDirectory() && baseDir.canRead())) {
            throw new BootstrapException(baseDir + " does not exist, is not a directory, or is not readable");
        }
        try {
            return baseDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new BootstrapException("Failed to get the canonical form of " + dir);
        }
    }

    public void addDirectory(String dir) throws BootstrapException {
        File baseDir = this.getDirectory(dir);
        try {
            this.libs.add(baseDir.toURL());
        }
        catch (IOException e) {
            throw new BootstrapException("Error during startup processing", e);
        }
    }

    public void addLibDirectory(String dir) throws BootstrapException {
        this.addLibDirectory(dir, null);
    }

    public void addLibDirectory(String dir, String filter) throws BootstrapException {
        File baseDir = this.getDirectory(dir);
        File libDir = new File(baseDir, "lib");
        if (!(libDir.exists() && libDir.isDirectory() && libDir.canRead())) {
            throw new BootstrapException(libDir + " does not exist, is not a directory, or is not readable");
        }
        try {
            File[] jars = libDir.listFiles(new JarFilter(filter));
            for (int i = 0; i < jars.length; ++i) {
                this.libs.add(jars[i].toURL());
            }
        }
        catch (IOException e) {
            throw new BootstrapException("Error during startup processing", e);
        }
    }

    public void launch(String launchClass, String[] launchArgs) throws BootstrapException {
        URL[] urlJars = new URL[this.libs.size()];
        urlJars = this.libs.toArray(urlJars);
        URLClassLoader loader = new URLClassLoader(urlJars);
        Thread.currentThread().setContextClassLoader(loader);
        try {
            Class<?> mainClass = loader.loadClass(launchClass);
            Method mainMethod = mainClass.getMethod("main", MAIN_PARAMS_TYPE);
            mainMethod.invoke(null, new Object[]{launchArgs});
        }
        catch (ClassNotFoundException e) {
            throw new BootstrapException("Class '" + launchClass + "' not found");
        }
        catch (NoSuchMethodException e) {
            throw new BootstrapException("Class '" + launchClass + "' has no main(String[]) method");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            throw new BootstrapException("Error during startup processing", cause);
        }
        catch (IllegalAccessException e) {
            throw new BootstrapException("Error during startup processing", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JarFilter
    implements FilenameFilter {
        private String filter;

        public JarFilter(String filter) {
            this.filter = filter == null ? ".jar" : filter;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.filter);
        }
    }
}

