/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.naming.JndiPermission;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;

public class DirContextURLConnection
extends URLConnection {
    protected DirContext context;
    protected Resource resource;
    protected DirContext collection;
    protected Object object;
    protected Attributes attributes;
    protected long date;
    protected Permission permission;

    public DirContextURLConnection(DirContext dirContext, URL uRL) {
        super(uRL);
        if (dirContext == null) {
            throw new IllegalArgumentException("Directory context can't be null");
        }
        if (System.getSecurityManager() != null) {
            this.permission = new JndiPermission(uRL.toString());
        }
        this.context = dirContext;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            try {
                this.date = System.currentTimeMillis();
                String string = this.getURL().getFile();
                if (this.context instanceof ProxyDirContext) {
                    ProxyDirContext proxyDirContext = (ProxyDirContext)this.context;
                    String string2 = proxyDirContext.getHostName();
                    String string3 = proxyDirContext.getContextName();
                    if (string2 != null) {
                        if (!string.startsWith("/" + string2 + "/")) {
                            return;
                        }
                        string = string.substring(string2.length() + 1);
                    }
                    if (string3 != null) {
                        if (!string.startsWith(string3 + "/")) {
                            return;
                        }
                        string = string.substring(string3.length());
                    }
                }
                this.object = this.context.lookup(string);
                this.attributes = this.context.getAttributes(string);
                if (this.object instanceof Resource) {
                    this.resource = (Resource)this.object;
                }
                if (this.object instanceof DirContext) {
                    this.collection = (DirContext)this.object;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.connected = true;
        }
    }

    public int getContentLength() {
        return this.getHeaderFieldInt("getcontentlength", -1);
    }

    public String getContentType() {
        return this.getHeaderField("getcontenttype");
    }

    public long getDate() {
        return this.date;
    }

    public long getLastModified() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.attributes == null) {
            return 0L;
        }
        Attribute attribute = this.attributes.get("getlastmodified");
        if (attribute != null) {
            try {
                Date date = (Date)attribute.get();
                return date.getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public String getHeaderField(String string) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.attributes == null) {
            return null;
        }
        Attribute attribute = this.attributes.get(string);
        try {
            return attribute.get().toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource != null) {
            return this.getInputStream();
        }
        if (this.collection != null) {
            return this.collection;
        }
        if (this.object != null) {
            return this.object;
        }
        throw new FileNotFoundException();
    }

    public Object getContent(Class[] classArray) throws IOException {
        Object object = this.getContent();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].isInstance(object)) {
                return object;
            }
            ++n;
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource == null) {
            throw new FileNotFoundException();
        }
        try {
            this.resource = (Resource)this.context.lookup(this.getURL().getFile());
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return this.resource.streamContent();
    }

    public Permission getPermission() {
        return this.permission;
    }

    public Enumeration list() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource == null && this.collection == null) {
            throw new FileNotFoundException();
        }
        Vector<String> vector = new Vector<String>();
        if (this.collection != null) {
            try {
                NamingEnumeration<NameClassPair> namingEnumeration = this.context.list(this.getURL().getFile());
                while (namingEnumeration.hasMoreElements()) {
                    NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                    vector.addElement(nameClassPair.getName());
                }
            }
            catch (NamingException namingException) {
                throw new FileNotFoundException();
            }
        }
        return vector.elements();
    }
}

