/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.management;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.management.Registrar;
import org.apache.axis.management.jmx.ServiceAdministrator;
import org.apache.axis.server.AxisServer;

public class ServiceAdmin {
    private static AxisServer axisServer = null;

    public static void startService(String serviceName) throws AxisFault, ConfigurationException {
        AxisServer server = ServiceAdmin.getEngine();
        try {
            SOAPService service = server.getConfig().getService(new QName("", serviceName));
            service.start();
        }
        catch (ConfigurationException configException) {
            if (configException.getContainedException() instanceof AxisFault) {
                throw (AxisFault)configException.getContainedException();
            }
            throw configException;
        }
    }

    public static void stopService(String serviceName) throws AxisFault, ConfigurationException {
        AxisServer server = ServiceAdmin.getEngine();
        try {
            SOAPService service = server.getConfig().getService(new QName("", serviceName));
            service.stop();
        }
        catch (ConfigurationException configException) {
            if (configException.getContainedException() instanceof AxisFault) {
                throw (AxisFault)configException.getContainedException();
            }
            throw configException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static HashMap listServices() throws AxisFault, ConfigurationException {
        void var2_2;
        AxisServer server = ServiceAdmin.getEngine();
        HashMap<String, SOAPService> serviceMap = new HashMap<String, SOAPService>();
        try {
            Iterator iter = server.getConfig().getDeployedServices();
        }
        catch (ConfigurationException configException) {
            if (configException.getContainedException() instanceof AxisFault) {
                throw (AxisFault)configException.getContainedException();
            }
            throw configException;
        }
        while (var2_2.hasNext()) {
            ServiceDesc sd = (ServiceDesc)var2_2.next();
            String name = sd.getName();
            SOAPService service = server.getConfig().getService(new QName("", name));
            serviceMap.put(name, service);
        }
        return serviceMap;
    }

    public static AxisServer getEngine() throws AxisFault {
        if (axisServer == null) {
            throw new AxisFault("Unable to locate AxisEngine for ServiceAdmin Object");
        }
        return axisServer;
    }

    public static void setEngine(AxisServer axisSrv, String name) {
        axisServer = axisSrv;
        Registrar.register(new ServiceAdministrator(), "AxisServer:name=" + name, "AxisServerContext");
    }
}

