/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.opensaml.SAMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XML {
    public static final String OGSA_AUTHZ_SAML_NS = "http://www.gridforum.org/namespaces/2003/06/ogsa-authz/saml/";
    public static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String OPENSAML_NS = "http://www.opensaml.org";
    public static final String SAML_NS = "urn:oasis:names:tc:SAML:1.0:assertion";
    public static final String SAMLP_NS = "urn:oasis:names:tc:SAML:1.0:protocol";
    public static final String XMLSIG_NS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XPATH2_NS = "http://www.w3.org/2002/06/xmldsig-filter2";
    public static final String SOAP11ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String XML_SCHEMA_ID = "xml.xsd";
    public static final String SAML_SCHEMA_ID = "cs-sstc-schema-assertion-01.xsd";
    public static final String SAMLP_SCHEMA_ID = "cs-sstc-schema-protocol-01.xsd";
    public static final String XMLSIG_SCHEMA_ID = "xmldsig-core-schema.xsd";
    public static final String XPATH2_SCHEMA_ID = "xmldsig-filter2.xsd";
    public static final String SOAP11ENV_SCHEMA_ID = "soap-envelope.xsd";
    public static ParserPool parserPool = new ParserPool();
    protected static byte[] XML_schema;
    protected static byte[] SAML_schema;
    protected static byte[] SAMLP_schema;
    protected static byte[] XMLSig_schema;
    protected static byte[] XPath2_schema;
    protected static byte[] SOAP11Env_schema;
    private static Logger log;
    static /* synthetic */ Class class$org$opensaml$XML;

    public static boolean isElementNamed(Element e, String ns, String localName) {
        if (e == null) {
            return false;
        }
        if (ns == null && e.getNamespaceURI() != null || !ns.equals(e.getNamespaceURI())) {
            return false;
        }
        return (localName != null || e.getLocalName() == null) && localName.equals(e.getLocalName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        log = Logger.getLogger((String)(class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getName());
        try {
            int b;
            StringBuffer buf = new StringBuffer(1024);
            InputStream xmlin = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-assertion-01.xsd");
            if (xmlin == null) {
                throw new RuntimeException("XML static initializer unable to locate SAML assertion schema");
            }
            while (true) {
                void var0_2;
                if ((b = xmlin.read()) == -1) {
                    SAML_schema = buf.toString().getBytes();
                    xmlin.close();
                }
                buf.append((char)var0_2);
            }
            xmlin = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-protocol-01.xsd");
            if (xmlin == null) {
                throw new RuntimeException("XML static initializer unable to locate SAML protocol schema");
            }
            buf.setLength(0);
            while (true) {
                if ((b = xmlin.read()) == -1) {
                    SAMLP_schema = buf.toString().getBytes();
                    xmlin.close();
                }
                buf.append((char)b);
            }
            xmlin = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xmldsig-core-schema.xsd");
            if (xmlin == null) {
                throw new RuntimeException("XML static initializer unable to locate XML Signature schema");
            }
            buf.setLength(0);
            while (true) {
                if ((b = xmlin.read()) == -1) {
                    XMLSig_schema = buf.toString().getBytes();
                    xmlin.close();
                }
                buf.append((char)b);
            }
            xmlin = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xmldsig-filter2.xsd");
            if (xmlin == null) {
                throw new RuntimeException("XML static initializer unable to locate XPath Filter2 schema");
            }
            buf.setLength(0);
            while (true) {
                if ((b = xmlin.read()) == -1) {
                    XPath2_schema = buf.toString().getBytes();
                    xmlin.close();
                }
                buf.append((char)b);
            }
            xmlin = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/soap-envelope.xsd");
            if (xmlin == null) {
                throw new RuntimeException("XML static initializer unable to locate SOAP 1.1 Envelope schema");
            }
            buf.setLength(0);
            while (true) {
                if ((b = xmlin.read()) == -1) {
                    SOAP11Env_schema = buf.toString().getBytes();
                    xmlin.close();
                }
                buf.append((char)b);
            }
            xmlin = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xml.xsd");
            if (xmlin == null) {
                throw new RuntimeException("XM static initializer unable to locate XML core schema");
            }
            buf.setLength(0);
            while (true) {
                if ((b = xmlin.read()) == -1) {
                    XML_schema = buf.toString().getBytes();
                    xmlin.close();
                    return;
                }
                buf.append((char)b);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("XML static initializer caught an I/O error");
        }
    }

    public static class ParserPool
    implements EntityResolver,
    ErrorHandler {
        private Stack pool = new Stack();
        private Vector resolvers = new Vector();
        private String schemaLocations = null;
        private Hashtable schemaLocMap = new Hashtable();

        public ParserPool() {
            this.registerSchema(XML.SAML_NS, XML.SAML_SCHEMA_ID, null);
            this.registerSchema(XML.SAMLP_NS, XML.SAMLP_SCHEMA_ID, null);
            this.registerSchema(XML.SOAP11ENV_NS, XML.SOAP11ENV_SCHEMA_ID, null);
            this.registerSchema(XML.XMLSIG_NS, XML.XMLSIG_SCHEMA_ID, null);
            this.registerSchema(XML.XML_NS, XML.XML_SCHEMA_ID, null);
            this.registerSchema(XML.XPATH2_NS, XML.XPATH2_SCHEMA_ID, null);
            System.setProperty("org.apache.xerces.xni.parser.Configuration", "org.apache.xerces.parsers.XMLGrammarCachingConfiguration");
        }

        public synchronized DOMParser get() throws SAMLException {
            try {
                DOMParser p = null;
                if (this.pool.empty()) {
                    p = new DOMParser();
                    p.setFeature("http://xml.org/sax/features/validation", true);
                    p.setFeature("http://apache.org/xml/features/validation/schema", true);
                    p.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
                    p.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
                    p.setEntityResolver((EntityResolver)this);
                    p.setErrorHandler((ErrorHandler)this);
                } else {
                    p = (DOMParser)this.pool.pop();
                }
                p.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)this.schemaLocations);
                return p;
            }
            catch (SAXException e) {
                throw new SAMLException("XML.ParserPool.get() unable to configure parser properly", (Exception)e);
            }
        }

        public Document parse(InputStream in) throws SAMLException, SAXException, IOException {
            DOMParser p = this.get();
            try {
                p.parse(new InputSource(in));
                Document document = p.getDocument();
                Object var5_4 = null;
                this.put(p);
                return document;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.put(p);
                throw throwable;
            }
        }

        public Document parse(String systemId) throws SAMLException, SAXException, IOException {
            DOMParser p = this.get();
            try {
                p.parse(new InputSource(systemId));
                Document document = p.getDocument();
                Object var5_4 = null;
                this.put(p);
                return document;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.put(p);
                throw throwable;
            }
        }

        public Document newDocument() {
            return new DocumentImpl();
        }

        public synchronized void registerSchema(String namespace, String schema, EntityResolver resolver) {
            if (!(namespace == null || schema == null || this.schemaLocMap.containsKey(namespace) && schema.equals(this.schemaLocMap.get(namespace)))) {
                this.schemaLocMap.put(namespace, schema);
                if (resolver != null) {
                    this.resolvers.add(resolver);
                }
                Iterator i = this.schemaLocMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    this.schemaLocations = this.schemaLocations == null ? e.getKey() + " " + e.getValue() : this.schemaLocations + " " + e.getKey() + " " + e.getValue();
                }
            }
        }

        public synchronized void put(DOMParser p) {
            this.pool.push(p);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            log.debug((Object)("ParserPool resolving entity: publicId = " + publicId + " : systemId = " + systemId));
            InputSource src = null;
            if (systemId.endsWith(XML.SAML_SCHEMA_ID) && SAML_schema != null) {
                src = new InputSource(new ByteArrayInputStream(SAML_schema));
            } else if (systemId.endsWith(XML.SAMLP_SCHEMA_ID) && SAMLP_schema != null) {
                src = new InputSource(new ByteArrayInputStream(SAMLP_schema));
            } else if (systemId.endsWith(XML.XMLSIG_SCHEMA_ID) && XMLSig_schema != null) {
                src = new InputSource(new ByteArrayInputStream(XMLSig_schema));
            } else if (systemId.endsWith(XML.SOAP11ENV_SCHEMA_ID) && SOAP11Env_schema != null) {
                src = new InputSource(new ByteArrayInputStream(SOAP11Env_schema));
            } else if (systemId.endsWith(XML.XML_SCHEMA_ID) && XML_schema != null) {
                src = new InputSource(new ByteArrayInputStream(XML_schema));
            } else if (systemId.endsWith(XML.XPATH2_SCHEMA_ID) && XPath2_schema != null) {
                src = new InputSource(new ByteArrayInputStream(XPath2_schema));
            } else if (this.resolvers != null) {
                Iterator i = ((AbstractList)this.resolvers).iterator();
                while (src == null && i.hasNext()) {
                    src = ((EntityResolver)i.next()).resolveEntity(publicId, systemId);
                }
            }
            if (src != null) {
                log.debug((Object)"entity resolved by ParserPool");
            }
            return src;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
        }

        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }

        public void warning(SAXParseException e) throws SAXParseException {
            log.warn((Object)("Parser warning: line = " + e.getLineNumber() + " : uri = " + e.getSystemId()));
            log.warn((Object)("Parser warning (root cause): " + e.getMessage()));
        }
    }
}

