/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.apache.log4j.Logger;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLDecision;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleAuthorizationDecisionStatement
extends SAMLStatement {
    static final String ELEM_NAME = "SimpleAuthorizationDecisionStatement";
    static final String ATTRIB_DECISION = "Decision";
    static final String ATTRIB_RECIPIENT = "Recipient";
    static final String ATTRIB_IN_RESPONSE_TO = "InResponseTo";
    private SAMLSubject subject = null;
    private String decision = null;
    private String recipient = null;
    private String inResponseTo = null;
    Logger log = Logger.getLogger(this.getClass());

    public SimpleAuthorizationDecisionStatement(SAMLSubject subject, String decision, String recipient, String inResponseTo) throws SAMLException {
        if (subject == null) {
            throw new SAMLException(SAMLException.RESPONDER, "SimpleAuthorizationDecisionStatement() requires subject");
        }
        if (decision == null) {
            throw new SAMLException(SAMLException.RESPONDER, "SimpleAuthorizationDecisionStatement() requires decision");
        }
        if (inResponseTo == null) {
            throw new SAMLException(SAMLException.RESPONDER, "SimpleAuthorizationDecisionStatement() requires attribute inResponseTo");
        }
        this.subject = subject;
        if (!SAMLDecision.valid(decision)) {
            throw new SAMLException(SAMLException.RESPONDER, "Decision must be Permit or Deny or Indeterminate");
        }
        this.decision = decision;
        this.recipient = recipient;
        this.inResponseTo = inResponseTo;
        this.log.debug((Object)("Parameter " + this.decision + " " + this.recipient + " " + this.inResponseTo));
    }

    public SimpleAuthorizationDecisionStatement(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SimpleAuthorizationDecisionStatement(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionStatement")) {
            QName q = QName.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Statement") && XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectStatement") && q != null && "urn:oasis:names:tc:SAML:1.0:protocol".equals(q.getNamespaceURI()) && "AuthorizationDecisionStatementType".equals(q.getLocalName()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SimpleAuthorizationDecisionStatement.fromDOM() requires saml:AuthorizationDecisionStatement at root");
            }
        }
        this.recipient = e.getAttribute(ATTRIB_RECIPIENT);
        if (this.recipient != null && this.recipient.trim().equals("")) {
            this.recipient = null;
        }
        this.log.debug((Object)("Recipient " + this.recipient));
        this.decision = e.getAttribute(ATTRIB_DECISION);
        if (this.decision == null || this.decision.trim().equals("")) {
            throw new MalformedException(SAMLException.REQUESTER, "SimpleAuthorizationDecisionStatement.fromDOM() requires decision attribute");
        }
        this.log.debug((Object)("Decision " + this.decision));
        this.inResponseTo = e.getAttribute(ATTRIB_IN_RESPONSE_TO);
        if (this.inResponseTo == null || this.inResponseTo.trim().equals("")) {
            throw new MalformedException(SAMLException.REQUESTER, "SimpleAuthorizationDecisionStatement.fromDOM() requires inResponseTo attribute");
        }
        this.log.debug((Object)("In response to " + this.inResponseTo));
        Node n = e.getFirstChild();
        while (n != null && n.getNodeType() != 1) {
            n = n.getNextSibling();
        }
        this.subject = new SAMLSubject((Element)n);
    }

    public SAMLSubject getSubject() {
        return this.subject;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getDecision() {
        return this.decision;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element s = doc.createElementNS("http://www.gridforum.org/namespaces/2003/06/ogsa-authz/saml/", ELEM_NAME);
        s.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.gridforum.org/namespaces/2003/06/ogsa-authz/saml/");
        s.setAttributeNS(null, ATTRIB_RECIPIENT, this.recipient);
        s.setAttributeNS(null, ATTRIB_DECISION, this.decision);
        s.setAttributeNS(null, ATTRIB_IN_RESPONSE_TO, this.inResponseTo);
        s.appendChild(this.subject.toDOM(doc));
        this.root = s;
        return this.root;
    }

    public boolean equals(Object obj) {
        SimpleAuthorizationDecisionStatement stmt = (SimpleAuthorizationDecisionStatement)obj;
        if (this.compareStrings(this.decision, stmt.getDecision()) && this.compareStrings(this.recipient, stmt.getRecipient()) && this.compareStrings(this.inResponseTo, stmt.getInResponseTo())) {
            return this.subject.equals(stmt.getSubject());
        }
        return false;
    }
}

