/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.opensaml.Init;
import org.opensaml.InvalidCryptoException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class SAMLSignedObject
extends SAMLObject
implements Cloneable {
    private XMLSignature sig = null;
    private boolean sig_from_parse = false;

    public Object getNativeSignature() {
        return this.sig;
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        Node n = e.getFirstChild();
        while (!(n == null || n.getNodeType() == 1 && XML.isElementNamed((Element)n, "http://www.w3.org/2000/09/xmldsig#", "Signature"))) {
            n = n.getNextSibling();
        }
        if (n != null) {
            try {
                this.sig = new XMLSignature((Element)n, null);
                this.sig_from_parse = true;
            }
            catch (XMLSecurityException ex) {
                throw new InvalidCryptoException("SAMLSignedObject.fromDOM() detected an XML security exception: " + ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new InvalidCryptoException("SAMLSignedObject.fromDOM() detected an I/O exception: " + ex.getMessage(), (Exception)ex);
            }
        }
    }

    public Node toDOM() throws DOMException {
        if (this.root != null) {
            return this.root;
        }
        if (this.sig != null) {
            return this.toDOM(this.sig.getDocument());
        }
        return super.toDOM();
    }

    protected abstract void insertSignature() throws SAMLException;

    protected Element getSignatureElement() {
        return this.sig != null ? this.sig.getElement() : null;
    }

    public void sign(String alg, Key k, Collection certs, boolean simple) throws SAMLException {
        if (this.isSigned()) {
            throw new InvalidCryptoException("SAMLSignedObject.sign() can't sign object a second time");
        }
        this.toDOM();
        this.plantRoot();
        try {
            this.sig = new XMLSignature(this.root.getOwnerDocument(), null, alg);
            this.insertSignature();
            Transforms transforms = new Transforms(this.sig.getDocument());
            if (simple) {
                transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            } else {
                transforms.setXPathNamespaceContext("ds", "http://www.w3.org/2000/09/xmldsig#");
                transforms.setXPathNamespaceContext("signs", this.root.getNamespaceURI());
                String[][] xcFilter = new String[][]{{"intersect", "here()/ancestor::signs:" + this.root.getLocalName() + "[1]"}, {"subtract", "here()/ancestor::ds:Signature[1]"}};
                NodeList xc = XPath2FilterContainer.newInstances((Document)this.sig.getDocument(), (String[][])xcFilter);
                transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", xc);
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                transforms.item(1).getElement().appendChild(new InclusiveNamespaces(this.root.getOwnerDocument(), Init.getProperty("inclusive-namespace-prefixes")).getElement());
            }
            this.sig.addDocument("", transforms);
            X509Data x509 = new X509Data(this.root.getOwnerDocument());
            if (certs != null) {
                Iterator i = certs.iterator();
                while (i.hasNext()) {
                    Object cert = i.next();
                    if (!(cert instanceof X509Certificate)) continue;
                    x509.addCertificate((X509Certificate)cert);
                }
            }
            if (x509.lengthCertificate() > 0) {
                KeyInfo keyinfo = new KeyInfo(this.root.getOwnerDocument());
                keyinfo.add(x509);
                this.sig.getElement().appendChild(keyinfo.getElement());
            }
            this.sig.sign(k);
        }
        catch (XMLSecurityException e) {
            throw new InvalidCryptoException("SAMLSignedObject.sign() detected an XML security exception: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void verify(boolean simple) throws SAMLException {
        this.verify((Key)null, simple);
    }

    public void verify(Certificate cert, boolean simple) throws SAMLException {
        this.verify(cert.getPublicKey(), simple);
    }

    public void verify(Key k, boolean simple) throws SAMLException {
        if (!this.isSigned()) {
            throw new InvalidCryptoException("SAMLSignedObject.verify() can't verify unsigned object");
        }
        try {
            Reference ref;
            boolean valid = false;
            SignedInfo si = this.sig.getSignedInfo();
            if (si.getLength() == 1 && ((ref = si.item(0)).getURI() == null || ref.getURI().equals(""))) {
                NodeList nlist;
                Transforms trans = ref.getTransforms();
                if (simple) {
                    valid = trans.getLength() == 1 && trans.item(0).getURI().equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
                } else if (trans.getLength() == 2 && trans.item(0).getURI().equals("http://www.w3.org/2002/06/xmldsig-filter2") && trans.item(1).getURI().equals("http://www.w3.org/2001/10/xml-exc-c14n#") && (nlist = trans.item(0).getElement().getElementsByTagNameNS("http://www.w3.org/2002/06/xmldsig-filter2", "XPath")).getLength() == 2) {
                    XPath2FilterContainer intersect = XPath2FilterContainer.newInstance((Element)((Element)nlist.item(0)), null);
                    XPath2FilterContainer subtract = XPath2FilterContainer.newInstance((Element)((Element)nlist.item(1)), null);
                    boolean bl = valid = intersect.isIntersect() && intersect.getXPathFilterStr().trim().equals("here()/ancestor::signs:" + this.root.getLocalName() + "[1]") && subtract.isSubtract() && subtract.getXPathFilterStr().trim().equals("here()/ancestor::ds:Signature[1]");
                }
            }
            if (!valid) {
                throw new InvalidCryptoException("SAMLSignedObject.verify() detected an invalid set of signature Transforms");
            }
            if (k == null) {
                if (this.sig_from_parse) {
                    k = this.sig.getKeyInfo().getPublicKey();
                } else {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    Canonicalizer c = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                    out.write(c.canonicalizeSubtree(this.sig.getElement().getLastChild()));
                    ((FilterOutputStream)System.err).write(out.toByteArray());
                    ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                    KeyInfo temp = new KeyInfo(XML.parserPool.parse(in).getDocumentElement(), null);
                    k = temp.getPublicKey();
                }
            }
            if (!this.sig.checkSignatureValue(k)) {
                throw new InvalidCryptoException("SAMLSignedObject.verify() failed to validate signature value");
            }
        }
        catch (XMLSecurityException e) {
            throw new InvalidCryptoException("SAMLSignedObject.verify() detected an XML security exception: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new InvalidCryptoException("SAMLSignedObject.verify() detected an I/O exception: " + e.getMessage(), (Exception)e);
        }
        catch (SAXException e) {
            throw new InvalidCryptoException("SAMLSignedObject.verify() detected a XML parsing exception: " + e.getMessage(), (Exception)e);
        }
    }

    public Iterator getX509Certificates() throws SAMLException {
        if (this.isSigned()) {
            KeyInfo ki = this.sig.getKeyInfo();
            if (ki.containsX509Data()) {
                try {
                    X509Data x509 = ki.itemX509Data(0);
                    if (x509.containsCertificate()) {
                        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(x509.lengthCertificate());
                        int i = 0;
                        while (i < x509.lengthCertificate()) {
                            certs.add(x509.itemCertificate(i).getX509Certificate());
                            ++i;
                        }
                        return ((AbstractList)certs).iterator();
                    }
                }
                catch (XMLSecurityException e) {
                    throw new InvalidCryptoException("SAMLSignedObject.getX509Certificates() detected an XML security exception: " + e.getMessage(), (Exception)((Object)e));
                }
            }
            throw new InvalidCryptoException("SAMLSignedObject.getX509Certificates() can't find any X.509 certificates in signature");
        }
        throw new InvalidCryptoException("SAMLSignedObject.getX509Certificates() can't examine unsigned object");
    }

    public String getSignatureAlgorithm() throws SAMLException {
        if (this.isSigned()) {
            return this.sig.getSignedInfo().getSignatureMethodURI();
        }
        throw new InvalidCryptoException("SAMLSignedObject.getSignatureAlgorithm() can't examine unsigned object");
    }

    public boolean isSigned() {
        return this.sig != null;
    }

    protected Object clone() throws CloneNotSupportedException {
        SAMLSignedObject dup = (SAMLSignedObject)super.clone();
        dup.sig = null;
        return dup;
    }
}

