/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLException;
import org.opensaml.SAMLIdentifier;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLSignedObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SAMLRequest
extends SAMLSignedObject
implements Cloneable {
    private String requestId = null;
    private Date issueInstant = null;
    private ArrayList respondWiths = new ArrayList();
    private SAMLQuery query = null;
    private ArrayList assertionIdRefs = new ArrayList();
    private ArrayList artifacts = new ArrayList();

    protected void insertSignature() throws SAMLException {
        Node n = this.root.getFirstChild();
        while (n != null && n.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith")) {
            n = n.getNextSibling();
        }
        this.root.insertBefore(this.getSignatureElement(), n);
    }

    public SAMLRequest(Collection respondWiths, SAMLQuery query, Collection assertionIdRefs, Collection artifacts) throws SAMLException {
        if (!(query != null || assertionIdRefs != null && assertionIdRefs.size() != 0 || artifacts != null && artifacts.size() != 0)) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLRequest() requires query, assertion references, or artifacts");
        }
        this.issueInstant = new Date();
        this.query = query;
        if (assertionIdRefs != null) {
            this.assertionIdRefs.addAll(assertionIdRefs);
        }
        if (artifacts != null) {
            this.artifacts.addAll(artifacts);
        }
        if (respondWiths != null) {
            this.respondWiths.addAll(respondWiths);
        }
    }

    public SAMLRequest(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLRequest(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Request")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLRequest.fromDOM() requires samlp:Request at root");
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            if (Integer.parseInt(e.getAttributeNS(null, "MajorVersion")) != 1) {
                throw new MalformedException(SAMLException.VERSION, "SAMLRequest() detected incompatible request major version of " + e.getAttributeNS(null, "MajorVersion"));
            }
            this.requestId = e.getAttributeNS(null, "RequestID");
            this.issueInstant = formatter.parse(e.getAttributeNS(null, "IssueInstant"));
            NodeList nlist = e.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
            int i = 0;
            while (nlist != null && i < nlist.getLength()) {
                this.respondWiths.add(QName.getQNameTextNode((Text)nlist.item(i).getFirstChild()));
                ++i;
            }
            nlist = e.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDRef");
            if (nlist != null && nlist.getLength() > 0) {
                int i2 = 0;
                while (i2 < nlist.getLength()) {
                    this.assertionIdRefs.add(nlist.item(i2).getFirstChild().getNodeValue());
                    ++i2;
                }
            } else {
                nlist = e.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact");
                if (nlist != null && nlist.getLength() > 0) {
                    int i3 = 0;
                    while (i3 < nlist.getLength()) {
                        this.artifacts.add(nlist.item(i3).getFirstChild().getNodeValue());
                        ++i3;
                    }
                } else {
                    Node n = e.getLastChild();
                    while (n.getNodeType() != 1) {
                        n = n.getPreviousSibling();
                    }
                    this.query = SAMLQuery.getInstance((Element)n);
                }
            }
        }
        catch (ParseException ex) {
            throw new MalformedException(SAMLException.REQUESTER, "SAMLRequest() detected an invalid datetime while parsing request", (Exception)ex);
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public Iterator getRespondWiths() {
        return ((AbstractList)this.respondWiths).iterator();
    }

    public SAMLQuery getQuery() {
        return this.query;
    }

    public Iterator getAssertionIdRefs() {
        return ((AbstractList)this.assertionIdRefs).iterator();
    }

    public Iterator getArtifacts() {
        return ((AbstractList)this.artifacts).iterator();
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element r = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Request");
        r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        r.setAttributeNS(null, "MajorVersion", "1");
        r.setAttributeNS(null, "MinorVersion", "0");
        this.requestId = new SAMLIdentifier().toString();
        r.setAttributeNS(null, "RequestID", this.requestId);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        r.setAttributeNS(null, "IssueInstant", formatter.format(this.issueInstant));
        Iterator i = ((AbstractList)this.respondWiths).iterator();
        while (i.hasNext()) {
            QName qn = (QName)i.next();
            Element rw = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
            String rwns = qn.getNamespaceURI();
            if (rwns == null) {
                rwns = "";
            }
            if (!"urn:oasis:names:tc:SAML:1.0:assertion".equals(rwns)) {
                rw.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rw", rwns);
                rwns = "rw:";
            } else {
                rw.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
                rwns = "saml:";
            }
            rw.appendChild(doc.createTextNode(rwns + qn.getLocalName()));
            r.appendChild(rw);
        }
        if (this.query != null) {
            r.appendChild(this.query.toDOM(doc));
        } else if (this.assertionIdRefs.size() > 0) {
            i = ((AbstractList)this.assertionIdRefs).iterator();
            while (i.hasNext()) {
                Element aidr = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "saml:AssertionIDRef");
                aidr.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
                r.appendChild(aidr).appendChild(doc.createTextNode((String)i.next()));
            }
        } else {
            i = ((AbstractList)this.artifacts).iterator();
            while (i.hasNext()) {
                r.appendChild(doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionArtifact")).appendChild(doc.createTextNode((String)i.next()));
            }
        }
        this.root = r;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLRequest dup = (SAMLRequest)super.clone();
        dup.respondWiths = (ArrayList)this.respondWiths.clone();
        dup.query = (SAMLQuery)this.query.clone();
        dup.assertionIdRefs = (ArrayList)this.assertionIdRefs.clone();
        dup.artifacts = (ArrayList)this.artifacts.clone();
        return dup;
    }
}

