/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.XML;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SAMLException
extends Exception
implements Cloneable {
    public static final QName SUCCESS = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "Success");
    public static final QName REQUESTER = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "Requester");
    public static final QName RESPONDER = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "Responder");
    public static final QName VERSION = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "VersionMismatch");
    public static final QName REQUEST_DENIED = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "RequestDenied");
    protected String msg = null;
    protected Exception e = null;
    protected ArrayList codes = new ArrayList();
    protected Node root = null;
    protected Logger log = Logger.getLogger(this.getClass());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static SAMLException getInstance(Element e) throws SAMLException {
        NDC.push((String)"getInstance");
        if (e == null) {
            throw new MalformedException(RESPONDER, "SAMLException.getInstance() given an empty DOM");
        }
        try {
            try {
                Node detail = e.getLastChild();
                while (!(detail == null || detail.getNodeType() == 1 && XML.isElementNamed((Element)detail, "urn:oasis:names:tc:SAML:1.0:protocol", "StatusDetail"))) {
                    detail = detail.getPreviousSibling();
                }
                if (detail != null) {
                    String className;
                    Node eclass = detail.getFirstChild();
                    while (!(eclass == null || eclass.getNodeType() == 1 && XML.isElementNamed((Element)eclass, "http://www.opensaml.org", "ExceptionClass"))) {
                        eclass = eclass.getNextSibling();
                    }
                    if (eclass != null && eclass.getFirstChild() != null && eclass.getFirstChild().getNodeType() == 3 && (className = eclass.getFirstChild().getNodeValue()) != null && className.length() > 0) {
                        Class<?> implementation = Class.forName(className);
                        Class[] paramtypes = new Class[]{Class.forName("org.w3c.dom.Element")};
                        Object[] params = new Object[]{e};
                        Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
                        SAMLException sAMLException = (SAMLException)ctor.newInstance(params);
                        Object var10_14 = null;
                        NDC.pop();
                        return sAMLException;
                    }
                }
                Object var10_15 = null;
            }
            catch (ClassNotFoundException ex) {
                Category.getInstance((String)"SAMLException").error((Object)("unable to locate implementation class for exception: " + ex.getMessage()));
                Object var10_16 = null;
                NDC.pop();
                return new SAMLException(e);
            }
            catch (NoSuchMethodException ex) {
                Category.getInstance((String)"SAMLException").error((Object)("unable to bind to constructor for exception: " + ex.getMessage()));
                Object var10_17 = null;
                NDC.pop();
                return new SAMLException(e);
            }
            catch (InstantiationException ex) {
                Category.getInstance((String)"SAMLException").error((Object)("unable to build implementation object for exception: " + ex.getMessage()));
                Object var10_18 = null;
                NDC.pop();
                return new SAMLException(e);
            }
            catch (IllegalAccessException ex) {
                Category.getInstance((String)"SAMLException").error((Object)("unable to access implementation of exception: " + ex.getMessage()));
                Object var10_19 = null;
                NDC.pop();
                return new SAMLException(e);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                Category.getInstance((String)"SAMLException").error((Object)("caught unknown exception while building exception object: " + ex.getTargetException().getMessage()));
                Object var10_20 = null;
                NDC.pop();
                return new SAMLException(e);
            }
            NDC.pop();
            return new SAMLException(e);
        }
        catch (Throwable throwable) {
            Object var10_21 = null;
            NDC.pop();
            throw throwable;
        }
    }

    static SAMLException getInstance(InputStream in) throws SAMLException {
        try {
            Document doc = XML.parserPool.parse(in);
            return SAMLException.getInstance(doc.getDocumentElement());
        }
        catch (SAXException e) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLException").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLException.getInstance() caught exception while parsing a stream", (Exception)e);
        }
        catch (IOException e) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLException").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLException.getInstance() caught exception while parsing a stream", (Exception)e);
        }
    }

    protected SAMLException(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLException(String msg) {
        super(msg);
        this.msg = msg;
    }

    public SAMLException(String msg, Exception e) {
        super(msg);
        this.msg = msg;
        this.e = e;
    }

    public SAMLException(Collection codes, String msg) {
        super(msg);
        this.msg = msg;
        if (codes != null) {
            this.codes.addAll(codes);
        }
    }

    public SAMLException(Collection codes, Exception e) {
        this(codes, (String)null);
        this.e = e;
    }

    public SAMLException(Collection codes, String msg, Exception e) {
        this(codes, msg);
        this.e = e;
    }

    public SAMLException(QName code, String msg) {
        this(msg);
        if (code != null) {
            this.codes.add(code);
        }
    }

    public SAMLException(QName code, Exception e) {
        this(code, (String)null);
        this.e = e;
    }

    public SAMLException(QName code, String msg, Exception e) {
        this(code, msg);
        this.e = e;
    }

    public void fromDOM(Element e) throws SAMLException {
        if (e == null) {
            throw new MalformedException("SAMLException.fromDOM() given an empty DOM");
        }
        this.root = e;
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Status")) {
            throw new MalformedException(RESPONDER, "SAMLException.fromDOM() requires samlp:Status at root");
        }
        Node code = e.getFirstChild();
        while (code != null && code.getNodeType() != 1) {
            code = code.getNextSibling();
        }
        Node m = code.getNextSibling();
        while (m != null && m.getNodeType() != 1) {
            m = m.getNextSibling();
        }
        if (m != null && XML.isElementNamed((Element)m, "urn:oasis:names:tc:SAML:1.0:protocol", "StatusMessage")) {
            this.msg = m.getFirstChild().getNodeValue();
        }
        NodeList nlist = e.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
        int i = 0;
        while (nlist != null && i < nlist.getLength()) {
            QName qptr = QName.getQNameAttribute((Element)nlist.item(i), null, "Value");
            if (qptr == null) {
                throw new MalformedException(RESPONDER, "SAMLException.fromDOM() unable to evaluate QName Value");
            }
            this.codes.add(qptr);
            ++i;
        }
    }

    public void toStream(OutputStream out) throws IOException {
        try {
            Canonicalizer c = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
            out.write(c.canonicalizeSubtree(this.toDOM()));
        }
        catch (InvalidCanonicalizerException e) {
            throw new IOException(e.getMessage());
        }
        catch (CanonicalizationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Node toDOM(Document doc) throws DOMException {
        if (this.root != null) {
            if (this.root.getOwnerDocument() != doc) {
                this.root = doc.importNode(this.root, true);
            }
        } else {
            Element s = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Status");
            if (this.codes == null || this.codes.isEmpty()) {
                Element sc = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
                sc.setAttributeNS(null, "Value", RESPONDER.getLocalName());
                s.appendChild(sc);
            } else {
                Node base = s;
                Iterator i = ((AbstractList)this.codes).iterator();
                while (i.hasNext()) {
                    QName qcode = (QName)i.next();
                    Element sc = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
                    String codens = qcode.getNamespaceURI();
                    if (!codens.equals("urn:oasis:names:tc:SAML:1.0:protocol")) {
                        sc.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:code", codens);
                        codens = "code:";
                    } else {
                        sc.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
                        codens = "samlp:";
                    }
                    sc.setAttributeNS(null, "Value", codens + qcode.getLocalName());
                    base = base.appendChild(sc);
                }
            }
            if (this.getMessage() != null) {
                Element msg = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusMessage");
                msg.appendChild(doc.createTextNode(this.getMessage()));
                s.appendChild(msg);
            }
            if (!(this instanceof SAMLException)) {
                Element detail = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusDetail");
                detail.appendChild(doc.createElementNS("http://www.opensaml.org", "ExceptionClass")).appendChild(doc.createTextNode(this.getClass().getName()));
            }
            this.root = s;
        }
        return this.root;
    }

    public Node toDOM() throws DOMException {
        if (this.root != null) {
            return this.root;
        }
        return this.toDOM(XML.parserPool.newDocument());
    }

    public Iterator getCodes() {
        return ((AbstractList)this.codes).iterator();
    }

    public String getMessage() {
        if (this.msg != null && this.e != null) {
            return this.msg + " (wrapped: " + this.e.getMessage() + ')';
        }
        if (this.e != null) {
            return "(wrapped: " + this.e.getMessage() + ")";
        }
        return this.msg;
    }

    public Exception getException() {
        return this.e;
    }

    public String toString() {
        return this.e != null ? this.e.toString() : super.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLException dup = (SAMLException)super.clone();
        dup.root = null;
        dup.codes = (ArrayList)this.codes.clone();
        return dup;
    }
}

