/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthorizationDecisionStatement
extends SAMLStatement
implements Cloneable {
    private SAMLSubject subject = null;
    private String resource = null;
    private String decision = null;
    private ArrayList actions = new ArrayList();
    private ArrayList evidence = new ArrayList();

    public SAMLAuthorizationDecisionStatement(SAMLSubject subject, String resource, String decision, Collection actions, Collection evidence) throws SAMLException {
        if (subject == null) {
            throw new SAMLException(SAMLException.RESPONDER, "SAMLAuthorizationDecisionStatement() requires subject");
        }
        if (resource == null) {
            throw new SAMLException(SAMLException.RESPONDER, "SAMLAuthorizationDecisionStatement() requires resource");
        }
        if (decision == null) {
            throw new SAMLException(SAMLException.RESPONDER, "SAMLAuthorizationDecisionStatement() requires decision");
        }
        if (actions == null || actions.size() == 0) {
            throw new SAMLException(SAMLException.RESPONDER, "SAMLAuthorizationDecisionStatement() requires at least one action");
        }
        this.subject = subject;
        this.resource = resource;
        this.decision = decision;
        this.actions.addAll(actions);
        if (evidence != null) {
            this.evidence.addAll(evidence);
        }
    }

    public SAMLAuthorizationDecisionStatement(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAuthorizationDecisionStatement(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionStatement")) {
            QName q = QName.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Statement") && XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectStatement") && q != null && "urn:oasis:names:tc:SAML:1.0:protocol".equals(q.getNamespaceURI()) && "AuthorizationDecisionStatementType".equals(q.getLocalName()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAuthorizationDecisionStatement.fromDOM() requires saml:AuthorizationDecisionStatement at root");
            }
        }
        this.resource = e.getAttributeNS(null, "Resource");
        this.decision = e.getAttributeNS(null, "Decision");
        Node n = e.getFirstChild();
        while (n != null && n.getNodeType() != 1) {
            n = n.getNextSibling();
        }
        this.subject = new SAMLSubject((Element)n);
        n = n.getNextSibling();
        while (n != null) {
            if (n.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "Action")) {
                this.actions.add(new SAMLAction((Element)n));
            } else if (n.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "Evidence")) {
                Node n2 = n.getFirstChild();
                while (n2 != null) {
                    if (n2.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
                        this.evidence.add(new SAMLAssertion((Element)n2));
                    } else if (n2.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")) {
                        this.evidence.add(n2.getFirstChild().getNodeValue());
                    }
                    n2 = n2.getNextSibling();
                }
            }
            n = n.getNextSibling();
        }
    }

    public SAMLSubject getSubject() {
        return this.subject;
    }

    public String getResource() {
        return this.resource;
    }

    public String getDecision() {
        return this.decision;
    }

    public Iterator getActions() {
        return ((AbstractList)this.actions).iterator();
    }

    public Collection getActionsCol() {
        return this.actions;
    }

    public Collection getEvidenceCol() {
        return this.evidence;
    }

    public Iterator getEvidence() {
        return ((AbstractList)this.evidence).iterator();
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element s = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement");
        s.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        s.setAttributeNS(null, "Resource", this.resource);
        s.setAttributeNS(null, "Decision", this.decision);
        s.appendChild(this.subject.toDOM(doc));
        Iterator i = ((AbstractList)this.actions).iterator();
        while (i.hasNext()) {
            s.appendChild(((SAMLAction)i.next()).toDOM(doc));
        }
        i = ((AbstractList)this.evidence).iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof SAMLAssertion) {
                s.appendChild(((SAMLAssertion)o).toDOM(doc));
                continue;
            }
            if (!(o instanceof String)) continue;
            s.appendChild(doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")).appendChild(doc.createTextNode((String)o));
        }
        this.root = s;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAuthorizationDecisionStatement dup = (SAMLAuthorizationDecisionStatement)super.clone();
        dup.subject = (SAMLSubject)this.subject.clone();
        Iterator i = ((AbstractList)this.actions).iterator();
        while (i.hasNext()) {
            dup.actions.add(((SAMLAction)i.next()).clone());
        }
        Iterator i2 = ((AbstractList)this.evidence).iterator();
        while (i2.hasNext()) {
            Object o = i2.next();
            if (o instanceof SAMLAssertion) {
                dup.evidence.add(((SAMLAssertion)o).clone());
                continue;
            }
            if (!(o instanceof String)) continue;
            dup.evidence.add(o);
        }
        return dup;
    }

    public boolean equals(Object obj) {
        SAMLAuthorizationDecisionStatement stmt = (SAMLAuthorizationDecisionStatement)obj;
        if (this.compareStrings(this.resource, stmt.getResource()) && this.compareStrings(this.decision, stmt.getDecision()) && this.subject.equals(stmt.getSubject()) && this.actions.containsAll(stmt.getActionsCol())) {
            return this.evidence.containsAll(stmt.getEvidenceCol());
        }
        return false;
    }
}

