/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLAuthorityBinding;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthenticationStatement
extends SAMLStatement
implements Cloneable {
    private SAMLSubject subject = null;
    private String subjectIP = null;
    private String subjectDNS = null;
    private String authMethod = null;
    private Date authInstant = null;
    private ArrayList bindings = new ArrayList();

    public SAMLAuthenticationStatement(SAMLSubject subject, String authMethod, Date authInstant, String subjectIP, String subjectDNS, Collection bindings) throws SAMLException {
        if (subject == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthenticationStatement() requires subject");
        }
        if (authMethod == null || authMethod.length() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthenticationStatement() requires authMethod");
        }
        if (authInstant == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthenticationStatement() requires authInstant");
        }
        if (bindings != null) {
            this.bindings.addAll(bindings);
        }
        this.subject = subject;
        this.subjectIP = subjectIP;
        this.subjectDNS = subjectDNS;
        this.authMethod = authMethod;
        this.authInstant = authInstant;
    }

    public SAMLAuthenticationStatement(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAuthenticationStatement(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        try {
            if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement")) {
                QName q = QName.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
                if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Statement") && q != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(q.getNamespaceURI()) && "AuthenticationStatementType".equals(q.getLocalName()))) {
                    throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthenticationStatement() requires saml:AuthenticationStatement at root");
                }
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.authInstant = formatter.parse(e.getAttributeNS(null, "AuthenticationInstant"));
            this.authMethod = e.getAttributeNS(null, "AuthenticationMethod");
            Node n = e.getFirstChild();
            while (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            this.subject = new SAMLSubject((Element)n);
            n = n.getNextSibling();
            while (n != null && n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            if (n != null && n.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality")) {
                this.subjectIP = ((Element)n).getAttributeNS(null, "IPAddress");
                this.subjectDNS = ((Element)n).getAttributeNS(null, "DNSAddress");
                n = n.getNextSibling();
                while (n != null && n.getNodeType() != 1) {
                    n = n.getNextSibling();
                }
            }
            while (n != null && n.getNodeType() == 1) {
                if (XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding")) {
                    this.bindings.add(new SAMLAuthorityBinding((Element)n));
                }
                n = n.getNextSibling();
                while (n != null && n.getNodeType() != 1) {
                    n = n.getNextSibling();
                }
            }
        }
        catch (ParseException ex) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthenticationStatement() detected an invalid datetime while parsing statement", (Exception)ex);
        }
    }

    public SAMLSubject getSubject() {
        return this.subject;
    }

    public String getSubjectIP() {
        return this.subjectIP;
    }

    public String getSubjectDNS() {
        return this.subjectDNS;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public Date getAuthInstant() {
        return this.authInstant;
    }

    public Iterator getBindings() {
        return ((AbstractList)this.bindings).iterator();
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element statement = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        statement.setAttributeNS(null, "AuthenticationInstant", formatter.format(this.authInstant));
        statement.setAttributeNS(null, "AuthenticationMethod", this.authMethod);
        statement.appendChild(this.subject.toDOM(doc));
        if (this.subjectIP != null && this.subjectIP.length() > 0 || this.subjectDNS != null && this.subjectDNS.length() > 0) {
            Element locality = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
            if (this.subjectIP != null && this.subjectIP.length() > 0) {
                locality.setAttributeNS(null, "IPAddress", this.subjectIP);
            }
            if (this.subjectDNS != null && this.subjectDNS.length() > 0) {
                locality.setAttributeNS(null, "DNSAddress", this.subjectDNS);
            }
            statement.appendChild(locality);
        }
        Iterator i = ((AbstractList)this.bindings).iterator();
        while (i.hasNext()) {
            statement.appendChild(((SAMLAuthorityBinding)i.next()).toDOM(doc));
        }
        this.root = statement;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAuthenticationStatement dup = (SAMLAuthenticationStatement)super.clone();
        Iterator i = ((AbstractList)this.bindings).iterator();
        while (i.hasNext()) {
            dup.bindings.add(((SAMLAuthorityBinding)i.next()).clone());
        }
        return dup;
    }
}

