/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthenticationQuery
extends SAMLQuery
implements Cloneable {
    private SAMLSubject subject = null;
    private String authMethod = null;

    public SAMLAuthenticationQuery(SAMLSubject subject, String authMethod) throws SAMLException {
        if (subject == null || authMethod == null || authMethod.length() == 0) {
            throw new MalformedException(SAMLException.REQUESTER, "SAMLAuthenticationQuery() requires subject and authentication method");
        }
        this.subject = subject;
        this.authMethod = authMethod;
    }

    public SAMLAuthenticationQuery(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAuthenticationQuery(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQuery")) {
            QName q = QName.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Query") && XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectQuery") && q != null && "urn:oasis:names:tc:SAML:1.0:protocol".equals(q.getNamespaceURI()) && "AuthenticationQueryType".equals(q.getLocalName()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAuthenticationQuery.fromDOM() requires samlp:AuthenticationQuery at root");
            }
        }
        this.authMethod = e.getAttributeNS(null, "AuthenticationMethod");
        Node n = e.getFirstChild();
        while (n != null && n.getNodeType() != 1) {
            n = n.getNextSibling();
        }
        this.subject = new SAMLSubject((Element)n);
    }

    public SAMLSubject getSubject() {
        return this.subject;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element q = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQuery");
        q.setAttributeNS(null, "AuthenticationMethod", this.authMethod);
        q.appendChild(this.subject.toDOM(doc));
        this.root = q;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAuthenticationQuery dup = (SAMLAuthenticationQuery)super.clone();
        dup.subject = (SAMLSubject)this.subject.clone();
        return dup;
    }
}

