/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLAudienceRestrictionCondition
extends SAMLCondition
implements Cloneable {
    private ArrayList audiences = new ArrayList();

    public SAMLAudienceRestrictionCondition(Collection audiences) throws SAMLException {
        if (audiences == null || audiences.size() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAudienceRestrictionCondition() requires at least one audience");
        }
        if (audiences != null) {
            this.audiences.addAll(audiences);
        }
    }

    public SAMLAudienceRestrictionCondition(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAudienceRestrictionCondition(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionCondition")) {
            QName q = QName.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Condition") && q != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(q.getNamespaceURI()) && "AudienceRestrictionConditionType".equals(q.getLocalName()))) {
                throw new MalformedException(SAMLException.RESPONDER, "SAMLAudienceRestrictionCondition() requires saml:AudienceRestrictionCondition at root");
            }
        }
        NodeList nlist = e.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Audience");
        int i = 0;
        while (i < nlist.getLength()) {
            this.audiences.add(nlist.item(i).getFirstChild().getNodeValue());
            ++i;
        }
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element condition = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionCondition");
        Iterator i = ((AbstractList)this.audiences).iterator();
        while (i.hasNext()) {
            condition.appendChild(doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Audience")).appendChild(doc.createTextNode((String)i.next()));
        }
        this.root = condition;
        return this.root;
    }

    public boolean eval(Collection audiences) {
        if (audiences == null || audiences.size() == 0) {
            return false;
        }
        Iterator i = audiences.iterator();
        while (i.hasNext()) {
            if (!this.audiences.contains(i.next())) continue;
            return true;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAudienceRestrictionCondition dup = (SAMLAudienceRestrictionCondition)super.clone();
        dup.audiences = (ArrayList)this.audiences.clone();
        return dup;
    }
}

