/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLAttributeStatement
extends SAMLStatement {
    private SAMLSubject subject = null;
    private ArrayList attrs = new ArrayList();

    public SAMLAttributeStatement(SAMLSubject subject, Collection attrs) throws SAMLException {
        if (subject == null || attrs == null || attrs.size() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAttributeStatement() requires subject and at least one attribute");
        }
        this.subject = subject;
        this.attrs.addAll(attrs);
    }

    public SAMLAttributeStatement(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAttributeStatement(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement")) {
            QName q = QName.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Statement") && XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectStatement") && q != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(q.getNamespaceURI()) && "AttributeStatementType".equals(q.getLocalName()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAttributeStatement() requires saml:AttributeStatement at root");
            }
        }
        Node n = e.getFirstChild();
        while (n != null && n.getNodeType() != 1) {
            n = n.getNextSibling();
        }
        this.subject = new SAMLSubject((Element)n);
        NodeList nlist = e.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
        int i = 0;
        while (nlist != null && i < nlist.getLength()) {
            try {
                this.attrs.add(SAMLAttribute.getInstance((Element)nlist.item(i)));
            }
            catch (SAMLException ex) {
                this.log.warn((Object)("exception while instantiating a SAMLAttribute: " + ex.getMessage()));
            }
            ++i;
        }
    }

    public SAMLSubject getSubject() {
        return this.subject;
    }

    public Iterator getAttributes() {
        return ((AbstractList)this.attrs).iterator();
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element statement = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement");
        statement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        statement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        statement.appendChild(this.subject.toDOM(doc));
        Iterator i = ((AbstractList)this.attrs).iterator();
        while (i.hasNext()) {
            statement.appendChild(((SAMLAttribute)i.next()).toDOM(doc));
        }
        this.root = statement;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAttributeStatement dup = (SAMLAttributeStatement)super.clone();
        dup.subject = (SAMLSubject)this.subject.clone();
        Iterator i = ((AbstractList)this.attrs).iterator();
        while (i.hasNext()) {
            dup.attrs.add(((SAMLAttribute)i.next()).clone());
        }
        return dup;
    }
}

