/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLAttributeQuery
extends SAMLQuery
implements Cloneable {
    private SAMLSubject subject = null;
    private String resource = null;
    private ArrayList designators = new ArrayList();

    public SAMLAttributeQuery(SAMLSubject subject, String resource, Collection designators) throws SAMLException {
        if (subject == null) {
            throw new MalformedException(SAMLException.REQUESTER, "SAMLAttributeQuery() requires subject");
        }
        this.subject = subject;
        this.resource = resource;
        if (designators != null) {
            this.designators.addAll(designators);
        }
    }

    public SAMLAttributeQuery(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAttributeQuery(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery")) {
            QName q = QName.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Query") && XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectQuery") && q != null && "urn:oasis:names:tc:SAML:1.0:protocol".equals(q.getNamespaceURI()) && "AttributeQueryType".equals(q.getLocalName()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAttributeQuery() requires samlp:AttributeQuery at root");
            }
        }
        if (e.hasAttributeNS(null, "Resource")) {
            this.resource = e.getAttributeNS(null, "Resource");
        }
        Node n = e.getFirstChild();
        while (n != null && n.getNodeType() != 1) {
            n = n.getNextSibling();
        }
        this.subject = new SAMLSubject((Element)n);
        NodeList nlist = e.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator");
        if (nlist.getLength() > 0) {
            int i = 0;
            while (i < nlist.getLength()) {
                this.designators.add(new SAMLAttribute((Element)nlist.item(i)));
                ++i;
            }
        }
    }

    public SAMLSubject getSubject() {
        return this.subject;
    }

    public String getResource() {
        return this.resource;
    }

    public Iterator getDesignators() {
        return ((AbstractList)this.designators).iterator();
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element q = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery");
        q.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
        if (this.resource != null && this.resource.length() > 0) {
            q.setAttributeNS(null, "Resource", this.resource);
        }
        q.appendChild(this.subject.toDOM(doc));
        Iterator i = ((AbstractList)this.designators).iterator();
        while (i.hasNext()) {
            Element desig = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "saml:AttributeDesignator");
            SAMLAttribute d = (SAMLAttribute)i.next();
            desig.setAttributeNS(null, "AttributeName", d.getName());
            desig.setAttributeNS(null, "AttributeNamespace", d.getNamespace());
            q.appendChild(desig);
        }
        this.root = q;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAttributeQuery dup = (SAMLAttributeQuery)super.clone();
        dup.subject = (SAMLSubject)this.subject.clone();
        Iterator i = ((AbstractList)this.designators).iterator();
        while (i.hasNext()) {
            dup.designators.add(((SAMLAttribute)i.next()).clone());
        }
        return dup;
    }
}

