/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.apache.log4j.Logger;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAttributeDesignator
extends SAMLObject {
    final String ELEM_NAME = "AttributeDesignator";
    final String ATTRIB_NAME = "AttributeName";
    final String ATTRIB_NS = "AttributeNamespace";
    String attributeName = null;
    String attributeNS = null;
    Logger log = Logger.getLogger(this.getClass());

    public SAMLAttributeDesignator(String attribName, String attribNS) throws SAMLException {
        if (attribName == null || attribName.trim().equals("") || attribNS == null || attribNS.trim().equals("")) {
            throw new SAMLException("Attribute name and namespace are required");
        }
        this.attributeName = attribName;
        this.attributeNS = attribNS;
        this.log.debug((Object)("Parameters: " + this.attributeName + " " + this.attributeNS));
    }

    public SAMLAttributeDesignator(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAttributeDesignator(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getAttributeNS() {
        return this.attributeNS;
    }

    public Node toDOM(Document doc) {
        Element attribElem = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeDesignator");
        attribElem.setAttribute("AttributeName", this.attributeName);
        attribElem.setAttribute("AttributeNamespace", this.attributeNS);
        this.root = attribElem;
        return this.root;
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "AttributeDesignator")) {
            throw new MalformedException(SAMLException.REQUESTER, "ExtendedAuthorizationDecisionQuery.fromDOM() requires ogsa-authz:ExtendedAuthorizationDecisionQuery at root");
        }
        String attribName = e.getAttribute("AttributeName");
        if (attribName == null || attribName.trim().equals("")) {
            throw new MalformedException(SAMLException.REQUESTER, "Attribute name is required");
        }
        this.attributeName = attribName;
        this.log.debug((Object)("Attribute name " + this.attributeName));
        String attribNS = e.getAttribute("AttributeNamespace");
        if (attribNS == null || attribNS.trim().equals("")) {
            throw new MalformedException(SAMLException.REQUESTER, "Attribute namespace is required");
        }
        this.attributeNS = attribNS;
        this.log.debug((Object)("Attribute namespace " + this.attributeNS));
    }

    public boolean equals(Object obj) {
        SAMLAttributeDesignator attrib = (SAMLAttributeDesignator)obj;
        if (this.compareStrings(this.attributeName, attrib.getAttributeName())) {
            return this.compareStrings(this.attributeNS, attrib.getAttributeNS());
        }
        return false;
    }
}

