/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAction
extends SAMLObject
implements Cloneable {
    public static final String SAML_ACTION_NAMESPACE = "urn:oasis:names:tc:SAML:1.0:action.rwedc-negation";
    private String namespace = null;
    private String data = null;

    public SAMLAction(String namespace, String data) throws SAMLException {
        this.namespace = namespace != null || namespace.length() == 0 ? namespace : SAML_ACTION_NAMESPACE;
        if (data == null || data.length() == 0) {
            throw new SAMLException("SAMLAction() requires data");
        }
        this.data = data;
    }

    public SAMLAction(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAction(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Action")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAction() requires saml:Action at root");
        }
        this.namespace = e.getAttributeNS(null, "Namespace");
        if (this.namespace == null) {
            this.namespace = SAML_ACTION_NAMESPACE;
        }
        this.data = e.getFirstChild().getNodeValue();
        if (this.data == null || this.data.length() == 0) {
            throw new MalformedException("SAMLAction.fromDOM() requires data");
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getData() {
        return this.data;
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element a = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Action");
        a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        a.setAttributeNS(null, "Namespace", this.namespace);
        a.appendChild(doc.createTextNode(this.data));
        this.root = a;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object action) {
        if (this.compareStrings(this.namespace, ((SAMLAction)action).getNamespace())) {
            return this.compareStrings(this.data, ((SAMLAction)action).getData());
        }
        return false;
    }
}

