/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLAuthorizationDecisionQuery;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLSubject;
import org.opensaml.SubjectAttributeReferenceAdvice;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtendedAuthorizationDecisionQuery
extends SAMLAuthorizationDecisionQuery
implements Cloneable {
    private static String ELEM_NAME = "ExtendedAuthorizationDecisionQuery";
    private String ELEM_TYPE = "ExtendedAuthorizationDecisionQueryType";
    private String ATTRIB_SIMPLE_DECISION = "RequestSimpleDecision";
    private String ATTRIB_RECIPIENT = "Recipient";
    private String ATTRIB_REQUEST_SIGNED = "RequestSigned";
    private ArrayList authzAdvice = new ArrayList();
    private boolean requestSimpleDecision = false;
    private String recipient = null;
    private QName requestSigned = null;
    Logger log = Logger.getLogger(this.getClass());

    public ExtendedAuthorizationDecisionQuery(SAMLSubject subject, String resource, Collection actions, Collection evidence, QName requestSigned, Collection authzAdvice) throws SAMLException {
        this(subject, resource, actions, evidence, false, null, requestSigned, authzAdvice);
    }

    public ExtendedAuthorizationDecisionQuery(SAMLSubject subject, String resource, Collection actions, Collection evidence, String recipient, QName requestSigned, Collection authzAdvice) throws SAMLException {
        this(subject, resource, actions, evidence, false, recipient, requestSigned, authzAdvice);
    }

    public ExtendedAuthorizationDecisionQuery(SAMLSubject subject, String resource, Collection actions, Collection evidence, boolean requestSimpleDecision, QName requestSigned, Collection authzAdvice) throws SAMLException {
        this(subject, resource, actions, evidence, requestSimpleDecision, null, requestSigned, authzAdvice);
    }

    public ExtendedAuthorizationDecisionQuery(SAMLSubject subject, String resource, Collection actions, Collection evidence, boolean requestSimpleDecision, String recipient, QName requestSigned, Collection authzAdvice) throws SAMLException {
        super(subject, resource, actions, evidence);
        this.requestSimpleDecision = requestSimpleDecision;
        this.recipient = recipient;
        if (requestSigned != null && requestSigned.getNamespaceURI() == null) {
            this.requestSigned = new QName("urn:oasis:names:tc:SAML:1.0:protocol", requestSigned.getLocalName());
        }
        if (authzAdvice != null) {
            this.authzAdvice.addAll(authzAdvice);
        }
        this.log.debug((Object)("Parameters " + requestSimpleDecision + " " + recipient));
    }

    public ExtendedAuthorizationDecisionQuery(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public ExtendedAuthorizationDecisionQuery(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public boolean getRequestSimpleDecision() {
        return this.requestSimpleDecision;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public QName getRequestSigned() {
        return this.requestSigned;
    }

    public Iterator getAuthzAdvice() {
        return ((AbstractList)this.authzAdvice).iterator();
    }

    public Collection getAuthzAdviceCol() {
        return this.authzAdvice;
    }

    public void addAuthzAdvice(Collection advice) {
        if (advice != null) {
            this.authzAdvice.addAll(advice);
        }
    }

    public void setRequestSimpleDecision(boolean val) {
        this.requestSimpleDecision = val;
    }

    public void setRecipient(String val) {
        this.recipient = val;
    }

    public void getRequestSigned(QName qName) {
        this.requestSigned = qName;
    }

    public Node toDOM(Document doc) {
        Element extendedAuthzQuery = doc.createElementNS("http://www.gridforum.org/namespaces/2003/06/ogsa-authz/saml/", ELEM_NAME);
        extendedAuthzQuery.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.gridforum.org/namespaces/2003/06/ogsa-authz/saml/");
        super.toDOM(doc, extendedAuthzQuery);
        String simpleDecisionStr = new Boolean(this.requestSimpleDecision).toString();
        extendedAuthzQuery.setAttributeNS(null, this.ATTRIB_SIMPLE_DECISION, simpleDecisionStr);
        if (this.recipient != null) {
            this.log.debug((Object)"Adding recipient");
            extendedAuthzQuery.setAttributeNS(null, this.ATTRIB_RECIPIENT, this.recipient);
        }
        if (this.requestSigned != null) {
            String respondNS = this.requestSigned.getNamespaceURI();
            String localName = this.requestSigned.getLocalName();
            this.log.debug((Object)("Adding request signed. NS " + respondNS + " localName " + localName));
            if (respondNS != null) {
                extendedAuthzQuery.setAttributeNS(null, this.ATTRIB_REQUEST_SIGNED, respondNS + ":" + localName);
            } else {
                extendedAuthzQuery.setAttributeNS(null, this.ATTRIB_REQUEST_SIGNED, "urn:oasis:names:tc:SAML:1.0:protocol:" + localName);
            }
        }
        if (this.authzAdvice != null) {
            Iterator adviceIt = ((AbstractList)this.authzAdvice).iterator();
            while (adviceIt.hasNext()) {
                Object obj = adviceIt.next();
                if (!(obj instanceof SubjectAttributeReferenceAdvice)) continue;
                extendedAuthzQuery.appendChild(((SubjectAttributeReferenceAdvice)obj).toDOM(doc));
            }
        }
        this.root = extendedAuthzQuery;
        return this.root;
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "http://www.gridforum.org/namespaces/2003/06/ogsa-authz/saml/", ELEM_NAME)) {
            QName q = QName.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Query") && XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectQuery") && q != null && "http://www.gridforum.org/namespaces/2003/06/ogsa-authz/saml/".equals(q.getNamespaceURI()) && this.ELEM_TYPE.equals(q.getLocalName()))) {
                throw new MalformedException(SAMLException.REQUESTER, "ExtendedAuthorizationDecisionQuery.fromDOM() requires ogsa-authz:ExtendedAuthorizationDecisionQuery at root");
            }
        }
        this.extractFromDOM(e);
        String simpleDecision = e.getAttribute(this.ATTRIB_SIMPLE_DECISION);
        if (simpleDecision != null && !simpleDecision.trim().equals("")) {
            this.requestSimpleDecision = Boolean.valueOf(simpleDecision);
        }
        this.log.debug((Object)("Simple decision " + this.requestSimpleDecision));
        this.recipient = e.getAttribute(this.ATTRIB_RECIPIENT);
        if (this.recipient != null && this.recipient.trim().equals("")) {
            this.recipient = null;
        }
        this.log.debug((Object)("Recipient " + this.recipient));
        String signElement = e.getAttribute(this.ATTRIB_REQUEST_SIGNED);
        this.log.debug((Object)("Sign element " + signElement));
        if (signElement != null) {
            if (signElement.trim().equals("")) {
                signElement = null;
            } else {
                int index = signElement.lastIndexOf(":");
                if (index != -1) {
                    String ns = signElement.substring(0, index);
                    String name = signElement.substring(index + 1, signElement.length());
                    this.requestSigned = new QName(ns, name);
                }
            }
        }
        NodeList adviceNodes = e.getElementsByTagNameNS("http://www.gridforum.org/namespaces/2003/06/ogsa-authz/saml/", "SubjectAttributeReferenceAdvice");
        int i = 0;
        while (i < adviceNodes.getLength()) {
            SubjectAttributeReferenceAdvice subjectAttr = new SubjectAttributeReferenceAdvice((Element)adviceNodes.item(i));
            this.authzAdvice.add(subjectAttr);
            ++i;
        }
    }

    public boolean equals(Object obj) {
        ExtendedAuthorizationDecisionQuery query = (ExtendedAuthorizationDecisionQuery)obj;
        if (this.requestSimpleDecision == query.getRequestSimpleDecision() && this.compareStrings(this.recipient, query.getRecipient()) && this.compareRequestSigned(query.getRequestSigned()) && this.authzAdvice.containsAll(query.getAuthzAdviceCol()) && this.compareStrings(this.resource, query.getResource()) && this.subject.equals(query.getSubject()) && this.actions.containsAll(query.getActionsCol())) {
            return this.evidence.containsAll(query.getEvidenceCol());
        }
        return false;
    }

    private boolean compareRequestSigned(QName qName) {
        if (this.requestSigned != null) {
            return this.requestSigned.equals(qName);
        }
        return qName == null;
    }
}

