/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.samples.authzService;

import java.rmi.RemoteException;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.impl.security.SecurityMessageElement;
import org.globus.wsrf.samples.authzService.SampleAuthzHome;
import org.globus.wsrf.samples.authzService.SampleAuthzResource;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.SecurityManager;
import org.opensaml.ExtendedAuthorizationDecisionQuery;
import org.opensaml.QName;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthorizationDecisionStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSubject;
import org.opensaml.SimpleAuthorizationDecisionStatement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import protocol._0._1.SAML.tc.names.oasis.Request;
import protocol._0._1.SAML.tc.names.oasis.Response;

public class SampleAuthzService {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$samples$authzService$SampleAuthzService == null ? (class$org$globus$wsrf$samples$authzService$SampleAuthzService = SampleAuthzService.class$("org.globus.wsrf.samples.authzService.SampleAuthzService")) : class$org$globus$wsrf$samples$authzService$SampleAuthzService).getName());
    static /* synthetic */ Class class$org$globus$wsrf$samples$authzService$SampleAuthzService;

    public void addDeclinedMethod(String methodName) throws RemoteException {
        logger.debug((Object)("Declined method: " + methodName));
        try {
            SampleAuthzResource resource = this.getResource();
            resource.addDeclinedMethod(methodName);
        }
        catch (Exception exp) {
            logger.error((Object)exp);
            throw new RemoteException("", exp);
        }
    }

    public Response SAMLRequest(Request requestType) throws RemoteException {
        logger.debug((Object)"In SAMLRequest");
        if (requestType == null) {
            logger.error((Object)"request is null");
            throw new RemoteException("request is null");
        }
        SAMLRequest request = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)XMLUtils.ElementToString((Element)((MessageElement)requestType.get_any()[0].getParentElement()).getAsDOM()));
            }
            request = new SAMLRequest(((MessageElement)requestType.get_any()[0].getParentElement()).getAsDOM());
        }
        catch (Exception exp) {
            String err = "Error extracting SAML Request object ";
            logger.error((Object)err, (Throwable)exp);
            throw new RemoteException(err, exp);
        }
        if (request == null) {
            throw new RemoteException("Request is null");
        }
        if (request.isSigned()) {
            try {
                request.verify(false);
            }
            catch (SAMLException samlExp) {
                String err = "Could not verify signature on request. ";
                logger.error((Object)err, (Throwable)samlExp);
                throw new RemoteException(err, samlExp);
            }
        }
        Iterator respondWiths = request.getRespondWiths();
        boolean valid = false;
        SampleAuthzResource sampleResource = null;
        try {
            sampleResource = this.getResource();
        }
        catch (Exception exp) {
            logger.error((Object)exp);
            throw new RemoteException("", exp);
        }
        QName[] supportedResponse = sampleResource.getSupportedResponse();
        if (respondWiths != null) {
            while (respondWiths.hasNext()) {
                QName qName = (QName)respondWiths.next();
                if (!qName.equals((Object)supportedResponse[0]) && !qName.equals((Object)supportedResponse[1])) continue;
                valid = true;
                break;
            }
        }
        Vector declinedMethods = sampleResource.getDeclinedMethods();
        SAMLException samlException = null;
        Vector<SAMLAssertion> assertions = new Vector<SAMLAssertion>();
        if (valid) {
            SAMLAssertion samlAssertion = null;
            logger.debug((Object)"Valid respondWith found");
            ExtendedAuthorizationDecisionQuery query = (ExtendedAuthorizationDecisionQuery)request.getQuery();
            SAMLSubject subject = query.getSubject();
            logger.debug((Object)("Subject is " + subject.getName()));
            if (subject.getName().equals("*")) {
                logger.debug((Object)"Subject is wildcard, respond with exception");
                samlException = new SAMLException(SAMLException.REQUEST_DENIED, "Request denied. Subject is wildcard");
            }
            Vector stmts = null;
            if (samlException == null) {
                stmts = this.getSAMLStatements(query, subject, request, declinedMethods);
            }
            Calendar notBefore = Calendar.getInstance();
            Calendar notAfter = Calendar.getInstance();
            notAfter.add(12, 10);
            String issuer = "Unique issuer name";
            try {
                samlAssertion = new SAMLAssertion(issuer, notBefore.getTime(), notAfter.getTime(), null, null, (Collection)stmts);
            }
            catch (SAMLException samlExp) {
                String err = "Could not create assertion. ";
                logger.error((Object)err, (Throwable)samlExp);
                throw new RemoteException(err, samlExp);
            }
            assertions.add(samlAssertion);
        }
        SAMLResponse response = null;
        String inResponseTo = request.getRequestId();
        try {
            response = new SAMLResponse(inResponseTo, "recepient", assertions, samlException);
        }
        catch (SAMLException samlExp) {
            String err = "Could not create response. ";
            logger.error((Object)err, (Throwable)samlExp);
            throw new RemoteException(err, samlExp);
        }
        if (request.isSigned()) {
            Subject systemSubject = null;
            try {
                MessageContext ctx = MessageContext.getCurrentContext();
                SecurityManager manager = SecurityManager.getManager((SOAPMessageContext)ctx);
                systemSubject = manager.getServiceSubject();
            }
            catch (SecurityException exp) {
                String err = "Unable to obtain service credentials";
                logger.debug((Object)err, (Throwable)exp);
                throw new RemoteException(err, exp);
            }
            GlobusGSSCredentialImpl credential = (GlobusGSSCredentialImpl)JaasGssUtil.getCredential((Subject)systemSubject);
            Vector certs = this.getCertificates(credential);
            try {
                response.sign("http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Key)credential.getPrivateKey(), (Collection)certs, false);
            }
            catch (SAMLException exp) {
                String err = "Error signing SAMLResponse";
                logger.debug((Object)err, (Throwable)exp);
                throw new RemoteException(err, exp);
            }
        }
        Element responseElement = (Element)response.toDOM();
        NodeList responseChildren = responseElement.getChildNodes();
        ArrayList<SecurityMessageElement> responseElements = new ArrayList<SecurityMessageElement>();
        for (int i = 0; i < responseChildren.getLength(); ++i) {
            Node child = responseChildren.item(i);
            if (!(child instanceof Element)) continue;
            responseElements.add(new SecurityMessageElement((Element)child));
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String issueInstant = formatter.format(response.getIssueInstant());
        Response samlResponse = new Response(responseElements.toArray(new MessageElement[responseElements.size()]), inResponseTo, issueInstant, 1, 0, response.getRecipient(), response.getResponseId());
        return samlResponse;
    }

    private Vector getSAMLStatements(ExtendedAuthorizationDecisionQuery query, SAMLSubject subject, SAMLRequest request, Vector declinedMethods) throws RemoteException {
        logger.debug((Object)"called");
        boolean simpleDecision = query.getRequestSimpleDecision();
        String resource = query.getResource();
        Iterator actionIterator = query.getActions();
        Vector<Object> stmts = new Vector<Object>();
        if (simpleDecision) {
            logger.debug((Object)"Simple decision requested");
            String decision = "Permit";
            if (declinedMethods != null) {
                logger.debug((Object)"Declined methods is not null");
                while (actionIterator.hasNext()) {
                    SAMLAction action = (SAMLAction)actionIterator.next();
                    if (action.getNamespace().equals("http://www.gridforum.org/namespaces/2003/06/ogsa-authorization/saml/action/operation")) {
                        logger.debug((Object)("Correct namespace " + action.getData()));
                        if (!declinedMethods.contains(action.getData())) continue;
                        logger.debug((Object)("Must deny " + action.getData()));
                        decision = "Deny";
                    } else {
                        logger.debug((Object)"Not right namespace, indeterminate");
                        decision = "Indeterminate";
                    }
                    break;
                }
            } else {
                logger.debug((Object)"Declined methods is null");
            }
            SimpleAuthorizationDecisionStatement stmt = null;
            try {
                stmt = new SimpleAuthorizationDecisionStatement(subject, decision, null, request.getRequestId());
            }
            catch (SAMLException samlExp) {
                String err = "Could not create decision stmt. ";
                logger.error((Object)err, (Throwable)samlExp);
                throw new RemoteException(err, samlExp);
            }
            stmts.add(stmt);
        } else {
            SAMLAction action;
            logger.debug((Object)"Not simple decision, need to list all actions");
            String decision = "Permit";
            if (declinedMethods != null) {
                while (actionIterator.hasNext()) {
                    action = (SAMLAction)actionIterator.next();
                    if (!action.getNamespace().equals("http://www.gridforum.org/namespaces/2003/06/ogsa-authorization/saml/action/operation") || !declinedMethods.contains(action.getData())) continue;
                    decision = "Deny";
                    break;
                }
            } else if (actionIterator.hasNext() && !(action = (SAMLAction)actionIterator.next()).getNamespace().equals("http://www.gridforum.org/namespaces/2003/06/ogsa-authorization/saml/action/operation")) {
                decision = "Indeterminate";
            }
            SAMLAuthorizationDecisionStatement stmt = null;
            try {
                stmt = new SAMLAuthorizationDecisionStatement(subject, resource, decision, query.getActionsCol(), null);
            }
            catch (SAMLException samlExp) {
                String err = "Could not create decision stmt. ";
                logger.error((Object)err, (Throwable)samlExp);
                throw new RemoteException(err, samlExp);
            }
            stmts.add(stmt);
        }
        return stmts;
    }

    private SampleAuthzResource getResource() throws Exception {
        ResourceContext ctx = ResourceContext.getResourceContext();
        SampleAuthzHome home = (SampleAuthzHome)ctx.getResourceHome();
        return (SampleAuthzResource)home.find(null);
    }

    private Vector getCertificates(GlobusGSSCredentialImpl credential) {
        X509Certificate[] certArray = credential.getCertificateChain();
        Vector<X509Certificate> certs = null;
        if (certArray.length > 0) {
            logger.debug((Object)"Cert array is not null");
            certs = new Vector<X509Certificate>(certArray.length);
            for (int i = 0; i < certArray.length; ++i) {
                certs.add(certArray[i]);
            }
        } else {
            logger.debug((Object)"Null");
        }
        return certs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

