/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.samples.authzService;

import java.util.StringTokenizer;
import java.util.Vector;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.impl.SimpleResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import org.globus.wsrf.impl.security.authorization.SAMLAuthorizationConstants;
import org.opensaml.QName;

public class SampleAuthzResource
implements Resource,
ResourceProperties {
    public static final javax.xml.namespace.QName RP_SET = new javax.xml.namespace.QName("http://www.gridforum.org/namespaces/2004/03/ogsa-authz/saml", "AuthzServiceRPSet");
    public final QName[] supportedResponse = new QName[]{SAMLAuthorizationConstants.AUTHZ_DECISION, SAMLAuthorizationConstants.SIMPLE_AUTHZ_DECISION};
    protected Object key;
    private ResourcePropertySet propSet;
    Vector declinedMethods = null;

    public SampleAuthzResource() {
        this(Boolean.FALSE, null);
    }

    public QName[] getSupportedResponse() {
        return this.supportedResponse;
    }

    public SampleAuthzResource(Boolean signature, String methodList) {
        this.setRPs(signature);
        if (methodList != null && !methodList.trim().equals("")) {
            StringTokenizer strTok = new StringTokenizer(methodList, ",");
            int length = strTok.countTokens();
            this.declinedMethods = new Vector(length + 1);
            while (strTok.hasMoreTokens()) {
                String methName = strTok.nextToken().trim();
                this.declinedMethods.add(methName);
            }
            int pos = methodList.lastIndexOf(",");
            if (pos == -1) {
                pos = 0;
            }
            this.declinedMethods.add(methodList.substring(0, methodList.length()));
        }
    }

    public void addDeclinedMethod(String methodName) {
        if (this.declinedMethods == null) {
            this.declinedMethods = new Vector();
        }
        this.declinedMethods.add(methodName);
    }

    public Vector getDeclinedMethods() {
        return this.declinedMethods;
    }

    public void setRPs(Boolean signatureCapable) {
        this.propSet = new SimpleResourcePropertySet(RP_SET);
        SimpleResourceProperty indeterminate = new SimpleResourceProperty(SAMLAuthorizationConstants.RP_INDETERMINATE);
        indeterminate.add((Object)Boolean.TRUE);
        SimpleResourceProperty signature = new SimpleResourceProperty(SAMLAuthorizationConstants.RP_SIGNATURE);
        signature.add((Object)signatureCapable);
        this.propSet.add((ResourceProperty)indeterminate);
        this.propSet.add((ResourceProperty)signature);
    }

    public ResourcePropertySet getResourcePropertySet() {
        return this.propSet;
    }
}

