/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.utils.cache;

import commonj.timers.Timer;
import commonj.timers.TimerListener;
import commonj.timers.TimerManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.jndi.Initializable;
import org.globus.wsrf.utils.cache.Cache;
import org.globus.wsrf.utils.cache.LinkedNodeList;

public class LRUCache
implements Initializable,
TimerListener,
Cache {
    private static final int DEFAULT_TIMEOUT = 300000;
    private static final int DEFAULT_DELAY = 120000;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$utils$cache$LRUCache == null ? (class$org$globus$wsrf$utils$cache$LRUCache = LRUCache.class$("org.globus.wsrf.utils.cache.LRUCache")) : class$org$globus$wsrf$utils$cache$LRUCache).getName());
    private Map cache = new HashMap();
    private LinkedNodeList list = new LinkedNodeList();
    private TimerManager timerManager;
    private Timer timer;
    private long timeout = -1L;
    private long delay = -1L;
    private boolean initialized = false;
    static /* synthetic */ Class class$org$globus$wsrf$utils$cache$LRUCache;

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelay() {
        return this.delay;
    }

    public synchronized void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        if (this.timeout == -1L) {
            this.timeout = 300000L;
        }
        if (this.delay == -1L) {
            this.delay = 120000L;
        }
        InitialContext initialContext = new InitialContext();
        this.timerManager = (TimerManager)initialContext.lookup("java:comp/env//timer/ContainerTimer");
        this.initialized = true;
    }

    private synchronized void resetTimer() {
        this.timer = null;
    }

    private synchronized void scheduleTimer() {
        if (this.timer == null) {
            this.timer = this.timerManager.schedule((TimerListener)this, this.delay);
            logger.debug((Object)"scheduling timer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object resource) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("update: " + resource));
        }
        Object object = resource;
        synchronized (object) {
            long currTime = System.currentTimeMillis();
            LinkedNodeList.Node node = (LinkedNodeList.Node)this.cache.get(resource);
            if (node == null) {
                Entry entry = new Entry(resource, currTime);
                node = this.list.createNode(entry);
                this.list.add(node);
                this.cache.put(resource, node);
            } else {
                ((Entry)node.getValue()).setAccessTime(currTime);
                this.list.moveToEnd(node);
            }
        }
        if (this.timer == null) {
            this.scheduleTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object resource) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("remove: " + resource));
        }
        Object object = resource;
        synchronized (object) {
            LinkedNodeList.Node node = (LinkedNodeList.Node)this.cache.get(resource);
            if (node != null) {
                this.list.remove(node);
                this.cache.remove(resource);
                node.setValue(null);
            }
        }
    }

    public synchronized void clear() {
        this.cache.clear();
        this.list.clear();
    }

    public int getSize() {
        return this.cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanExpired() {
        logger.debug((Object)"cleaning cache");
        Iterator iter = null;
        LinkedList<Object> expiredResources = null;
        LinkedNodeList linkedNodeList = this.list;
        synchronized (linkedNodeList) {
            LinkedNodeList.Node n;
            Entry entry;
            iter = this.list.iterator();
            expiredResources = new LinkedList<Object>();
            long currTime = System.currentTimeMillis();
            while (iter.hasNext() && currTime - (entry = (Entry)(n = (LinkedNodeList.Node)iter.next()).getValue()).getAccessTime() > this.timeout) {
                expiredResources.add(entry.getResource());
            }
        }
        iter = expiredResources.iterator();
        while (iter.hasNext()) {
            this.remove(iter.next());
        }
        this.resetTimer();
        if (!this.list.isEmpty()) {
            this.scheduleTimer();
        }
    }

    public void timerExpired(Timer timer) {
        this.cleanExpired();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Entry {
        private long time;
        private Object resource;

        public Entry(Object resource, long time) {
            this.time = time;
            this.resource = resource;
        }

        public void setResource(Object resource) {
            this.resource = resource;
        }

        public Object getResource() {
            return this.resource;
        }

        public void setAccessTime(long time) {
            this.time = time;
        }

        public long getAccessTime() {
            return this.time;
        }
    }
}

