/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.work;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import commonj.work.Work;
import commonj.work.WorkEvent;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import commonj.work.WorkRejectedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.globus.util.I18n;
import org.globus.wsrf.impl.work.WorkEventImpl;
import org.globus.wsrf.impl.work.WorkItemImpl;

public class WorkManagerImpl
implements WorkManager {
    protected static final int MAX_POOL_SIZE = 5;
    private PooledExecutor pool;
    private Map workItems = new HashMap();
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = WorkManagerImpl.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;

    public WorkManagerImpl() {
        this(5);
    }

    public WorkManagerImpl(int maxPoolSize) {
        this.pool = new PooledExecutor((Channel)new LinkedQueue());
        this.setMaximumPoolSize(maxPoolSize);
    }

    public void setMaximumPoolSize(int maxPoolSize) {
        this.pool.setMinimumPoolSize(maxPoolSize);
    }

    public int getMaximumPoolSize() {
        return this.pool.getMinimumPoolSize();
    }

    public synchronized WorkItem schedule(Work work, WorkListener listener) throws WorkException, IllegalArgumentException {
        if (work == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"work"));
        }
        WorkItemImpl workItem = new WorkItemImpl();
        this.workItems.put(work, workItem);
        try {
            if (work.isDaemon()) {
                Thread thread = new Thread(new WorkWrapper(work, listener));
                thread.setName("Work" + thread.getName());
                thread.setDaemon(true);
                thread.start();
            } else {
                this.pool.execute((Runnable)new WorkWrapper(work, listener));
            }
        }
        catch (Exception e) {
            WorkEventImpl event = new WorkEventImpl(2, work);
            this.processEvent(event);
            if (listener != null) {
                listener.workRejected((WorkEvent)event);
            }
            throw new WorkRejectedException((Throwable)e);
        }
        WorkEventImpl event = new WorkEventImpl(1, work);
        this.processEvent(event);
        if (listener != null) {
            listener.workAccepted((WorkEvent)event);
        }
        return workItem;
    }

    public synchronized WorkItem schedule(Work work) throws WorkException, IllegalArgumentException {
        return this.schedule(work, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForAll(Collection workItems, long timeout) {
        Iterator workItemsIterator = workItems.iterator();
        if (timeout == 0L) {
            while (workItemsIterator.hasNext()) {
                int status;
                Object current = workItemsIterator.next();
                if (!(current instanceof WorkItem) || (status = ((WorkItem)current).getStatus()) == 4 || status == 2) continue;
                return false;
            }
        } else if (timeout == Long.MAX_VALUE) {
            while (workItemsIterator.hasNext()) {
                WorkItem workItem;
                Object current = workItemsIterator.next();
                if (!(current instanceof WorkItem)) continue;
                WorkItem workItem2 = workItem = (WorkItem)current;
                synchronized (workItem2) {
                    int status = workItem.getStatus();
                    while (status != 4 && status != 2) {
                        try {
                            workItem.wait();
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                        status = workItem.getStatus();
                    }
                }
            }
        } else {
            long absTimeout = System.currentTimeMillis() + timeout;
            while (workItemsIterator.hasNext()) {
                WorkItem workItem;
                Object current = workItemsIterator.next();
                if (!(current instanceof WorkItem)) continue;
                WorkItem workItem3 = workItem = (WorkItem)current;
                synchronized (workItem3) {
                    int status = workItem.getStatus();
                    while (status != 4 && status != 2) {
                        if (timeout > 0L) {
                            try {
                                workItem.wait(timeout);
                            }
                            catch (InterruptedException e) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        timeout = absTimeout - System.currentTimeMillis();
                        status = workItem.getStatus();
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection waitForAny(Collection workItems, long timeout) {
        Iterator workItemsIterator = workItems.iterator();
        Vector<WorkItem> result = new Vector<WorkItem>();
        if (timeout == 0L) {
            while (workItemsIterator.hasNext()) {
                WorkItem workItem;
                int status;
                Object current = workItemsIterator.next();
                if (!(current instanceof WorkItem) || (status = (workItem = (WorkItem)current).getStatus()) != 4 && status != 2) continue;
                result.add(workItem);
            }
        } else {
            if (timeout == Long.MAX_VALUE) {
                if (this.waitForAll(workItems, timeout)) {
                    return workItems;
                }
                return null;
            }
            long absTimeout = System.currentTimeMillis() + timeout;
            while (workItemsIterator.hasNext()) {
                WorkItem workItem;
                Object current = workItemsIterator.next();
                if (!(current instanceof WorkItem)) continue;
                WorkItem workItem2 = workItem = (WorkItem)current;
                synchronized (workItem2) {
                    int status = workItem.getStatus();
                    while (status != 4 && status != 2 && timeout > 0L) {
                        try {
                            workItem.wait(timeout);
                        }
                        catch (InterruptedException e) {
                            return null;
                        }
                        timeout = absTimeout - System.currentTimeMillis();
                        status = workItem.getStatus();
                    }
                    if (status == 4 || status == 2) {
                        result.add(workItem);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void processEvent(WorkEvent event) {
        WorkItemImpl workItem = (WorkItemImpl)this.workItems.get(event.getWork());
        if (workItem != null) {
            int type = event.getType();
            workItem.setStatus(type);
            if (type == 4 || type == 2) {
                WorkItemImpl workItemImpl = workItem;
                synchronized (workItemImpl) {
                    workItem.notifyAll();
                }
                this.workItems.remove(event.getWork());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class WorkWrapper
    implements Runnable {
        private Work work;
        private WorkListener listener;

        public WorkWrapper(Work work, WorkListener listener) {
            this.work = work;
            this.listener = listener;
        }

        public void run() {
            WorkEventImpl event = new WorkEventImpl(3, this.work);
            WorkManagerImpl.this.processEvent(event);
            if (this.listener != null) {
                this.listener.workStarted((WorkEvent)event);
            }
            this.work.run();
            event = new WorkEventImpl(4, this.work);
            WorkManagerImpl.this.processEvent(event);
            if (this.listener != null) {
                this.listener.workCompleted((WorkEvent)event);
            }
        }
    }
}

