/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.timer;

import commonj.timers.Timer;
import commonj.timers.TimerListener;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.impl.timer.TimerImpl;
import org.globus.wsrf.impl.timer.TimerManagerImpl;

public class TimerListenerWrapper
extends TimerTask {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$timer$TimerListenerWrapper == null ? (class$org$globus$wsrf$impl$timer$TimerListenerWrapper = TimerListenerWrapper.class$("org.globus.wsrf.impl.timer.TimerListenerWrapper")) : class$org$globus$wsrf$impl$timer$TimerListenerWrapper).getName());
    private Timer timer;
    private TimerListener listener;
    private TimerManagerImpl timerManager;
    private boolean suspended = false;
    private boolean expired = false;
    static /* synthetic */ Class class$org$globus$wsrf$impl$timer$TimerListenerWrapper;

    public TimerListenerWrapper(Timer timer, TimerManagerImpl timerManager) {
        this.timer = timer;
        if (timer instanceof TimerImpl) {
            ((TimerImpl)timer).setTimerTask(this);
        }
        this.listener = timer.getTimerListener();
        this.timerManager = timerManager;
    }

    public synchronized void suspend() {
        this.suspended = true;
    }

    public synchronized void resume() {
        this.suspended = false;
        if (this.expired) {
            this.executeTask();
            this.expired = false;
        }
    }

    private void executeTask() {
        try {
            this.listener.timerExpired(this.timer);
        }
        catch (Throwable e) {
            logger.debug((Object)"Timer exception - ignoring", e);
        }
        if (this.timer.getPeriod() == 0L) {
            this.timerManager.removeTask(this);
        }
    }

    public synchronized void run() {
        if (!this.suspended) {
            this.executeTask();
        } else {
            this.expired = true;
        }
    }

    protected boolean stop() {
        return super.cancel();
    }

    public boolean cancel() {
        this.timerManager.removeTask(this);
        return super.cancel();
    }

    protected TimerListener getListener() {
        return this.listener;
    }

    protected Timer getTimer() {
        return this.timer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

