/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.security.gridmap.GridMap;
import org.globus.wsrf.Resource;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.authorization.ServiceAuthorizationChain;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecureResourcePropertiesHelper;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;

public class SecurityPropertiesHelper {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$descriptor$SecurityPropertiesHelper == null ? (class$org$globus$wsrf$impl$security$descriptor$SecurityPropertiesHelper = SecurityPropertiesHelper.class$("org.globus.wsrf.impl.security.descriptor.SecurityPropertiesHelper")) : class$org$globus$wsrf$impl$security$descriptor$SecurityPropertiesHelper).getName());
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$descriptor$SecurityPropertiesHelper;

    public static Integer getContextLifetime(String servicePath, Resource resource) throws ConfigException {
        ContainerSecurityDescriptor containerDesc;
        logger.debug((Object)("getContext lifetime " + servicePath));
        Integer contextLifetime = SecureResourcePropertiesHelper.getContextLifetime(resource);
        if (contextLifetime != null) {
            return contextLifetime;
        }
        ServiceSecurityDescriptor desc = SecurityPropertiesHelper.getSecurityDesc(servicePath);
        if (desc != null) {
            contextLifetime = desc.getContextLifetime();
        }
        if (contextLifetime == null && (containerDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor()) != null) {
            contextLifetime = containerDesc.getContextLifetime();
        }
        return contextLifetime;
    }

    public static Boolean getRejectLimitedProxyState(String servicePath, Resource res) throws ConfigException {
        logger.debug((Object)("getRejectLimitedProxyState " + servicePath));
        String state = SecureResourcePropertiesHelper.getRejectLimitedProxyState(res);
        logger.debug((Object)("State is " + state));
        if (state == null) {
            ContainerSecurityDescriptor containerDesc;
            ServiceSecurityDescriptor desc = SecurityPropertiesHelper.getSecurityDesc(servicePath);
            if (desc != null) {
                state = desc.getRejectLimitedProxyState();
            }
            logger.debug((Object)("Service state is " + state));
            if (state == null && (containerDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor()) != null) {
                logger.debug((Object)"Container desc is not null");
                state = containerDesc.getRejectLimitedProxyState();
            }
        }
        logger.debug((Object)("State is " + state));
        if (state == null) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(state);
    }

    public static String getReplayAttackWindow(String servicePath, Resource resource) throws ConfigException {
        ContainerSecurityDescriptor containerDesc;
        logger.debug((Object)("getReplayAttackWindow for " + servicePath));
        String replayWin = SecureResourcePropertiesHelper.getReplayAttackWindow(resource);
        if (replayWin != null) {
            logger.debug((Object)("Replay Window is " + replayWin));
            return replayWin;
        }
        ServiceSecurityDescriptor desc = ServiceSecurityConfig.getSecurityDescriptor(servicePath);
        if (desc != null) {
            replayWin = desc.getReplayAttackWindow();
        }
        logger.debug((Object)("Replay Window is " + replayWin));
        if (replayWin == null && (containerDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor()) != null) {
            logger.debug((Object)"Container descriptor is null");
            replayWin = containerDesc.getReplayAttackWindow();
        }
        return replayWin;
    }

    public static String getReplayAttackFilter(String servicePath, Resource resource) throws ConfigException {
        ContainerSecurityDescriptor containerDesc;
        logger.debug((Object)("getReplayAttackFilyer for " + servicePath));
        String replayWin = SecureResourcePropertiesHelper.getReplayAttackFilter(resource);
        if (replayWin != null) {
            logger.debug((Object)("Replay Window is " + replayWin));
            return replayWin;
        }
        ServiceSecurityDescriptor desc = ServiceSecurityConfig.getSecurityDescriptor(servicePath);
        if (desc != null) {
            replayWin = desc.getReplayAttackFilter();
        }
        logger.debug((Object)("Replay Window is " + replayWin));
        if (replayWin == null && (containerDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor()) != null) {
            replayWin = containerDesc.getReplayAttackFilter();
        }
        return replayWin;
    }

    public static String getAuthorizationType(String servicePath, Resource resource) throws ConfigException {
        ContainerSecurityDescriptor containerDesc;
        logger.debug((Object)("GetAuthzType " + servicePath));
        String authz = SecureResourcePropertiesHelper.getAuthorizationType(resource);
        if (authz != null) {
            logger.debug((Object)("Auth is " + authz));
            return authz;
        }
        ServiceSecurityDescriptor desc = ServiceSecurityConfig.getSecurityDescriptor(servicePath);
        if (desc != null) {
            authz = desc.getAuthz();
        }
        logger.debug((Object)("Auth is " + authz));
        if (authz == null && (containerDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor()) != null) {
            authz = containerDesc.getAuthz();
        }
        return authz;
    }

    public static GridMap getGridMap(String servicePath, Resource resource) throws ConfigException {
        logger.debug((Object)("getGridMap " + servicePath));
        GridMap obj = SecureResourcePropertiesHelper.getGridMap(resource);
        if (obj != null) {
            return obj;
        }
        obj = ServiceSecurityConfig.getGridMap(servicePath);
        if (obj == null) {
            logger.debug((Object)"Service gridmap null");
            obj = ContainerSecurityConfig.getConfig().getGridMap();
        }
        return obj;
    }

    public static ServiceAuthorizationChain getAuthzChain(String servicePath, Resource resource) throws ConfigException {
        logger.debug((Object)("get authz chain " + servicePath));
        ServiceAuthorizationChain obj = SecureResourcePropertiesHelper.getAuthzChain(resource);
        if (obj != null) {
            logger.debug((Object)"Resource authz is not null");
            return obj;
        }
        logger.debug((Object)("resource authz is null " + servicePath));
        obj = ServiceSecurityConfig.getAuthzChain(servicePath);
        if (obj == null) {
            logger.debug((Object)"service authz is null");
            obj = ContainerSecurityConfig.getConfig().getAuthzChain();
        } else {
            logger.debug((Object)"service authz is not null");
        }
        return obj;
    }

    public static boolean gridMapPresent(String servicePath, Resource resource) throws ConfigException {
        return SecurityPropertiesHelper.getGridMap(servicePath, resource) != null;
    }

    private static ServiceSecurityDescriptor getSecurityDesc(String servicePath) throws ConfigException {
        try {
            ServiceSecurityConfig.initialize(servicePath);
        }
        catch (Exception exp) {
            throw new ConfigException(exp);
        }
        return ServiceSecurityConfig.getSecurityDescriptor(servicePath);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

