/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.security.gridmap.GridMap;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.authorization.ServiceAuthorizationChain;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecurityConfig;
import org.globus.wsrf.impl.security.descriptor.util.ElementParserException;
import org.globus.wsrf.impl.security.util.PDPUtils;
import org.w3c.dom.Document;

public class ResourceSecurityConfig
extends SecurityConfig {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$descriptor$ResourceSecurityConfig == null ? (class$org$globus$wsrf$impl$security$descriptor$ResourceSecurityConfig = ResourceSecurityConfig.class$("org.globus.wsrf.impl.security.descriptor.ResourceSecurityConfig")) : class$org$globus$wsrf$impl$security$descriptor$ResourceSecurityConfig).getName());
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$descriptor$ResourceSecurityConfig;

    public ResourceSecurityConfig(String resourceDescFilename) {
        super(null, resourceDescFilename);
    }

    public ResourceSecurityConfig(ResourceSecurityDescriptor desc) {
        super(desc);
    }

    public void init() throws ConfigException {
        if (this.desc == null) {
            this.loadSecurityDescriptor();
        }
        if (!this.isInitialized()) {
            super.initSecurityDescriptor();
            ((ResourceSecurityDescriptor)this.desc).setInitialized(true);
        }
    }

    protected void initSecurityDescriptor(Document doc) throws ConfigException {
        if (doc != null) {
            this.desc = new ResourceSecurityDescriptor();
            try {
                this.desc.parse(doc.getDocumentElement());
            }
            catch (ElementParserException e) {
                throw new ConfigException((Exception)((Object)e));
            }
        }
    }

    protected void initCredentials() throws ConfigException {
        try {
            this.loadCredentials();
        }
        catch (Exception exp) {
            throw new ConfigException(exp);
        }
    }

    protected void loadAuthorization() throws ConfigException {
        if (this.desc == null) {
            return;
        }
        String authzType = this.desc.getAuthz();
        if (authzType != null) {
            ServiceAuthorizationChain authzChain = PDPUtils.getContainerAuthzChain(authzType, this.jndiPathName);
            this.desc.setAuthzChain(authzChain);
        }
    }

    public void refresh() throws ConfigException {
        logger.debug((Object)"Refresh called");
        if (this.desc.isRefreshRequired()) {
            try {
                this.loadCredentials();
            }
            catch (Exception exp) {
                throw new ConfigException(exp);
            }
        }
    }

    public ResourceSecurityDescriptor getSecurityDescriptor() {
        return (ResourceSecurityDescriptor)this.desc;
    }

    public Subject getSubject() throws ConfigException {
        if (!this.isInitialized()) {
            this.initCredentials();
        } else {
            this.refresh();
        }
        if (this.desc != null) {
            return this.desc.getSubject();
        }
        return null;
    }

    public GridMap getGridMap() throws ConfigException {
        if (!this.isInitialized()) {
            this.loadGridMap();
        }
        if (this.desc != null) {
            return this.desc.getGridMap();
        }
        return null;
    }

    public ServiceAuthorizationChain getAuthzChain() throws ConfigException {
        if (!this.isInitialized()) {
            this.loadAuthorization();
        }
        if (this.desc != null) {
            return this.desc.getAuthzChain();
        }
        return null;
    }

    private boolean isInitialized() {
        if (this.desc != null) {
            return ((ResourceSecurityDescriptor)this.desc).getInitialized();
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

