/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import javax.xml.namespace.QName;
import org.globus.wsrf.impl.security.descriptor.GlobalParamsParserCallback;
import org.globus.wsrf.impl.security.descriptor.util.ElementHandler;
import org.globus.wsrf.impl.security.descriptor.util.ElementParserException;
import org.w3c.dom.Element;

public class GlobalParamsParser
implements ElementHandler {
    public static final String REPLAY_ATTACK_WINDOW = "replay-attack-window";
    public static final String REPLAY_ATTACK_FILTER = "replay-attack-filter";
    public static final String ATTRIB = "value";
    public static final String REJECT_LIMITED_PROXY = "reject-limited-proxy";
    public static final String GRID_MAP = "gridmap";
    public static final String CONTEXT_LIFETIME = "context-lifetime";
    public static final QName CONTEXT_LIFETIME_QNAME = new QName("http://www.globus.org", "context-lifetime");
    public static final QName REJECT_LIMITED_PROXY_QNAME = new QName("http://www.globus.org", "reject-limited-proxy");
    public static final QName GRID_MAP_QNAME = new QName("http://www.globus.org", "gridmap");
    public static final QName REPLAY_ATTACK_FILTER_QNAME = new QName("http://www.globus.org", "replay-attack-filter");
    public static final QName REPLAY_ATTACK_WINDOW_QNAME = new QName("http://www.globus.org", "replay-attack-window");
    protected GlobalParamsParserCallback callback;

    public GlobalParamsParser(GlobalParamsParserCallback callback) {
        this.callback = callback;
    }

    public void parse(Element elem) throws ElementParserException {
        String name = elem.getLocalName();
        if (name.equalsIgnoreCase(REJECT_LIMITED_PROXY)) {
            this.callback.setRejectLimitedProxy(elem.getAttribute(ATTRIB));
        }
        if (name.equalsIgnoreCase(GRID_MAP)) {
            this.callback.setGridMapFile(elem.getAttribute(ATTRIB));
        }
        if (name.equalsIgnoreCase(REPLAY_ATTACK_FILTER)) {
            this.callback.setReplayAttackFilter(elem.getAttribute(ATTRIB));
        }
        if (name.equalsIgnoreCase(REPLAY_ATTACK_WINDOW)) {
            this.callback.setReplayAttackWindow(elem.getAttribute(ATTRIB));
        }
        if (name.equalsIgnoreCase(CONTEXT_LIFETIME)) {
            Integer lifetime = new Integer(elem.getAttribute(ATTRIB));
            this.callback.setContextLifetime(lifetime);
        }
    }
}

