/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import javax.xml.namespace.QName;
import org.globus.gsi.GSIConstants;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.descriptor.ClientParamsParserCallback;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.impl.security.descriptor.util.ElementHandler;
import org.globus.wsrf.impl.security.descriptor.util.ElementParserException;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ClientParamsParser
implements ElementHandler {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.descriptor.errors");
    public static final String AUTHZ_NAME = "authz";
    public static final String ATTRIB = "value";
    public static final QName AUTHZ_QNAME = new QName("http://www.globus.org", "authz");
    public static final QName SEC_CONV_QNAME = new QName("http://www.globus.org", "GSISecureConversation");
    public static final QName SEC_MSG_QNAME = new QName("http://www.globus.org", "GSISecureMessage");
    protected ClientParamsParserCallback callback;

    public ClientParamsParser(ClientParamsParserCallback callback) {
        this.callback = callback;
    }

    public void parse(Element elem) throws ElementParserException {
        String name = elem.getLocalName();
        if (name.equalsIgnoreCase(AUTHZ_NAME)) {
            String val = elem.getAttribute(ATTRIB);
            Authorization authz = AuthUtil.getClientAuthorization(val);
            this.callback.setAuthz(authz);
        } else if (name.equalsIgnoreCase("GSISecureConversation")) {
            boolean protLevelSet = false;
            for (Node currentChild = elem.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                String childName = currentChild.getLocalName();
                if (!protLevelSet && childName.equalsIgnoreCase("integrity")) {
                    this.callback.setGSISecureConv(GSIConstants.SIGNATURE);
                    protLevelSet = true;
                    continue;
                }
                if (!protLevelSet && childName.equalsIgnoreCase("privacy")) {
                    this.callback.setGSISecureConv(GSIConstants.ENCRYPTION);
                    protLevelSet = true;
                    continue;
                }
                if (childName.equalsIgnoreCase("anonymous")) {
                    this.callback.setAnonymous();
                    continue;
                }
                if (childName.equalsIgnoreCase("delegation")) {
                    String val = ((Element)currentChild).getAttribute(ATTRIB);
                    if (val.equalsIgnoreCase("limited")) {
                        this.callback.setDelegation("gsilimited");
                        continue;
                    }
                    if (!val.equalsIgnoreCase("full")) continue;
                    this.callback.setDelegation("gsifull");
                    continue;
                }
                throw new SecurityDescriptorException(i18n.getMessage("unsupportedElement", (Object)childName) + i18n.getMessage("supportSecConv", (Object[])new String[]{"integrity", "privacy", "anonymous", "delegation"}));
            }
        } else if (name.equalsIgnoreCase("GSISecureMessage")) {
            boolean protLevelSet = false;
            for (Node currentChild = elem.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                String childName = currentChild.getLocalName();
                if (!protLevelSet && childName.equalsIgnoreCase("integrity")) {
                    this.callback.setGSISecureMsg(GSIConstants.SIGNATURE);
                    protLevelSet = true;
                    continue;
                }
                if (!protLevelSet && childName.equalsIgnoreCase("privacy")) {
                    this.callback.setGSISecureMsg(GSIConstants.ENCRYPTION);
                    protLevelSet = true;
                    continue;
                }
                if (childName.equalsIgnoreCase("peer-credentials")) {
                    this.callback.setPeerCredentials(((Element)currentChild).getAttribute(ATTRIB));
                    continue;
                }
                throw new SecurityDescriptorException(i18n.getMessage("unsupportedElement", (Object)childName) + i18n.getMessage("supportSecMsg", (Object[])new String[]{"integrity", "privacy", "peer-credentials"}));
            }
        } else {
            String err = i18n.getMessage("unsupportedElement", (Object)name) + i18n.getMessage("supportClient", (Object[])new String[]{AUTHZ_NAME, "GSISecureConversation", "GSISecureMessage"});
            throw new SecurityDescriptorException(err);
        }
    }
}

