/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.SecurityMessageElement;
import org.globus.wsrf.impl.security.authentication.encryption.EncryptionCredentials;
import org.globus.wsrf.impl.security.authorization.IdentityAuthorization;
import org.globus.wsrf.impl.security.authorization.NoAuthorization;
import org.globus.wsrf.impl.security.authorization.SAMLAuthorizationConstants;
import org.globus.wsrf.impl.security.authorization.SelfAuthorization;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.authorization.exceptions.CloseException;
import org.globus.wsrf.impl.security.authorization.exceptions.InitializeException;
import org.globus.wsrf.impl.security.authorization.exceptions.InvalidPolicyException;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.security.authorization.AuthorizationServiceAddressingLocator;
import org.globus.wsrf.security.authorization.PDP;
import org.globus.wsrf.security.authorization.PDPConfig;
import org.globus.wsrf.security.authorization.SAMLRequestPortType;
import org.globus.wsrf.utils.ContextUtils;
import org.opensaml.ExtendedAuthorizationDecisionQuery;
import org.opensaml.QName;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthorizationDecisionStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSubject;
import org.opensaml.SimpleAuthorizationDecisionStatement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import protocol._0._1.SAML.tc.names.oasis.Request;
import protocol._0._1.SAML.tc.names.oasis.Response;

public class SAMLAuthorizationCallout
implements PDP {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authorization.errors", (ClassLoader)(class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout == null ? (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout = SAMLAuthorizationCallout.class$("org.globus.wsrf.impl.security.authorization.SAMLAuthorizationCallout")) : class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout).getClassLoader());
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout == null ? (class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout = SAMLAuthorizationCallout.class$("org.globus.wsrf.impl.security.authorization.SAMLAuthorizationCallout")) : class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout).getName());
    private SAMLRequestPortType authzPort = null;
    private boolean simpleDecision = true;
    private boolean sigReq = false;
    private X509Certificate authzServiceCert = null;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$SAMLAuthorizationCallout;

    public void initialize(PDPConfig config, String name, String id) throws InitializeException {
        String authzServiceIdentity;
        Object mechanism;
        String authzService = null;
        Integer protection = GSIConstants.SIGNATURE;
        String authzServiceCertFile = null;
        authzService = (String)config.getProperty(name, "authzService");
        logger.debug((Object)("Authz service " + authzService));
        if (authzService == null || authzService.trim().equals("")) {
            String err = i18n.getMessage("authzServiceConfig");
            logger.debug((Object)err);
            throw new InitializeException(err);
        }
        authzService = authzService.trim();
        AuthorizationServiceAddressingLocator locator = new AuthorizationServiceAddressingLocator();
        EndpointReferenceType endpoint = new EndpointReferenceType();
        try {
            endpoint.setAddress((AttributedURI)new Address(authzService));
            this.authzPort = locator.getSAMLRequestPortTypePort(endpoint);
        }
        catch (URI.MalformedURIException e) {
            String err = i18n.getMessage("authzServiceInit", (Object)authzService);
            throw new InitializeException(err, (Exception)((Object)e));
        }
        catch (ServiceException e) {
            String err = i18n.getMessage("authzServiceInit", (Object)authzService);
            throw new InitializeException(err, (Exception)((Object)e));
        }
        Stub stub = (Stub)this.authzPort;
        String protectionLevel = (String)config.getProperty(name, "protectionLevel");
        if (protectionLevel != null && protectionLevel.equals("enc")) {
            protection = GSIConstants.ENCRYPTION;
        }
        mechanism = (mechanism = (String)config.getProperty(name, "securityMechanism")) == null || ((String)mechanism).trim().equals("") ? (authzService.startsWith("https") ? "org.globus.security.transport.type" : "org.globus.security.secMsg.msg.type") : (((String)(mechanism = ((String)mechanism).trim())).equals("msg") ? "org.globus.security.secMsg.msg.type" : (((String)mechanism).equals("conv") ? "org.globus.security.secConv.msg.type" : (((String)mechanism).equals("none") ? null : (!authzService.startsWith("https") ? "org.globus.security.secMsg.msg.type" : "org.globus.security.transport.type"))));
        if (mechanism != null) {
            stub._setProperty((String)mechanism, (Object)protection);
            Subject systemSubject = null;
            MessageContext ctx = MessageContext.getCurrentContext();
            SecurityManager manager = SecurityManager.getManager((SOAPMessageContext)ctx);
            try {
                systemSubject = manager.getSystemSubject();
            }
            catch (SecurityException exp) {
                String err = i18n.getMessage("noSystemCreds");
                logger.debug((Object)err, (Throwable)exp);
                throw new InitializeException(err, exp);
            }
            GlobusGSSCredentialImpl credential = (GlobusGSSCredentialImpl)JaasGssUtil.getCredential((Subject)systemSubject);
            stub._setProperty("org.globus.gsi.credentials", (Object)credential);
        }
        if ((authzServiceIdentity = (String)config.getProperty(name, "authzServiceIdentity")) == null || authzServiceIdentity.trim().equals("")) {
            if (mechanism == null) {
                stub._setProperty("org.globus.security.authorization", (Object)NoAuthorization.getInstance());
            } else {
                stub._setProperty("org.globus.security.authorization", (Object)SelfAuthorization.getInstance());
            }
        } else {
            stub._setProperty("org.globus.security.authorization", (Object)new IdentityAuthorization(authzServiceIdentity));
        }
        authzServiceCertFile = (String)config.getProperty(name, "authzServiceCertificateFile");
        if (authzServiceCertFile != null) {
            String err;
            try {
                this.authzServiceCert = CertUtil.loadCertificate((String)authzServiceCertFile);
            }
            catch (IOException ioe) {
                err = i18n.getMessage("encryptionCert", (Object)authzServiceCertFile);
                throw new InitializeException(err, ioe);
            }
            catch (GeneralSecurityException gse) {
                err = i18n.getMessage("encryptionCert", (Object)authzServiceCertFile);
                throw new InitializeException(err, gse);
            }
        } else {
            this.authzServiceCert = (X509Certificate)config.getProperty(name, "authzServiceCertificate");
        }
        if (this.authzServiceCert != null) {
            Subject subject = new Subject();
            EncryptionCredentials encryptionCreds = new EncryptionCredentials(new X509Certificate[]{this.authzServiceCert});
            subject.getPublicCredentials().add(encryptionCreds);
            stub._setProperty("callerSubject", (Object)subject);
        } else {
            String err;
            if (mechanism == "org.globus.security.secMsg.msg.type" && protection == GSIConstants.ENCRYPTION) {
                err = i18n.getMessage("encryptionCertProp", new Object[]{"authzServiceCertificate", "authzServiceCertificateFile"});
                throw new InitializeException(err);
            }
            if (this.sigReq) {
                err = i18n.getMessage("verificationCertProp", new Object[]{"authzServiceCertificate", "authzServiceCertificateFile"});
                throw new InitializeException(err);
            }
        }
        String decisionStr = (String)config.getProperty(name, "samlAuthzSimpleDecision");
        logger.debug((Object)("Decision string " + decisionStr));
        if (decisionStr != null && !decisionStr.trim().equals("")) {
            this.simpleDecision = Boolean.valueOf(decisionStr);
        }
        logger.debug((Object)("Decision value " + this.simpleDecision));
        String signatureRequestedStr = (String)config.getProperty(name, "samlAuthzReqSigned");
        logger.debug((Object)("Request signed string " + signatureRequestedStr));
        if (signatureRequestedStr != null && !signatureRequestedStr.trim().equals("")) {
            this.sigReq = Boolean.valueOf(signatureRequestedStr);
        }
        logger.debug((Object)("Request signed value " + this.sigReq));
    }

    public String[] getPolicyNames() {
        return null;
    }

    public Node getPolicy(Node policy) throws InvalidPolicyException {
        return null;
    }

    public Node setPolicy(Node policy) throws InvalidPolicyException {
        return null;
    }

    public void close() throws CloseException {
    }

    public boolean isPermitted(Subject peerSubject, javax.xml.rpc.handler.MessageContext context, javax.xml.namespace.QName op) throws AuthorizationException {
        String inResponseTo;
        logger.debug((Object)"Authorize invoked");
        String subjectName = null;
        String nameQualifier = null;
        String format = null;
        Vector<String> confirmationMethods = null;
        Set<Principal> peerPrincipals = null;
        if (peerSubject != null) {
            peerPrincipals = peerSubject.getPrincipals();
        }
        MessageContext ctx = (MessageContext)context;
        SecurityManager manager = SecurityManager.getManager((SOAPMessageContext)ctx);
        logger.debug((Object)("caller identity" + manager.getCaller()));
        if (peerPrincipals == null || peerPrincipals.isEmpty()) {
            subjectName = "*";
            format = "http://www.gridforum.org/ogsa-authz/saml/2003/06/NameIdentifier/any";
        } else {
            subjectName = manager.getCaller();
            nameQualifier = null;
            format = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
            confirmationMethods = new Vector<String>(1);
            confirmationMethods.add("urn:oasis:names:tc:SAML:1.0:am:X509-PKI");
        }
        logger.debug((Object)("Subject name " + subjectName + " nameQualifier " + nameQualifier + " format " + format));
        SAMLSubject samlSubject = null;
        try {
            samlSubject = new SAMLSubject(subjectName, nameQualifier, format, confirmationMethods, null, null);
        }
        catch (SAMLException exp) {
            String err = i18n.getMessage("samlObjConstruct", (Object)"SAMLSubject");
            logger.debug((Object)err, (Throwable)exp);
            throw new AuthorizationException(err, exp);
        }
        String resource = null;
        try {
            resource = AuthUtil.getEPRAsString(ctx);
        }
        catch (SecurityException exp) {
            String err = i18n.getMessage("resourceErr");
            logger.debug((Object)err, (Throwable)exp);
            throw new AuthorizationException(err, exp);
        }
        String operationName = op.getLocalPart();
        logger.debug((Object)("Operation name " + operationName));
        Vector<SAMLAction> samlActions = new Vector<SAMLAction>();
        try {
            SAMLAction samlAction = new SAMLAction("http://www.gridforum.org/namespaces/2003/06/ogsa-authorization/saml/action/operation", operationName);
            samlActions.add(samlAction);
        }
        catch (SAMLException exp) {
            String err = i18n.getMessage("samlObjConstruct", (Object)"SAMLAction");
            logger.debug((Object)err, (Throwable)exp);
            throw new AuthorizationException(err, exp);
        }
        ExtendedAuthorizationDecisionQuery extendedQuery = null;
        try {
            QName signQName = new QName(null, "SAMLResponse");
            extendedQuery = new ExtendedAuthorizationDecisionQuery(samlSubject, resource, samlActions, null, this.simpleDecision, signQName, null);
        }
        catch (SAMLException exp) {
            String err = i18n.getMessage("samlObjConstruct", (Object)"SAMLAuthzDecisionQuery");
            logger.debug((Object)err, (Throwable)exp);
            throw new AuthorizationException(err, exp);
        }
        Vector<QName> respondWith = new Vector<QName>();
        if (this.simpleDecision) {
            respondWith.add(SAMLAuthorizationConstants.SIMPLE_AUTHZ_DECISION);
        } else {
            respondWith.add(SAMLAuthorizationConstants.AUTHZ_DECISION);
        }
        SAMLRequest request = null;
        try {
            request = new SAMLRequest(respondWith, (SAMLQuery)extendedQuery, null, null);
        }
        catch (SAMLException exp) {
            String err = i18n.getMessage("samlObjConstruct", (Object)"SAMLRequest");
            logger.debug((Object)err, (Throwable)exp);
            throw new AuthorizationException(err, exp);
        }
        if (this.sigReq) {
            logger.debug((Object)"Signature required");
            Subject systemSubject = null;
            try {
                systemSubject = manager.getSystemSubject();
            }
            catch (SecurityException exp) {
                String err = i18n.getMessage("noSystemCreds");
                logger.debug((Object)err, (Throwable)exp);
                throw new AuthorizationException(err, exp);
            }
            GlobusGSSCredentialImpl credential = (GlobusGSSCredentialImpl)JaasGssUtil.getCredential((Subject)systemSubject);
            Vector certs = this.getCertificates(credential);
            try {
                request.sign("http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Key)credential.getPrivateKey(), (Collection)certs, false);
            }
            catch (SAMLException exp) {
                String err = i18n.getMessage("samlSign");
                logger.debug((Object)err, (Throwable)exp);
                throw new AuthorizationException(err, exp);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)XMLUtils.ElementToString((Element)((Element)request.toDOM())));
        }
        Element requestElement = (Element)request.toDOM();
        NodeList requestChildren = requestElement.getChildNodes();
        ArrayList<SecurityMessageElement> requestElements = new ArrayList<SecurityMessageElement>();
        for (int i = 0; i < requestChildren.getLength(); ++i) {
            Node child = requestChildren.item(i);
            if (!(child instanceof Element)) continue;
            requestElements.add(new SecurityMessageElement((Element)child));
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String issueInstant = formatter.format(request.getIssueInstant());
        Request requestType = new Request(requestElements.toArray(new MessageElement[requestElements.size()]), issueInstant, 1, 0, request.getRequestId());
        String targetServicePath = ContextUtils.getTargetServicePath(ctx);
        logger.debug((Object)("Target Service Path: " + targetServicePath));
        Response responseType = null;
        try {
            responseType = this.authzPort.SAMLRequest(requestType);
        }
        catch (Exception exp) {
            String err = i18n.getMessage("authzService", ((Stub)this.authzPort)._getProperty("javax.xml.rpc.service.endpoint.address"));
            logger.debug((Object)err, (Throwable)exp);
            throw new AuthorizationException(err, exp);
        }
        if (responseType == null) {
            String err = i18n.getMessage("nullResponse");
            logger.debug((Object)err);
            throw new AuthorizationException(err);
        }
        SAMLResponse response = null;
        try {
            response = new SAMLResponse(((MessageElement)responseType.get_any()[0].getParentElement()).getAsDOM());
        }
        catch (Exception exp) {
            logger.debug((Object)("Eception is of type " + exp.getClass().getName()));
            if (exp instanceof SAMLException) {
                logger.debug((Object)"", (Throwable)exp);
                throw new AuthorizationException(exp.getMessage(), exp);
            }
            String err = i18n.getMessage("badResponse");
            logger.debug((Object)err, (Throwable)exp);
            throw new AuthorizationException(err, exp);
        }
        if (this.sigReq) {
            if (response.isSigned()) {
                try {
                    response.verify((Certificate)this.authzServiceCert, false);
                }
                catch (SAMLException samlExp) {
                    String err = i18n.getMessage("badResponseSig");
                    logger.debug((Object)err, (Throwable)samlExp);
                    throw new AuthorizationException(err, samlExp);
                }
            } else {
                String err = i18n.getMessage("responseSigRequired");
                throw new AuthorizationException(err);
            }
        }
        if ((inResponseTo = response.getInResponseTo()) == null || !inResponseTo.equals(request.getRequestId())) {
            String err = i18n.getMessage("badInResponseTo");
            logger.debug((Object)err);
            throw new AuthorizationException(err);
        }
        boolean valid = false;
        Iterator assertionsItr = response.getAssertions();
        logger.debug((Object)"Getting assertions");
        if (assertionsItr != null && assertionsItr.hasNext()) {
            logger.debug((Object)"assertions present");
            SAMLAssertion assertion = (SAMLAssertion)assertionsItr.next();
            Iterator stmtsItr = assertion.getStatements();
            if (stmtsItr != null && stmtsItr.hasNext()) {
                Object obj = stmtsItr.next();
                if (this.simpleDecision) {
                    if (obj instanceof SimpleAuthorizationDecisionStatement) {
                        valid = this.processSimpleAuthzStmt(obj, samlSubject);
                    }
                } else if (obj instanceof SAMLAuthorizationDecisionStatement) {
                    valid = this.processAuthzStmt(obj, resource, samlActions, samlSubject);
                }
            }
        }
        if (!valid) {
            logger.warn((Object)i18n.getMessage("samlAuthFailed"));
        }
        return valid;
    }

    private boolean processSimpleAuthzStmt(Object statement, SAMLSubject samlSubject) {
        logger.debug((Object)"Process simple authz stmt");
        SimpleAuthorizationDecisionStatement stmt = (SimpleAuthorizationDecisionStatement)statement;
        if (stmt.getDecision().equals("Permit")) {
            logger.debug((Object)"decision is permit");
            return samlSubject.equals(stmt.getSubject());
        }
        return false;
    }

    private boolean processAuthzStmt(Object statement, String resource, Vector actions, SAMLSubject samlSubject) {
        logger.debug((Object)"Process authz stmt ");
        SAMLAuthorizationDecisionStatement stmt = (SAMLAuthorizationDecisionStatement)statement;
        if (stmt.getDecision().equals("Permit") && stmt.getResource().equals(resource)) {
            logger.debug((Object)"permit and resource");
            if (samlSubject.equals(stmt.getSubject()) && stmt.getActionsCol() != null) {
                return stmt.getActionsCol().containsAll(actions);
            }
        }
        return false;
    }

    private Vector getCertificates(GlobusGSSCredentialImpl credential) {
        X509Certificate[] certArray = credential.getCertificateChain();
        Vector<X509Certificate> certs = null;
        if (certArray.length > 0) {
            logger.debug((Object)"Cert array is not null");
            certs = new Vector<X509Certificate>(certArray.length);
            for (int i = 0; i < certArray.length; ++i) {
                certs.add(certArray[i]);
            }
        } else {
            logger.debug((Object)"Null");
        }
        return certs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

