/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.authorization.exceptions.CloseException;
import org.globus.wsrf.impl.security.authorization.exceptions.InitializeException;
import org.globus.wsrf.impl.security.authorization.exceptions.InvalidPolicyException;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.security.authorization.PDP;
import org.globus.wsrf.security.authorization.PDPConfig;
import org.w3c.dom.Node;

public class LocalConfigPDP
implements PDP {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authorization.errors", (ClassLoader)(class$org$globus$wsrf$impl$security$authorization$LocalConfigPDP == null ? (class$org$globus$wsrf$impl$security$authorization$LocalConfigPDP = LocalConfigPDP.class$("org.globus.wsrf.impl.security.authorization.LocalConfigPDP")) : class$org$globus$wsrf$impl$security$authorization$LocalConfigPDP).getClassLoader());
    public static final String SECURITY_CONFIG_FILE = "authzConfigFile";
    public static final String DEFAULT_SECURITY_CONFIG_FILE = "service-authz.conf";
    public static final String[] CONFIG_LOCATIONS = new String[]{"", ".", "/etc", "/etc/grid-security"};
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authorization$LocalConfigPDP == null ? (class$org$globus$wsrf$impl$security$authorization$LocalConfigPDP = LocalConfigPDP.class$("org.globus.wsrf.impl.security.authorization.LocalConfigPDP")) : class$org$globus$wsrf$impl$security$authorization$LocalConfigPDP).getName());
    private String configFileName = null;
    private File configFile = null;
    private Map userRightsMap = new HashMap();
    private long configLastModified = 0L;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$LocalConfigPDP;

    public void initialize(PDPConfig config, String name, String id) throws InitializeException {
        this.configFileName = this.getConfigFileName(config, name);
        this.configFile = this.findConfigFile(this.configFileName);
        if (this.configFile != null) {
            this.userRightsMap = this.readConfigFile(this.configFile);
        }
    }

    public String[] getPolicyNames() {
        return null;
    }

    public boolean isPermitted(Subject peer, MessageContext context, QName op) throws AuthorizationException {
        Object allowedOpsList;
        String operation = op.toString();
        String peerIdentity = AuthUtil.getIdentity(peer);
        if (this.configFile == null) {
            this.configFile = this.findConfigFile(this.configFileName);
        }
        if (this.configFile == null) {
            logger.warn((Object)i18n.getMessage("noSecConfig"));
            return false;
        }
        logger.debug((Object)("Last modification time: " + this.configFile.lastModified()));
        if (this.configLastModified < this.configFile.lastModified()) {
            this.userRightsMap = this.readConfigFile(this.configFile);
        }
        if ((allowedOpsList = this.userRightsMap.get(peerIdentity)) == null) {
            logger.warn((Object)i18n.getMessage("noSubjFile", (Object)peerIdentity));
            return false;
        }
        return ((List)allowedOpsList).contains(operation);
    }

    private File findConfigFile(String fileName) {
        File configFile = null;
        for (int i = 0; i < CONFIG_LOCATIONS.length; ++i) {
            String filePath = CONFIG_LOCATIONS[i].equals("") ? fileName : CONFIG_LOCATIONS[i] + File.separator + fileName;
            configFile = new File(filePath);
            logger.debug((Object)("Trying authz file: " + configFile.getAbsolutePath()));
            if (configFile.exists()) {
                logger.debug((Object)("Security config file found: " + configFile.getAbsolutePath()));
                break;
            }
            configFile = null;
        }
        return configFile;
    }

    private String getConfigFileName(PDPConfig config, String name) {
        Object configFile = config.getProperty(name, SECURITY_CONFIG_FILE);
        return configFile == null ? DEFAULT_SECURITY_CONFIG_FILE : (String)configFile;
    }

    private Map readConfigFile(File configFile) {
        logger.debug((Object)("Reading config file: " + configFile.getAbsolutePath()));
        HashMap authzMap = new HashMap();
        Properties accessMap = new Properties();
        try {
            accessMap.load(new FileInputStream(configFile));
            this.configLastModified = this.configFile.lastModified();
        }
        catch (IOException e) {
            logger.warn((Object)("Could not read security config file " + configFile.getAbsolutePath()));
            return new HashMap();
        }
        Enumeration<?> subjects = accessMap.propertyNames();
        while (subjects.hasMoreElements()) {
            String subject = (String)subjects.nextElement();
            String rights = accessMap.getProperty(subject);
            logger.debug((Object)("  Subject: \"" + subject + "\"\n" + "  Rights: \"" + rights + "\""));
            ArrayList<String> allowedOps = new ArrayList<String>();
            StringTokenizer opsTokenizer = new StringTokenizer(rights, ",;");
            while (opsTokenizer.hasMoreTokens()) {
                String op = opsTokenizer.nextToken();
                allowedOps.add(op.trim());
            }
            authzMap.put(subject, allowedOps);
        }
        return authzMap;
    }

    public Node getPolicy(Node policy) throws InvalidPolicyException {
        return null;
    }

    public Node setPolicy(Node policy) throws InvalidPolicyException {
        return null;
    }

    public void close() throws CloseException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

