/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.BasicSubjectAuthorization;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.authorization.exceptions.CloseException;
import org.globus.wsrf.impl.security.authorization.exceptions.InitializeException;
import org.globus.wsrf.impl.security.authorization.exceptions.InvalidPolicyException;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.security.authorization.PDP;
import org.globus.wsrf.security.authorization.PDPConfig;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.w3c.dom.Node;

public class IdentityAuthorization
extends BasicSubjectAuthorization
implements Authorization,
PDP {
    protected Subject subject;
    static final String IDENTITY_PROP = "identity";
    static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authorization.errors", (ClassLoader)(class$org$globus$wsrf$impl$security$authorization$IdentityAuthorization == null ? (class$org$globus$wsrf$impl$security$authorization$IdentityAuthorization = IdentityAuthorization.class$("org.globus.wsrf.impl.security.authorization.IdentityAuthorization")) : class$org$globus$wsrf$impl$security$authorization$IdentityAuthorization).getClassLoader());
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$IdentityAuthorization;

    public IdentityAuthorization() {
    }

    public IdentityAuthorization(Subject subject_) {
        this.subject = subject_;
    }

    public IdentityAuthorization(String globusIdentity) {
        this.subject = new Subject();
        this.subject.getPrincipals().add((Principal)new GlobusPrincipal(globusIdentity));
    }

    public void initialize(PDPConfig config, String name, String id) throws InitializeException {
        if (this.subject == null) {
            if (config == null) {
                throw new InitializeException(i18n.getMessage("pdpConfigReq"));
            }
            String identity = (String)config.getProperty("idenAuthz", IDENTITY_PROP);
            if (identity == null) {
                throw new InitializeException(i18n.getMessage("idenitytNull"));
            }
            this.subject = new Subject();
            this.subject.getPrincipals().add((Principal)new GlobusPrincipal(identity));
        }
    }

    public String[] getPolicyNames() {
        return null;
    }

    public Node getPolicy(Node policy) throws InvalidPolicyException {
        return null;
    }

    public Node setPolicy(Node policy) throws InvalidPolicyException {
        return null;
    }

    public void close() throws CloseException {
    }

    public boolean isPermitted(Subject peerSubject, MessageContext context, QName op) throws AuthorizationException {
        return this.authorize(this.subject, peerSubject, context);
    }

    public void authorize(Subject peerSubject, MessageContext context) throws AuthorizationException {
        if (!this.authorize(this.subject, peerSubject, context)) {
            throw new AuthorizationException(i18n.getMessage("authFail"));
        }
    }

    public String getIdentity() {
        return AuthUtil.getIdentity(this.subject);
    }

    public GSSName getName(MessageContext ctx) throws AuthorizationException {
        if (this.subject == null) {
            throw new IllegalArgumentException(i18n.getMessage("noLocalSubject"));
        }
        try {
            Set<Principal> principals = this.subject.getPrincipals();
            if (principals == null || principals.isEmpty()) {
                return null;
            }
            String identity = principals.iterator().next().getName();
            GSSManager manager = ExtendedGSSManager.getInstance();
            return manager.createName(identity, null);
        }
        catch (GSSException e) {
            throw new AuthorizationException(i18n.getMessage("authFail"), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

