/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import java.net.MalformedURLException;
import java.net.URL;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.authorization.exceptions.CloseException;
import org.globus.wsrf.impl.security.authorization.exceptions.InitializeException;
import org.globus.wsrf.impl.security.authorization.exceptions.InvalidPolicyException;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.security.authorization.PDP;
import org.globus.wsrf.security.authorization.PDPConfig;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.w3c.dom.Node;

public class HostAuthorization
implements PDP,
Authorization {
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authorization.errors", (ClassLoader)(class$org$globus$wsrf$impl$security$authorization$HostAuthorization == null ? (class$org$globus$wsrf$impl$security$authorization$HostAuthorization = HostAuthorization.class$("org.globus.wsrf.impl.security.authorization.HostAuthorization")) : class$org$globus$wsrf$impl$security$authorization$HostAuthorization).getClassLoader());
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authorization$HostAuthorization == null ? (class$org$globus$wsrf$impl$security$authorization$HostAuthorization = HostAuthorization.class$("org.globus.wsrf.impl.security.authorization.HostAuthorization")) : class$org$globus$wsrf$impl$security$authorization$HostAuthorization).getName());
    GSSName expected = null;
    private String service = "host";
    private PDPConfig pdpConfig = null;
    private String namePrefix = null;
    public static final String URL_PROPERTY = "url";
    public static final String SERVICE_PROPERTY = "service";
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$HostAuthorization;

    public HostAuthorization() {
    }

    public HostAuthorization(String service) {
        if (service == null) {
            this.service = service;
        }
    }

    public static synchronized HostAuthorization getInstance() {
        return new HostAuthorization();
    }

    public void initialize(PDPConfig config, String name, String _servicePath) throws InitializeException {
        this.pdpConfig = config;
        this.namePrefix = name;
    }

    public String[] getPolicyNames() {
        return null;
    }

    public Node getPolicy(Node policy) throws InvalidPolicyException {
        return null;
    }

    public Node setPolicy(Node policy) throws InvalidPolicyException {
        return null;
    }

    public void close() throws CloseException {
    }

    public boolean isPermitted(Subject peerSubject, MessageContext context, QName op) throws AuthorizationException {
        URL url = (URL)this.pdpConfig.getProperty(this.namePrefix, URL_PROPERTY);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("URL " + url));
        }
        if (url == null) {
            logger.debug((Object)i18n.getMessage("hostNull"));
            throw new AuthorizationException(i18n.getMessage("hostNull"));
        }
        String serviceProp = (String)this.pdpConfig.getProperty(this.namePrefix, SERVICE_PROPERTY);
        if (serviceProp != null) {
            this.service = serviceProp;
        }
        this.expected = this.getName(url);
        String peerIdentity = AuthUtil.getIdentity(peerSubject);
        return this.authorize(peerIdentity);
    }

    public void authorize(Subject peerSubject, MessageContext context) throws AuthorizationException {
        this.expected = this.getName(context);
        String peerIdentity = AuthUtil.getIdentity(peerSubject);
        if (!this.authorize(peerIdentity)) {
            logger.warn((Object)i18n.getMessage("hostAuthFail", new Object[]{this.expected, peerIdentity}));
            throw new AuthorizationException(i18n.getMessage("hostAuthFail", new Object[]{this.expected, peerIdentity}));
        }
    }

    private boolean authorize(String peerIdentity) throws AuthorizationException {
        if (peerIdentity == null) {
            logger.debug((Object)i18n.getMessage("anonPeer"));
            throw new AuthorizationException(i18n.getMessage("anonPeer"));
        }
        try {
            GSSName target = ExtendedGSSManager.getInstance().createName(peerIdentity, null);
            if (!this.expected.equals(target)) {
                logger.debug((Object)i18n.getMessage("hostAuthFail", new Object[]{this.expected, peerIdentity}));
                return false;
            }
        }
        catch (GSSException e) {
            throw new AuthorizationException(i18n.getMessage("authFail"), e);
        }
        return true;
    }

    public GSSName getName(MessageContext ctx) throws AuthorizationException {
        URL endpoint = null;
        try {
            endpoint = AuthUtil.getEndpointAddressURL(ctx);
        }
        catch (MalformedURLException e) {
            throw new AuthorizationException(i18n.getMessage("authFail"), e);
        }
        return this.getName(endpoint);
    }

    public GSSName getName(URL endpoint) throws AuthorizationException {
        GSSName expected = null;
        try {
            GSSManager manager = ExtendedGSSManager.getInstance();
            expected = manager.createName(this.service + "@" + endpoint.getHost(), GSSName.NT_HOSTBASED_SERVICE);
        }
        catch (GSSException e) {
            throw new AuthorizationException(i18n.getMessage("authFail"), e);
        }
        return expected;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

