/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.wssec;

import commonj.timers.TimerListener;
import commonj.timers.TimerManager;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.wssec.ExpiredMessageIdTimerListener;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityException;

public class ReplayAttackFilter {
    protected static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authentication.wssec.errors");
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authentication$wssec$ReplayAttackFilter == null ? (class$org$globus$wsrf$impl$security$authentication$wssec$ReplayAttackFilter = ReplayAttackFilter.class$("org.globus.wsrf.impl.security.authentication.wssec.ReplayAttackFilter")) : class$org$globus$wsrf$impl$security$authentication$wssec$ReplayAttackFilter).getName());
    private static int DEFAULT_WINDOW_RANGE = 5;
    private static int WINDOW_RANGE = 5;
    private static ReplayAttackFilter replayFilter = new ReplayAttackFilter();
    private static ExpiredMessageIdTimerListener listener;
    protected Hashtable messageIdTable = new Hashtable();
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authentication$wssec$ReplayAttackFilter;

    protected ReplayAttackFilter() {
    }

    public static ReplayAttackFilter getInstance(String replayWindow) {
        ReplayAttackFilter.initSweeper();
        if (replayWindow != null) {
            try {
                WINDOW_RANGE = Integer.parseInt(replayWindow);
            }
            catch (NumberFormatException exp) {
                logger.info((Object)("Configured window is erroneous: " + replayWindow + ". using default value of " + WINDOW_RANGE + "minutes"));
                WINDOW_RANGE = DEFAULT_WINDOW_RANGE;
            }
        } else {
            WINDOW_RANGE = DEFAULT_WINDOW_RANGE;
        }
        return replayFilter;
    }

    private static synchronized void initSweeper() {
        if (listener == null) {
            logger.debug((Object)"Initialize sweeper task");
            listener = new ExpiredMessageIdTimerListener(replayFilter);
            int interval = ExpiredMessageIdTimerListener.getInterval();
            try {
                InitialContext initialContext = new InitialContext();
                TimerManager timerManager = (TimerManager)initialContext.lookup("java:comp/env//timer/ContainerTimer");
                timerManager.schedule((TimerListener)listener, (long)interval, (long)interval);
            }
            catch (NamingException e) {
                logger.debug((Object)"", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private synchronized void put(String messageId, Calendar expirationTime) {
        if (messageId == null || expirationTime == null) {
            throw new IllegalArgumentException(i18n.getMessage("msgIdNull") + i18n.getMessage("expirationNull"));
        }
        this.messageIdTable.put(messageId, expirationTime);
    }

    private Calendar get(String messageId) {
        if (messageId == null) {
            throw new IllegalArgumentException(i18n.getMessage("msgIdNull"));
        }
        return (Calendar)this.messageIdTable.get(messageId);
    }

    private boolean inRange(Calendar base, Calendar val) {
        Calendar lowerBound = Calendar.getInstance();
        lowerBound.setTime(base.getTime());
        lowerBound.add(12, -1 * WINDOW_RANGE);
        Calendar upperBound = Calendar.getInstance();
        upperBound.setTime(base.getTime());
        upperBound.add(12, WINDOW_RANGE);
        return val.after(lowerBound) && val.before(upperBound);
    }

    public void checkMessageValidity(String messageId, Calendar created) throws WSSecurityException {
        logger.debug((Object)("Message id is " + messageId));
        Calendar now = Calendar.getInstance();
        logger.debug((Object)("Current time is " + now.getTime()));
        logger.debug((Object)("Created time is " + created.getTime()));
        if (this.inRange(now, created)) {
            logger.debug((Object)"message in window");
            Calendar msgExpiration = this.get(messageId);
            if (logger.isDebugEnabled() && msgExpiration != null) {
                logger.debug((Object)("Base " + now.getTime()));
                logger.debug((Object)("expiration " + msgExpiration.getTime()));
            }
            if (msgExpiration != null && this.inRange(now, msgExpiration)) {
                String err = i18n.getMessage("duplicateMsg", (Object)messageId);
                logger.debug((Object)err);
                throw new WSSecurityException(0, "duplicateMsg", new Object[]{messageId});
            }
        } else {
            String err = i18n.getMessage("msgExpNotInWin");
            logger.debug((Object)err);
            throw new WSSecurityException(8);
        }
        created.add(12, WINDOW_RANGE);
        logger.debug((Object)("Valid message, adding to table: " + messageId + " expiration time " + created.getTime()));
        this.put(messageId, created);
    }

    public synchronized void removeExpiredValues() {
        logger.debug((Object)"scanning for expired messgae Id");
        Set entries = this.messageIdTable.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Calendar expirationTime = (Calendar)entry.getValue();
            if (!expirationTime.before(Calendar.getInstance())) continue;
            logger.debug((Object)"removing expired message id value");
            iterator.remove();
        }
    }

    public int getMessageWindow() {
        return WINDOW_RANGE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

