/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.signature;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.Base64;
import org.globus.wsrf.providers.GSSPrivateKey;
import org.globus.wsrf.providers.GSSPublicKey;

public class SignatureGSS
extends SignatureAlgorithmSpi {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authentication$signature$SignatureGSS == null ? (class$org$globus$wsrf$impl$security$authentication$signature$SignatureGSS = SignatureGSS.class$("org.globus.wsrf.impl.security.authentication.signature.SignatureGSS")) : class$org$globus$wsrf$impl$security$authentication$signature$SignatureGSS).getName());
    public static final String URI = "http://www.globus.org/2002/04/xmlenc#gssapi-sign";
    private Signature signatureAlgorithm = null;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authentication$signature$SignatureGSS;
    static /* synthetic */ Class class$org$globus$wsrf$providers$GSSPrivateKey;
    static /* synthetic */ Class class$org$globus$wsrf$providers$GSSPublicKey;

    protected String engineGetURI() {
        return URI;
    }

    public SignatureGSS() throws XMLSignatureException {
        String algorithmID = JCEMapper.translateURItoJCEID((String)URI);
        logger.debug((Object)("Created SignatureGSS using " + algorithmID));
        try {
            this.signatureAlgorithm = Signature.getInstance(algorithmID);
        }
        catch (NoSuchAlgorithmException ex) {
            Object[] exArgs = new Object[]{algorithmID, ex.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.setParameter(params);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new XMLSignatureException("empty", (Exception)e);
        }
    }

    protected boolean engineVerify(byte[] signature) throws XMLSignatureException {
        try {
            logger.debug((Object)("Called GSS.verify() on " + Base64.encode((byte[])signature)));
            return this.signatureAlgorithm.verify(signature);
        }
        catch (SignatureException ex) {
            throw new XMLSignatureException("empty", (Exception)ex);
        }
    }

    protected void engineInitSign(Key gssKey, SecureRandom secureRandom) throws XMLSignatureException {
        if (!(gssKey instanceof GSSPrivateKey)) {
            String supplied = gssKey.getClass().getName();
            String needed = (class$org$globus$wsrf$providers$GSSPrivateKey == null ? (class$org$globus$wsrf$providers$GSSPrivateKey = SignatureGSS.class$("org.globus.wsrf.providers.GSSPrivateKey")) : class$org$globus$wsrf$providers$GSSPrivateKey).getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this.signatureAlgorithm.initSign((PrivateKey)gssKey, secureRandom);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException("empty", (Exception)ex);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            return this.signatureAlgorithm.sign();
        }
        catch (SignatureException ex) {
            throw new XMLSignatureException("empty", (Exception)ex);
        }
    }

    protected void engineUpdate(byte[] input) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(input);
        }
        catch (SignatureException ex) {
            throw new XMLSignatureException("empty", (Exception)ex);
        }
    }

    protected void engineUpdate(byte input) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(input);
        }
        catch (SignatureException ex) {
            throw new XMLSignatureException("empty", (Exception)ex);
        }
    }

    protected void engineUpdate(byte[] buf, int offset, int len) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(buf, offset, len);
        }
        catch (SignatureException ex) {
            throw new XMLSignatureException("empty", (Exception)ex);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        return this.signatureAlgorithm.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this.signatureAlgorithm.getProvider().getName();
    }

    protected void engineSetHMACOutputLength(int HMACOutputLength) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    protected void engineInitVerify(Key gssKey) throws XMLSignatureException {
        if (!(gssKey instanceof GSSPublicKey)) {
            String supplied = gssKey.getClass().getName();
            String needed = (class$org$globus$wsrf$providers$GSSPublicKey == null ? (class$org$globus$wsrf$providers$GSSPublicKey = SignatureGSS.class$("org.globus.wsrf.providers.GSSPublicKey")) : class$org$globus$wsrf$providers$GSSPublicKey).getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this.signatureAlgorithm.initVerify((PublicKey)gssKey);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException("empty", (Exception)ex);
        }
    }

    protected void engineInitSign(Key gssKey, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseAlgorithmParameterSpecOnDSA");
    }

    protected void engineInitSign(Key gssKey) throws XMLSignatureException {
        if (!(gssKey instanceof GSSPrivateKey)) {
            String supplied = gssKey.getClass().getName();
            String needed = (class$org$globus$wsrf$providers$GSSPrivateKey == null ? (class$org$globus$wsrf$providers$GSSPrivateKey = SignatureGSS.class$("org.globus.wsrf.providers.GSSPrivateKey")) : class$org$globus$wsrf$providers$GSSPrivateKey).getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this.signatureAlgorithm.initSign((PrivateKey)gssKey);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException("empty", (Exception)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

