/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.secureconv;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.encryption.GssEncryptedSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityFault;

public class EncryptHandler
extends GenericHandler {
    protected static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authentication.errors");
    private static Log log = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authentication$secureconv$EncryptHandler == null ? (class$org$globus$wsrf$impl$security$authentication$secureconv$EncryptHandler = EncryptHandler.class$("org.globus.wsrf.impl.security.authentication.secureconv.EncryptHandler")) : class$org$globus$wsrf$impl$security$authentication$secureconv$EncryptHandler).getName());
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authentication$secureconv$EncryptHandler;

    public boolean handleRequest(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleResponse(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleMessage(SOAPMessageContext ctx) {
        SecurityContext secContext = (SecurityContext)ctx.getProperty("org.globus.security.secureconv.context");
        if (secContext == null) {
            log.debug((Object)"No context - not encrypting.");
            return true;
        }
        SOAPMessage msg = ctx.getMessage();
        if (msg == null) {
            log.debug((Object)"No message - not encrypting.");
            return true;
        }
        log.debug((Object)"Enter: encrypt");
        SOAPMessage encryptedMsg = null;
        try {
            SOAPEnvelope clearEnvelope = msg.getSOAPPart().getEnvelope();
            GssEncryptedSOAPEnvelopeBuilder builder = new GssEncryptedSOAPEnvelopeBuilder((MessageContext)ctx, secContext);
            builder.setActor((String)ctx.getProperty("gssActor"));
            encryptedMsg = builder.buildMessage(clearEnvelope);
        }
        catch (Exception e) {
            log.error((Object)i18n.getMessage("encryptErr"), (Throwable)e);
            throw WSSecurityFault.makeFault(e);
        }
        ctx.setMessage(encryptedMsg);
        log.debug((Object)"Exit: encrypt");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

