/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.UsernameSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityFault;

public class UsernameHandler
extends GenericHandler {
    protected static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authentication.errors");
    private static Log log = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authentication$UsernameHandler == null ? (class$org$globus$wsrf$impl$security$authentication$UsernameHandler = UsernameHandler.class$("org.globus.wsrf.impl.security.authentication.UsernameHandler")) : class$org$globus$wsrf$impl$security$authentication$UsernameHandler).getName());
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authentication$UsernameHandler;

    public boolean handleRequest(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleResponse(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleMessage(SOAPMessageContext ctx) {
        Object tmp = ctx.getProperty("org.globus.security.username");
        if (tmp == null) {
            log.debug((Object)"User name is not set");
            return true;
        }
        SOAPMessage msg = ctx.getMessage();
        if (msg == null) {
            log.debug((Object)"No message");
            return true;
        }
        log.debug((Object)("user name is " + tmp));
        UsernameSOAPEnvelopeBuilder builder = new UsernameSOAPEnvelopeBuilder((MessageContext)ctx, (String)tmp);
        builder.setActor((String)ctx.getProperty("x509Actor"));
        SOAPMessage soapMsg = null;
        try {
            SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
            soapMsg = builder.buildMessage(envelope);
        }
        catch (Exception exp) {
            log.error((Object)i18n.getMessage("userPassAdd"), (Throwable)exp);
            throw WSSecurityFault.makeFault(exp);
        }
        ctx.setMessage(soapMsg);
        log.debug((Object)"Exit username handler");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

