/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.security.gridmap.GridMap;
import org.globus.util.I18n;
import org.globus.wsrf.PersistenceCallback;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListAccessor;
import org.globus.wsrf.TopicListenerList;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.SimpleSubscriptionTopicListener;
import org.globus.wsrf.impl.notification.SubscriptionCreationException;
import org.globus.wsrf.impl.notification.SubscriptionHome;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.globus.wsrf.security.SecureResource;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.topicexpression.UnsupportedTopicExpressionDialectException;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.utils.FaultHelper;
import org.ietf.jgss.GSSCredential;
import org.oasis.wsn.InvalidTopicExpressionFaultType;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeCreationFailedFaultType;
import org.oasis.wsn.TopicNotSupportedFaultType;
import org.oasis.wsn.TopicPathDialectUnknownFaultType;
import org.oasis.wsrf.faults.BaseFaultType;

public class SubscribeHelper {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$notification$SubscribeHelper == null ? (class$org$globus$wsrf$impl$notification$SubscribeHelper = SubscribeHelper.class$("org.globus.wsrf.impl.notification.SubscribeHelper")) : class$org$globus$wsrf$impl$notification$SubscribeHelper).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = SubscribeHelper.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    private ResourceContext context;
    private Resource producerResource;
    private ResourceKey producerKey;
    private String producerHomeLocation;
    private String subscriptionManager;
    private Subscribe request;
    private SecurityManager securityManager;
    private ContainerSecurityConfig containerSecurityConfig = null;
    static /* synthetic */ Class class$org$globus$wsrf$impl$notification$SubscribeHelper;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;
    static /* synthetic */ Class class$org$ietf$jgss$GSSCredential;

    public SubscribeHelper(ResourceContext context, Resource producerResource, ResourceKey producerKey, String producerHomeLocation, Subscribe request) {
        this.context = context;
        this.producerResource = producerResource;
        this.producerKey = producerKey;
        this.producerHomeLocation = producerHomeLocation;
        this.subscriptionManager = this.getSubscriptionManagerServiceName();
        this.request = request;
        this.securityManager = SecurityManager.getManager();
        try {
            this.containerSecurityConfig = ContainerSecurityConfig.getConfig();
        }
        catch (ConfigException e) {
            logger.debug((Object)"Error trying to get container security config", (Throwable)((Object)e));
            throw new RuntimeException(e.getMessage());
        }
    }

    public EndpointReferenceType subscribe() throws SubscribeCreationFailedFaultType, TopicNotSupportedFaultType, TopicPathDialectUnknownFaultType, InvalidTopicExpressionFaultType {
        EndpointReferenceType producerReference;
        Collection topics;
        String subscriptionHomeLocation = null;
        SubscriptionHome subscriptionHome = null;
        if (this.request == null) {
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.setDescription(i18n.getMessage("nullArgument", (Object)"request"));
            throw fault;
        }
        if (this.request.getTopicExpression() == null) {
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.setDescription(i18n.getMessage("emptyTopicExpression"));
            throw fault;
        }
        EndpointReferenceType consumerReference = this.request.getConsumerReference();
        if (consumerReference == null) {
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.setDescription(i18n.getMessage("emptyConsumerReference"));
            throw fault;
        }
        try {
            consumerReference = (EndpointReferenceType)ObjectSerializer.clone(consumerReference);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.request.getTopicExpression().getDialect().getClass().toString());
        }
        try {
            InitialContext initialContext = new InitialContext();
            subscriptionHomeLocation = "java:comp/env//services/" + this.subscriptionManager + "/home";
            subscriptionHome = (SubscriptionHome)initialContext.lookup(subscriptionHomeLocation);
        }
        catch (Exception e) {
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.addFaultCause(e);
            faultHelper.setDescription(i18n.getMessage("resourceDisoveryFailed"));
            throw fault;
        }
        if (!(this.producerResource instanceof TopicListAccessor)) {
            TopicNotSupportedFaultType fault = new TopicNotSupportedFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.setDescription(i18n.getMessage("noTopicList"));
            logger.debug((Object)"", (Throwable)fault);
            throw fault;
        }
        TopicList topicList = ((TopicListAccessor)((Object)this.producerResource)).getTopicList();
        try {
            topics = topicList.getTopics(this.request.getTopicExpression());
        }
        catch (UnsupportedTopicExpressionDialectException e) {
            logger.debug((Object)"", (Throwable)((Object)e));
            TopicPathDialectUnknownFaultType fault = new TopicPathDialectUnknownFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.addFaultCause((Throwable)((Object)e));
            throw fault;
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
            InvalidTopicExpressionFaultType fault = new InvalidTopicExpressionFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.addFaultCause(e);
            faultHelper.setDescription(i18n.getMessage("topicExpressionResolutionFailed"));
            throw fault;
        }
        if (topics.isEmpty()) {
            if (logger.isDebugEnabled()) {
                Iterator it = topicList.topicIterator();
                String topicsString = "";
                while (it.hasNext()) {
                    Object topicObj = it.next();
                    if (!(topicObj instanceof Topic)) continue;
                    Topic topic = (Topic)topicObj;
                    topicsString = topicsString + "; {" + topic.getName().getNamespaceURI() + "}" + topic.getName().getLocalPart();
                }
                if (this.request.getTopicExpression() != null) {
                    String expressionTopicString = "";
                    Object expressionValue = this.request.getTopicExpression().getValue();
                    if (expressionValue instanceof QName) {
                        expressionTopicString = "{" + ((QName)expressionValue).getNamespaceURI() + "}" + ((QName)expressionValue).getLocalPart();
                    }
                    logger.debug((Object)("no topics found matching expression " + this.request.getTopicExpression().getDialect() + "; " + expressionTopicString + "\n" + "avail. topics are: " + topicsString));
                }
            }
            throw new TopicNotSupportedFaultType();
        }
        try {
            producerReference = AddressingUtils.createEndpointReference(this.producerKey);
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.addFaultCause(e);
            faultHelper.setDescription(i18n.getMessage("eprCreationFailed"));
            throw fault;
        }
        ClientSecurityDescriptor desc = null;
        ResourceSecurityDescriptor resourceSecurityDescriptor = null;
        try {
            desc = this.setupNotificationSecurityDescriptor(consumerReference);
        }
        catch (SecurityException e) {
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.addFaultCause(e);
            faultHelper.setDescription(i18n.getMessage("secureNotificationSetupFailed"));
            throw fault;
        }
        if (desc != null) {
            try {
                resourceSecurityDescriptor = this.setupResourceSecurityDescriptor();
            }
            catch (Exception e) {
                SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
                FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
                faultHelper.addFaultCause(e);
                faultHelper.setDescription(i18n.getMessage("secureSubscriptionSetupFailed"));
                throw fault;
            }
        }
        ResourceKey subscriptionKey = null;
        try {
            subscriptionKey = subscriptionHome.create(consumerReference, producerReference, this.request.getInitialTerminationTime(), this.request.getSubscriptionPolicy(), this.request.getPrecondition(), this.request.getSelector(), this.producerKey, this.producerHomeLocation, this.request.getTopicExpression(), this.request.getUseNotify() == null ? true : this.request.getUseNotify(), desc, resourceSecurityDescriptor);
        }
        catch (SubscriptionCreationException e) {
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.addFaultCause(e);
            faultHelper.setDescription(i18n.getMessage("subscriptionCreateFailed"));
            throw fault;
        }
        SimpleSubscriptionTopicListener topicListener = new SimpleSubscriptionTopicListener(subscriptionKey, subscriptionHomeLocation);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Subscription is being added to " + String.valueOf(topics.size()) + " topics"));
        }
        Iterator topicIterator = topics.iterator();
        while (topicIterator.hasNext()) {
            ((TopicListenerList)topicIterator.next()).addTopicListener(topicListener);
        }
        EndpointReferenceType reference = null;
        try {
            String address = ServiceHost.getBaseURL() + this.subscriptionManager;
            reference = AddressingUtils.createEndpointReference(address, subscriptionKey);
            if (this.producerResource instanceof PersistenceCallback) {
                ((PersistenceCallback)((Object)this.producerResource)).store();
            }
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
            try {
                subscriptionHome.remove(subscriptionKey);
            }
            catch (Exception e1) {
                logger.error((Object)i18n.getMessage("subscriptionRemoveFailed"), (Throwable)e1);
            }
            SubscribeCreationFailedFaultType fault = new SubscribeCreationFailedFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.addFaultCause(e);
            faultHelper.setDescription(i18n.getMessage("eprCreationFailed"));
            throw fault;
        }
        return reference;
    }

    protected ResourceSecurityDescriptor setupResourceSecurityDescriptor() throws SecurityException, ConfigException, SecurityDescriptorException {
        ServiceSecurityDescriptor serviceSecurityDescriptor = ServiceSecurityConfig.getSecurityDescriptor();
        ContainerSecurityDescriptor containerSecurityDescriptor = this.containerSecurityConfig.getSecurityDescriptor();
        ResourceSecurityDescriptor desc = null;
        boolean setAuth = false;
        List authMethods = null;
        QName operationName = (QName)this.context.getProperty("org.globus.security.operationName");
        if (this.producerResource instanceof SecureResource) {
            desc = this.createResourceSecurityDescriptor();
            ResourceSecurityDescriptor producerSecurityDescriptor = ((SecureResource)this.producerResource).getSecurityDescriptor();
            if (producerSecurityDescriptor != null) {
                if (operationName != null) {
                    authMethods = producerSecurityDescriptor.getAuthMethods(operationName);
                }
                if (authMethods != null) {
                    desc.setAuthMethods(authMethods);
                    setAuth = true;
                }
                authMethods = producerSecurityDescriptor.getDefaultAuthMethods();
                if (!setAuth && authMethods != null) {
                    desc.setAuthMethods(authMethods);
                    setAuth = true;
                }
            }
        }
        if (!setAuth && serviceSecurityDescriptor != null) {
            desc = this.createResourceSecurityDescriptor();
            if (operationName != null) {
                authMethods = serviceSecurityDescriptor.getAuthMethods(operationName);
            }
            if (authMethods != null) {
                desc.setAuthMethods(authMethods);
                setAuth = true;
            }
            authMethods = serviceSecurityDescriptor.getDefaultAuthMethods();
            if (!setAuth && authMethods != null) {
                desc.setAuthMethods(authMethods);
                setAuth = true;
            }
        }
        if (desc == null && containerSecurityDescriptor != null) {
            desc = this.createResourceSecurityDescriptor();
        }
        return desc;
    }

    private ResourceSecurityDescriptor createResourceSecurityDescriptor() throws SecurityException {
        ResourceSecurityDescriptor desc = new ResourceSecurityDescriptor();
        Subject subject = JaasSubject.getCurrentSubject();
        if (subject == null) {
            subject = this.securityManager.getSubject(this.producerResource);
        }
        desc.setSubject(subject);
        String peer = this.securityManager.getCaller();
        if (peer != null) {
            GridMap gridmap = new GridMap();
            gridmap.map(peer, System.getProperty("user.name"));
            desc.setGridMap(gridmap);
            desc.setAuthz("gridmap");
        }
        return desc;
    }

    protected ClientSecurityDescriptor setupNotificationSecurityDescriptor(EndpointReferenceType consumerEPR) throws SecurityException {
        ClientSecurityDescriptor desc = null;
        Integer protLevel = null;
        boolean secureMessage = false;
        boolean secureConversation = false;
        protLevel = (Integer)this.context.getProperty("org.globus.security.secMsg.msg.type");
        if (protLevel == null) {
            protLevel = (Integer)this.context.getProperty("org.globus.security.secConv.msg.type");
            if (protLevel == null) {
                protLevel = (Integer)this.context.getProperty("org.globus.security.transport.type");
            } else {
                secureConversation = true;
            }
        } else {
            secureMessage = true;
        }
        if (consumerEPR.getAddress().getScheme().equals("https")) {
            desc = new ClientSecurityDescriptor();
            desc.setGSITransport(protLevel == null ? GSIConstants.SIGNATURE : protLevel);
        } else {
            if (protLevel != null && secureMessage) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Secure message " + protLevel));
                }
                desc = new ClientSecurityDescriptor();
                desc.setGSISecureMsg(protLevel);
            }
            if (protLevel != null && secureConversation) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Secure conversation " + protLevel));
                }
                if (desc == null) {
                    desc = new ClientSecurityDescriptor();
                }
                desc.setGSISecureConv(protLevel);
            }
        }
        if (desc != null) {
            Set privateCreds;
            Subject currentSubject = JaasSubject.getCurrentSubject();
            if (currentSubject == null) {
                currentSubject = this.securityManager.getSubject(this.producerResource);
            }
            if (currentSubject != null && (privateCreds = currentSubject.getPrivateCredentials(class$org$ietf$jgss$GSSCredential == null ? (class$org$ietf$jgss$GSSCredential = SubscribeHelper.class$("org.ietf.jgss.GSSCredential")) : class$org$ietf$jgss$GSSCredential)) != null && !privateCreds.isEmpty()) {
                Iterator iterator = privateCreds.iterator();
                GSSCredential cred = (GSSCredential)iterator.next();
                desc.setGSSCredential(cred);
            }
        }
        return desc;
    }

    protected String getSubscriptionManagerServiceName() {
        return "SubscriptionManagerService";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

