/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.util.I18n;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.PersistenceCallback;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.notification.SimpleSubscription;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.security.util.FixedObjectInputStream;
import org.globus.wsrf.utils.FilePersistenceHelper;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.properties.QueryExpressionType;

public class PersistentSubscription
extends SimpleSubscription
implements PersistenceCallback {
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = PersistentSubscription.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    private transient FilePersistenceHelper persistenceHelper;
    private static final String FILE_SUFFIX = ".obj";
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;

    public PersistentSubscription() {
    }

    public PersistentSubscription(EndpointReferenceType consumerReference, EndpointReferenceType producerReference, Calendar initialTerminationTime, Object policy, QueryExpressionType precondition, QueryExpressionType selector, ResourceKey producerKey, String producerHomeLocation, TopicExpressionType topicExpression, boolean isPaused, boolean useNotify, ClientSecurityDescriptor notificationSecurityDescriptor, ResourceSecurityDescriptor resourceSecurityDescriptor) {
        super(consumerReference, producerReference, initialTerminationTime, policy, precondition, selector, producerKey, producerHomeLocation, topicExpression, isPaused, useNotify, notificationSecurityDescriptor, resourceSecurityDescriptor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(ResourceKey key) throws ResourceException, NoSuchResourceException, InvalidResourceKeyException {
        File file = this.getKeyAsFile(key.getValue());
        if (!file.exists()) {
            throw new NoSuchResourceException(key.toString());
        }
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                FixedObjectInputStream ois = new FixedObjectInputStream(fis);
                this.consumerReference = (EndpointReferenceType)ois.readObject();
                this.producerReference = (EndpointReferenceType)ois.readObject();
                this.policy = ois.readObject();
                this.precondition = (QueryExpressionType)ois.readObject();
                this.selector = (QueryExpressionType)ois.readObject();
                this.producerKey = (ResourceKey)ois.readObject();
                this.producerHomeLocation = (String)ois.readObject();
                this.topicExpression = (TopicExpressionType)ois.readObject();
                this.isPaused = ois.readBoolean();
                this.useNotify = ois.readBoolean();
                this.terminationTime = (Calendar)ois.readObject();
                this.creationTime = (Calendar)ois.readObject();
                this.securityDescriptor = (ClientSecurityDescriptor)ois.readObject();
                this.resourceSecurityDescriptor = (ResourceSecurityDescriptor)ois.readObject();
                this.creationTime = (Calendar)ois.readObject();
                this.id = (String)ois.readObject();
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("resourceLoadFailed");
                throw new ResourceException(errorMessage, e);
            }
            Object var7_6 = null;
            if (fis == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception ee) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ee) {}
        fis.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store() throws ResourceException {
        File file;
        File tmpFile;
        block8: {
            FileOutputStream fos = null;
            tmpFile = null;
            try {
                try {
                    tmpFile = File.createTempFile("subscription", ".tmp", this.getPersistenceHelper().getStorageDirectory());
                    fos = new FileOutputStream(tmpFile);
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeObject(this.consumerReference);
                    oos.writeObject(this.producerReference);
                    oos.writeObject(this.policy);
                    oos.writeObject(this.precondition);
                    oos.writeObject(this.selector);
                    oos.writeObject(this.producerKey);
                    oos.writeObject(this.producerHomeLocation);
                    oos.writeObject(this.topicExpression);
                    oos.writeBoolean(this.isPaused);
                    oos.writeBoolean(this.useNotify);
                    oos.writeObject(this.terminationTime);
                    oos.writeObject(this.creationTime);
                    oos.writeObject(this.securityDescriptor);
                    oos.writeObject(this.resourceSecurityDescriptor);
                    oos.writeObject(this.creationTime);
                    oos.writeObject(this.id);
                }
                catch (Exception e) {
                    tmpFile.delete();
                    String errorMessage = i18n.getMessage("resourceStoreFailed");
                    throw new ResourceException(errorMessage, e);
                }
                Object var6_5 = null;
                if (fos == null) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ee) {}
            fos.close();
        }
        if ((file = this.getKeyAsFile(this.id)).exists()) {
            file.delete();
        }
        if (tmpFile.renameTo(file)) return;
        tmpFile.delete();
        throw new ResourceException(i18n.getMessage("resourceStoreFailed"));
    }

    private File getKeyAsFile(Object key) throws InvalidResourceKeyException {
        if (key instanceof String) {
            return this.getPersistenceHelper().getKeyAsFile(key);
        }
        throw new InvalidResourceKeyException();
    }

    public void remove() throws ResourceException {
        super.remove();
        this.getPersistenceHelper().remove(this.id);
    }

    protected synchronized FilePersistenceHelper getPersistenceHelper() {
        if (this.persistenceHelper == null) {
            try {
                this.persistenceHelper = new FilePersistenceHelper(this.getClass(), FILE_SUFFIX);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.persistenceHelper;
    }

    public void setTerminationTime(Calendar time) {
        super.setTerminationTime(time);
        try {
            this.store();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void pause() throws Exception {
        super.pause();
        try {
            this.store();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void resume() throws Exception {
        super.resume();
        try {
            this.store();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

