/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.Text;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.globus.util.I18n;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.query.ExpressionEvaluator;
import org.globus.wsrf.query.InvalidQueryExpressionException;
import org.globus.wsrf.query.QueryEvaluationException;
import org.globus.wsrf.query.QueryException;
import org.globus.wsrf.query.UnsupportedQueryDialectException;
import org.globus.wsrf.utils.XmlUtils;
import org.oasis.wsrf.properties.QueryExpressionType;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathExpressionEvaluator
implements ExpressionEvaluator {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$XPathExpressionEvaluator == null ? (class$org$globus$wsrf$impl$XPathExpressionEvaluator = XPathExpressionEvaluator.class$("org.globus.wsrf.impl.XPathExpressionEvaluator")) : class$org$globus$wsrf$impl$XPathExpressionEvaluator).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = XPathExpressionEvaluator.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    private static final String[] DIALECTS = new String[]{"http://www.w3.org/TR/1999/REC-xpath-19991116"};
    static /* synthetic */ Class class$org$globus$wsrf$impl$XPathExpressionEvaluator;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;

    public String[] getDialects() {
        return DIALECTS;
    }

    public Object evaluate(QueryExpressionType expression, ResourcePropertySet resourcePropertySet) throws UnsupportedQueryDialectException, QueryEvaluationException, InvalidQueryExpressionException, QueryException {
        try {
            return this.evaluateQuery(expression, resourcePropertySet);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryEvaluationException(e);
        }
    }

    private List evaluateQuery(QueryExpressionType expression, ResourcePropertySet resourcePropertySet) throws Exception {
        if (expression == null) {
            throw new QueryException(i18n.getMessage("noQuery"));
        }
        if (expression.getDialect() == null) {
            throw new QueryException(i18n.getMessage("nullArgument", (Object)"expression.dialect"));
        }
        String dialect = expression.getDialect().toString();
        if (!dialect.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
            throw new UnsupportedQueryDialectException(i18n.getMessage("invalidQueryExpressionDialect"));
        }
        if (expression.getValue() == null || expression.getValue().toString().trim().length() == 0) {
            throw new InvalidQueryExpressionException(i18n.getMessage("noQueryString"));
        }
        String query = expression.getValue().toString().trim();
        logger.debug((Object)("Query: " + query));
        Element rootElement = resourcePropertySet.toElement();
        HashMap namespaces = new HashMap();
        this.collectNamespaces(rootElement, namespaces, new HashMap());
        this.setNamespaces(rootElement, namespaces);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Document: " + XmlUtils.toString(rootElement)));
        }
        XObject result = XPathAPI.eval((Node)rootElement, (String)query, (Node)rootElement);
        ArrayList<MessageElement> resultList = null;
        if (result instanceof XBoolean || result instanceof XNumber || result instanceof XString) {
            resultList = new ArrayList<MessageElement>(1);
            MessageElement element = new MessageElement((CharacterData)new Text(result.str()));
            resultList.add(element);
        } else if (result instanceof XNodeSet) {
            XNodeSet set = (XNodeSet)result;
            NodeList list = set.nodelist();
            resultList = new ArrayList(list.getLength());
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (node instanceof Document) {
                    resultList.add(new MessageElement(((Document)node).getDocumentElement()));
                    continue;
                }
                if (node instanceof Element) {
                    resultList.add(new MessageElement((Element)node));
                    continue;
                }
                if (node instanceof CharacterData) {
                    resultList.add(new MessageElement((CharacterData)new Text(((CharacterData)node).getData())));
                    continue;
                }
                throw new QueryException(i18n.getMessage("unsupportedXpathReturn", (Object)node.getClass().getName()));
            }
        } else {
            throw new QueryException(i18n.getMessage("unsupportedXpathReturn", (Object)result));
        }
        return resultList;
    }

    private void collectNamespaces(Node node, Map namespaces, Map prefixes) {
        NodeList children;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                String name = attr.getName();
                String value = attr.getValue();
                if (!name.startsWith("xmlns:") || namespaces.get(value) != null) continue;
                if (prefixes.get(name) != null) {
                    int j = 1;
                    while (prefixes.get(name = "xmlns:ns" + j++) != null) {
                    }
                }
                prefixes.put(name, value);
                namespaces.put(value, name);
            }
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                this.collectNamespaces(child, namespaces, prefixes);
            }
        }
    }

    private void setNamespaces(Element node, Map namespaces) {
        Iterator iter = namespaces.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            node.setAttributeNS("http://www.w3.org/2000/xmlns/", (String)entry.getValue(), (String)entry.getKey());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

