/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import commonj.timers.Timer;
import commonj.timers.TimerListener;
import commonj.timers.TimerManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.PersistenceCallback;
import org.globus.wsrf.RemoveCallback;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.container.Lock;
import org.globus.wsrf.container.LockManager;
import org.globus.wsrf.impl.ResourceSweeper;
import org.globus.wsrf.impl.lifetime.SetTerminationTimeProvider;
import org.globus.wsrf.jndi.Initializable;
import org.globus.wsrf.jndi.JNDIUtils;
import org.globus.wsrf.utils.cache.Cache;

public abstract class ResourceHomeImpl
implements ResourceHome,
Initializable {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$ResourceHomeImpl == null ? (class$org$globus$wsrf$impl$ResourceHomeImpl = ResourceHomeImpl.class$("org.globus.wsrf.impl.ResourceHomeImpl")) : class$org$globus$wsrf$impl$ResourceHomeImpl).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = ResourceHomeImpl.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    protected Map resources;
    protected QName keyTypeName;
    protected Class resourceClass;
    protected Class keyTypeClass;
    private boolean resourceIsPersistent = false;
    protected LockManager lockManager;
    private String cacheLocation;
    private Cache cache;
    private long sweeperDelay = 60000L;
    private Sweeper sweeper;
    private boolean initialized = false;
    static /* synthetic */ Class class$org$globus$wsrf$impl$ResourceHomeImpl;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$globus$wsrf$Resource;
    static /* synthetic */ Class class$org$globus$wsrf$PersistenceCallback;
    static /* synthetic */ Class class$org$globus$wsrf$utils$cache$Cache;
    static /* synthetic */ Class class$org$globus$wsrf$ResourceLifetime;

    public void setResourceClass(String clazz) throws ClassNotFoundException {
        this.resourceClass = Class.forName(clazz);
    }

    public String getResourceClass() {
        return this.resourceClass.getName();
    }

    public void setResourceKeyType(String clazz) throws ClassNotFoundException {
        this.keyTypeClass = Class.forName(clazz);
    }

    public Class getKeyTypeClass() {
        return this.keyTypeClass;
    }

    public void setResourceKeyName(String keyName) {
        this.keyTypeName = QName.valueOf(keyName);
    }

    public QName getKeyTypeName() {
        return this.keyTypeName;
    }

    public void setSweeperDelay(long delay) {
        this.sweeperDelay = delay;
    }

    public long getSweeperDelay() {
        return this.sweeperDelay;
    }

    public void setCacheLocation(String jndiLocation) {
        this.cacheLocation = jndiLocation;
    }

    public String getCacheLocation() {
        return this.cacheLocation;
    }

    public synchronized void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        if (this.keyTypeClass == null) {
            Class clazz = this.keyTypeClass = class$java$lang$String == null ? (class$java$lang$String = ResourceHomeImpl.class$("java.lang.String")) : class$java$lang$String;
        }
        if (this.keyTypeName == null) {
            throw new Exception(i18n.getMessage("resourceKeyConfigError"));
        }
        if (this.resourceClass == null) {
            throw new Exception(i18n.getMessage("resourceClassConfigError"));
        }
        if (!(class$org$globus$wsrf$Resource == null ? (class$org$globus$wsrf$Resource = ResourceHomeImpl.class$("org.globus.wsrf.Resource")) : class$org$globus$wsrf$Resource).isAssignableFrom(this.resourceClass)) {
            throw new Exception(i18n.getMessage("invalidResourceType", (Object)this.resourceClass.getName()));
        }
        if ((class$org$globus$wsrf$PersistenceCallback == null ? (class$org$globus$wsrf$PersistenceCallback = ResourceHomeImpl.class$("org.globus.wsrf.PersistenceCallback")) : class$org$globus$wsrf$PersistenceCallback).isAssignableFrom(this.resourceClass)) {
            this.resourceIsPersistent = true;
        }
        InitialContext initialContext = new InitialContext();
        TimerManager timerManager = (TimerManager)initialContext.lookup("java:comp/env//timer/ContainerTimer");
        if (this.resourceIsPersistent) {
            this.resources = new ReferenceMap(0, 1, true);
            if (this.cacheLocation != null) {
                this.cache = (Cache)JNDIUtils.lookup(initialContext, this.cacheLocation, class$org$globus$wsrf$utils$cache$Cache == null ? (class$org$globus$wsrf$utils$cache$Cache = ResourceHomeImpl.class$("org.globus.wsrf.utils.cache.Cache")) : class$org$globus$wsrf$utils$cache$Cache);
            }
        } else {
            this.resources = new HashMap();
        }
        this.resources = Collections.synchronizedMap(this.resources);
        this.lockManager = new LockManager();
        if ((class$org$globus$wsrf$ResourceLifetime == null ? (class$org$globus$wsrf$ResourceLifetime = ResourceHomeImpl.class$("org.globus.wsrf.ResourceLifetime")) : class$org$globus$wsrf$ResourceLifetime).isAssignableFrom(this.resourceClass)) {
            this.sweeper = new Sweeper(this, this.resources, timerManager, this.sweeperDelay);
        }
        this.initialized = true;
    }

    protected Resource createNewInstance() throws ResourceException {
        try {
            return (Resource)this.resourceClass.newInstance();
        }
        catch (Exception e) {
            throw new ResourceException("", e);
        }
    }

    protected Resource createNewInstanceAndLoad(ResourceKey key) throws ResourceException {
        Resource resource = this.createNewInstance();
        ((PersistenceCallback)((Object)resource)).load(key);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource find(ResourceKey key) throws ResourceException {
        if (key == null) {
            throw new InvalidResourceKeyException(i18n.getMessage("resourceKeyMissing"));
        }
        Resource resource = null;
        Lock lock = this.lockManager.getLock(key);
        try {
            if (!lock.acquire(false)) {
                throw new NoSuchResourceException();
            }
        }
        catch (InterruptedException e) {
            throw new ResourceException(e);
        }
        try {
            resource = this.get(key);
            if (this.cache != null) {
                this.cache.update(resource);
            }
        }
        finally {
            lock.release();
        }
        return resource;
    }

    private Resource get(ResourceKey key) throws ResourceException {
        Resource resource = (Resource)this.resources.get(key);
        if (resource == null) {
            if (this.resourceIsPersistent) {
                resource = this.createNewInstanceAndLoad(key);
                this.addResource(key, resource);
                if (ResourceSweeper.isExpired(resource)) {
                    this.remove(key);
                    throw new NoSuchResourceException();
                }
            } else {
                throw new NoSuchResourceException();
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ResourceKey key) throws ResourceException {
        if (key == null) {
            throw new InvalidResourceKeyException(i18n.getMessage("nullArgument", (Object)"key"));
        }
        Resource resource = null;
        Lock lock = this.lockManager.getLock(key);
        try {
            if (!lock.acquire(true)) {
                throw new NoSuchResourceException();
            }
        }
        catch (InterruptedException e) {
            throw new ResourceException(e);
        }
        try {
            resource = this.get(key);
            SetTerminationTimeProvider.sendTerminationNotification(resource);
            if (resource instanceof RemoveCallback) {
                ((RemoveCallback)((Object)resource)).remove();
            }
            this.resources.remove(key);
            if (this.cache != null) {
                this.cache.remove(resource);
            }
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(ResourceKey key, Resource resource) {
        Lock lock = this.lockManager.getLock(key);
        try {
            lock.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage());
        }
        try {
            this.addResource(key, resource);
            if (this.cache != null) {
                this.cache.update(resource);
            }
        }
        finally {
            lock.release();
        }
    }

    private void addResource(ResourceKey key, Resource resource) {
        this.resources.put(key, resource);
        if (this.sweeper != null) {
            this.sweeper.scheduleSweeper();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Sweeper
    extends ResourceSweeper {
        private TimerManager timerManager;
        private Timer timer;
        private long delay;

        public Sweeper(ResourceHome home, Map resources, TimerManager timerManager, long delay) {
            super(home, resources);
            this.timerManager = timerManager;
            this.delay = delay;
        }

        private synchronized void resetSweeper() {
            this.timer = null;
        }

        synchronized void scheduleSweeper() {
            if (this.timer == null) {
                this.timer = this.timerManager.schedule((TimerListener)this, this.delay);
                logger.debug((Object)"scheduling sweeper");
            }
        }

        protected Resource getResource(ResourceKey key) throws ResourceException {
            return (Resource)this.resources.get(key);
        }

        public void timerExpired(Timer timer) {
            super.timerExpired(timer);
            this.resetSweeper();
            if (!this.resources.isEmpty()) {
                this.scheduleSweeper();
            }
        }
    }
}

