/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.message.MessageElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.w3c.dom.Element;

public abstract class BaseResourceProperty
implements ResourceProperty {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$BaseResourceProperty == null ? (class$org$globus$wsrf$impl$BaseResourceProperty = BaseResourceProperty.class$("org.globus.wsrf.impl.BaseResourceProperty")) : class$org$globus$wsrf$impl$BaseResourceProperty).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = BaseResourceProperty.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    protected ResourcePropertyMetaData metaData;
    static /* synthetic */ Class class$org$globus$wsrf$impl$BaseResourceProperty;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$javax$xml$soap$SOAPElement;

    public BaseResourceProperty(QName name) {
        this(new SimpleResourcePropertyMetaData(name));
    }

    public BaseResourceProperty(ResourcePropertyMetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"metaData"));
        }
        this.metaData = metaData;
    }

    protected void setMetaData(ResourcePropertyMetaData metaData) {
        this.metaData = metaData;
    }

    public ResourcePropertyMetaData getMetaData() {
        return this.metaData;
    }

    protected Object convert(Object value) {
        if (value == null) {
            return null;
        }
        Class type = this.getMetaData().getType();
        if (type == null || type == (class$java$lang$Object == null ? (class$java$lang$Object = BaseResourceProperty.class$("java.lang.Object")) : class$java$lang$Object)) {
            return value;
        }
        try {
            if (type.isPrimitive()) {
                return this.convertPrimitive(type, value);
            }
            return this.convertObject(type, value);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = i18n.getMessage("failedToConvert", (Object)e.getMessage());
            logger.debug((Object)msg, (Throwable)e);
            throw new IllegalArgumentException(msg);
        }
    }

    protected Object convertObject(Class type, Object value) throws Exception {
        QName name = this.getMetaData().getName();
        return BaseResourceProperty.convert(value, type, name);
    }

    protected Object convertPrimitive(Class type, Object value) throws Exception {
        QName name = this.getMetaData().getName();
        if (type == Boolean.TYPE) {
            return BaseResourceProperty.convert(value, class$java$lang$Boolean == null ? (class$java$lang$Boolean = BaseResourceProperty.class$("java.lang.Boolean")) : class$java$lang$Boolean, name);
        }
        if (type == Character.TYPE) {
            return BaseResourceProperty.convert(value, class$java$lang$Character == null ? (class$java$lang$Character = BaseResourceProperty.class$("java.lang.Character")) : class$java$lang$Character, name);
        }
        if (type == Byte.TYPE) {
            return BaseResourceProperty.convert(value, class$java$lang$Byte == null ? (class$java$lang$Byte = BaseResourceProperty.class$("java.lang.Byte")) : class$java$lang$Byte, name);
        }
        if (type == Short.TYPE) {
            return BaseResourceProperty.convert(value, class$java$lang$Short == null ? (class$java$lang$Short = BaseResourceProperty.class$("java.lang.Short")) : class$java$lang$Short, name);
        }
        if (type == Integer.TYPE) {
            return BaseResourceProperty.convert(value, class$java$lang$Integer == null ? (class$java$lang$Integer = BaseResourceProperty.class$("java.lang.Integer")) : class$java$lang$Integer, name);
        }
        if (type == Long.TYPE) {
            return BaseResourceProperty.convert(value, class$java$lang$Long == null ? (class$java$lang$Long = BaseResourceProperty.class$("java.lang.Long")) : class$java$lang$Long, name);
        }
        if (type == Float.TYPE) {
            return BaseResourceProperty.convert(value, class$java$lang$Float == null ? (class$java$lang$Float = BaseResourceProperty.class$("java.lang.Float")) : class$java$lang$Float, name);
        }
        if (type == Double.TYPE) {
            return BaseResourceProperty.convert(value, class$java$lang$Double == null ? (class$java$lang$Double = BaseResourceProperty.class$("java.lang.Double")) : class$java$lang$Double, name);
        }
        throw new IllegalArgumentException(i18n.getMessage("cantConvertType", new Object[]{value.getClass(), type}));
    }

    private static Object convert(Object value, Class type, QName name) throws Exception {
        if (type.isAssignableFrom(value.getClass())) {
            if (value instanceof MessageElement && (class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = BaseResourceProperty.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).equals(type)) {
                return ((MessageElement)value).getAsDOM();
            }
            return value;
        }
        if (value instanceof SOAPElement) {
            return ObjectDeserializer.toObject((SOAPElement)value, type);
        }
        if (value instanceof Element) {
            if ((class$javax$xml$soap$SOAPElement == null ? (class$javax$xml$soap$SOAPElement = BaseResourceProperty.class$("javax.xml.soap.SOAPElement")) : class$javax$xml$soap$SOAPElement).equals(type)) {
                return new MessageElement((Element)value);
            }
            return ObjectDeserializer.toObject((Element)value, type);
        }
        if (type.equals(class$javax$xml$soap$SOAPElement == null ? (class$javax$xml$soap$SOAPElement = BaseResourceProperty.class$("javax.xml.soap.SOAPElement")) : class$javax$xml$soap$SOAPElement)) {
            return ObjectSerializer.toSOAPElement(value, name);
        }
        if (type.equals(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = BaseResourceProperty.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element)) {
            return ObjectSerializer.toElement(value, name);
        }
        throw new IllegalArgumentException(i18n.getMessage("cantConvertType", new Object[]{value.getClass(), type}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

