/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.transport.http.ChunkedInputStream;
import org.apache.axis.transport.http.ChunkedOutputStream;
import org.apache.axis.transport.http.NonBlockingBufferedInputStream;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.container.ServiceRequest;
import org.globus.wsrf.container.ServiceRequestQueue;
import org.globus.wsrf.container.ServiceThreadPool;
import org.globus.wsrf.utils.PerformanceLog;
import org.w3c.dom.Document;

public class ServiceThread
extends Thread {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$container$ServiceThread == null ? (class$org$globus$wsrf$container$ServiceThread = ServiceThread.class$("org.globus.wsrf.container.ServiceThread")) : class$org$globus$wsrf$container$ServiceThread).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = ServiceThread.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    private ServiceRequestQueue queue;
    private ServiceThreadPool threadPool;
    private AxisEngine engine;
    protected MessageContext msgContext;
    private NonBlockingBufferedInputStream is;
    private Message responseMsg;
    private StringBuffer soapAction;
    private StringBuffer fileName;
    private int httpRequest;
    private boolean sendContentLength = true;
    protected boolean http11;
    private boolean chunked;
    static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$wsrf$container$ServiceThread == null ? (class$org$globus$wsrf$container$ServiceThread = ServiceThread.class$("org.globus.wsrf.container.ServiceThread")) : class$org$globus$wsrf$container$ServiceThread).getName() + ".performance");
    static PerformanceLog performanceProcessLogger = new PerformanceLog((class$org$globus$wsrf$container$ServiceThread == null ? (class$org$globus$wsrf$container$ServiceThread = ServiceThread.class$("org.globus.wsrf.container.ServiceThread")) : class$org$globus$wsrf$container$ServiceThread).getName() + ".performance.process");
    public static final String SEND_CONTENT_LENGTH = "org.globus.wsrf.container.sendContentLength";
    protected static final byte[] HTTP_10 = "HTTP/1.0 ".getBytes();
    protected static final byte[] HTTP_11 = "HTTP/1.1 ".getBytes();
    private static final byte[] OK = "200 OK".getBytes();
    protected static final byte[] UNAUTH = "401 Unauthorized".getBytes();
    private static final byte[] ISE = "500 Internal server error".getBytes();
    private static final String FILE_NOT_FOUND = "404 ";
    private static final byte[] FILE_NOT_FOUND_MSG = "<html><body>File not found</body></html>".getBytes();
    protected static final byte[] XML_MIME_STUFF = "\r\nContent-Type: text/xml; charset=utf-8".getBytes();
    protected static final byte[] HTML_MIME_STUFF = "\r\nContent-Type: text/html; charset=utf-8".getBytes();
    protected static final byte[] JNLP_MIME_STUFF = "\r\nContent-Type: application/x-java-jnlp-file".getBytes();
    protected static final byte[] JAR_MIME_STUFF = "\r\nContent-Type: application/java-archive".getBytes();
    protected static final String CONTENT_TYPE = "\r\nContent-Type: ";
    protected static final byte[] CONTENT_LENGTH = "\r\nContent-Length: ".getBytes();
    private static final byte[] CONNECTION_CLOSE = "\r\nConnection: close".getBytes();
    private static final byte[] TRANSFER_ENCODING_CHUNKED = "\r\nTransfer-Encoding: chunked".getBytes();
    protected static final byte[] SEPARATOR = "\r\n\r\n".getBytes();
    private static final byte[] toLower = new byte[256];
    private static final byte[] LENGTH_HEADER;
    private static final byte[] ACTION_HEADER;
    private static final byte[] GET_HEADER;
    private static final byte[] HEAD_HEADER;
    private static final byte[] POST_HEADER;
    private static final byte[] HEADER_ENDER;
    private static final byte[] ENCODING_HEADER;
    private static final byte[] CHUNKED;
    private static final byte[] HTTP_BASE_VERSION;
    private static final int HTTP_GET = 1;
    private static final int HTTP_HEAD = 2;
    private static final int HTTP_POST = 3;
    private static final int BUFSIZ = 4096;
    private byte[] buf = new byte[4096];
    private String webRootPath;
    private boolean webStartEnabled = false;
    private String configRootPath;
    private String baseURL;
    static /* synthetic */ Class class$org$globus$wsrf$container$ServiceThread;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;
    static /* synthetic */ Class class$org$apache$axis$AxisFault;

    public ServiceThread(ServiceRequestQueue queue, ServiceThreadPool pool, AxisEngine engine) {
        this.setName("Service" + this.getName());
        logger.debug((Object)"Starting up thread");
        this.queue = queue;
        this.threadPool = pool;
        String webStart = System.getProperty("org.globus.wsrf.container.webstart");
        this.webStartEnabled = webStart != null && webStart.equalsIgnoreCase("enable");
        try {
            this.webRootPath = ServiceThread.getWebRootPath(engine);
        }
        catch (Exception e) {
            throw new RuntimeException(i18n.getMessage("invalidWebRoot"));
        }
        this.configRootPath = ServiceThread.getConfigRootPath(engine);
        this.engine = engine;
        this.is = new NonBlockingBufferedInputStream();
        this.soapAction = new StringBuffer();
        this.fileName = new StringBuffer();
        String prop = System.getProperty(SEND_CONTENT_LENGTH);
        if (prop != null && prop.equalsIgnoreCase("false")) {
            this.sendContentLength = false;
        }
        String host = "localhost";
        try {
            host = ServiceThread.getHost(engine);
        }
        catch (Exception e) {
            logger.warn((Object)i18n.getMessage("noHostname"), (Throwable)e);
        }
        this.baseURL = this.getProtocol() + "://" + host + ":";
    }

    private static String getHost(AxisEngine engine) throws IOException {
        URL url = new URL("http", ServiceHost.getHost(engine), 80, "/");
        return url.getHost();
    }

    public static String getWebRootPath(AxisEngine engine) throws IOException {
        ContainerConfig config = ContainerConfig.getConfig(engine);
        String webRoot = config.getInternalWebRoot();
        if (webRoot == null) {
            webRoot = "." + File.separator;
        } else if (!webRoot.equals("") && !webRoot.endsWith(File.separator)) {
            webRoot = webRoot + File.separator;
        }
        return new File(webRoot).getCanonicalPath();
    }

    public static String getConfigRootPath(AxisEngine engine) {
        return ContainerConfig.getGlobusLocation();
    }

    private void reset() {
        Service.clearCall();
        if (this.msgContext != null) {
            this.msgContext.reset();
            this.msgContext.dispose();
        }
        this.msgContext = new MessageContext(this.engine);
        this.responseMsg = null;
    }

    private void handleOutOfMemoryError() {
        this.reset();
        System.runFinalization();
        System.gc();
    }

    public void run() {
        while (true) {
            this.reset();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Thread " + this.getName() + " listening for requests"));
            }
            try {
                ServiceRequest request = this.queue.dequeue();
                if (request == null) {
                    logger.debug((Object)("Stopping thread " + this.getName()));
                    this.threadPool.removeThread(this);
                    break;
                }
                performanceProcessLogger.start();
                this.process(request);
                performanceProcessLogger.stop("process");
            }
            catch (OutOfMemoryError e) {
                logger.error((Object)i18n.getMessage("memFault01"), (Throwable)e);
                this.handleOutOfMemoryError();
            }
            catch (Throwable e) {
                logger.error((Object)i18n.getMessage("serverFault02"), e);
            }
        }
    }

    protected String getProtocol() {
        return "http";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process(ServiceRequest request) {
        socket = request.getSocket();
        out = null;
        in = null;
        if (ServiceThread.logger.isDebugEnabled()) {
            ServiceThread.logger.debug((Object)("Thread " + this.getName() + " processing requests"));
        }
        try {
            block79: {
                block78: {
                    out = socket.getOutputStream();
                    in = socket.getInputStream();
                    status = ServiceThread.OK;
                    doWsdl = false;
                    filePart = "";
                    this.is.setInputStream(in);
                    try {
                        contentLength = this.parseHeaders((InputStream)this.is, this.soapAction, this.fileName);
                        if (contentLength >= 0) {
                            this.is.setContentLength(contentLength);
                        }
                        if ((paramIdx = this.fileName.toString().indexOf(63)) != -1) {
                            params = this.fileName.substring(paramIdx + 1);
                            this.fileName.setLength(paramIdx);
                            if (ServiceThread.logger.isDebugEnabled()) {
                                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("filename00", (Object)this.fileName.toString()));
                                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("params00", (Object)params));
                            }
                            if ("wsdl".equalsIgnoreCase(params)) {
                                doWsdl = true;
                            }
                        }
                        filePart = this.fileName.toString();
                        this.msgContext.setProperty("realpath", (Object)filePart);
                        this.msgContext.setProperty("configPath", (Object)this.configRootPath);
                        this.msgContext.setProperty("home.dir", (Object)this.webRootPath);
                        this.msgContext.setProperty("remoteaddr", (Object)socket.getInetAddress().getHostAddress());
                        serverSocket = request.getServerSocket();
                        url = this.baseURL + serverSocket.getLocalPort() + "/" + filePart;
                        this.msgContext.setProperty("transport.url", (Object)url);
                        if (this.httpRequest == 1) {
                            if (doWsdl) {
                                this.doWSDL(this.engine, this.msgContext, out, filePart);
                                break block78;
                            } else {
                                this.doGet(this.engine, this.msgContext, out, filePart, true);
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Exception e) {
                        status = this.doFault(e, this.msgContext, filePart);
                        break block79;
                    }
                }
                var13_17 = null;
                ** GOTO lbl191
lbl-1000:
                // 1 sources

                {
                    if (this.httpRequest != 2) ** GOTO lbl-1000
                    this.doGet(this.engine, this.msgContext, out, filePart, false);
                }
                ** GOTO lbl219
lbl-1000:
                // 1 sources

                {
                    this.doPost(this.engine, this.msgContext);
                }
            }
            if (this.responseMsg == null) {
                out.write(this.createHeaderReply(ServiceThread.OK, ServiceThread.XML_MIME_STUFF, 0L));
            } else {
                contentType = "\r\nContent-Type: " + this.responseMsg.getContentType(this.msgContext.getSOAPConstants());
                if (this.chunked) {
                    out.write(this.createHeaderReply(status, contentType.getBytes(), -1L));
                    out = new ChunkedOutputStream(out);
                } else {
                    out.write(this.createHeaderReply(status, contentType.getBytes(), this.responseMsg.getContentLength()));
                }
                this.responseMsg.writeTo(out);
            }
            out.flush();
            ** GOTO lbl248
        }
        catch (InterruptedIOException iie) {
            var13_20 = null;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
            }
            try {
                if (this.is != null) {
                    this.is.close();
                }
            }
            catch (Exception e) {
                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
            }
            try {
                if (socket == null) return;
                socket.close();
                return;
            }
            catch (Exception e) {
                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
            }
            return;
        }
        catch (SocketException se) {
            block85: {
                block84: {
                    block83: {
                        ServiceThread.logger.debug((Object)"Socket exception", (Throwable)se);
                        var13_21 = null;
                        ** try [egrp 5[TRYBLOCK] [19 : 651->662)] { 
lbl101:
                        // 1 sources

                        if (out != null) {
                            out.close();
                        }
                        break block83;
lbl104:
                        // 1 sources

                        catch (Exception e) {
                            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [20 : 682->695)] { 
lbl108:
                    // 1 sources

                    if (in != null) {
                        in.close();
                    }
                    break block84;
lbl111:
                    // 1 sources

                    catch (Exception e) {
                        ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                    }
                }
                ** try [egrp 7[TRYBLOCK] [21 : 715->732)] { 
lbl115:
                // 1 sources

                if (this.is != null) {
                    this.is.close();
                }
                break block85;
lbl118:
                // 1 sources

                catch (Exception e) {
                    ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                }
            }
            try {}
            catch (Exception e) {
                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
                return;
            }
            if (socket == null) return;
            socket.close();
            return;
        }
        catch (Exception e) {
            block88: {
                block87: {
                    block86: {
                        ServiceThread.logger.error((Object)ServiceThread.i18n.getMessage("general"), (Throwable)e);
                        var13_22 = null;
                        ** try [egrp 5[TRYBLOCK] [19 : 651->662)] { 
lbl133:
                        // 1 sources

                        if (out != null) {
                            out.close();
                        }
                        break block86;
lbl136:
                        // 1 sources

                        catch (Exception e) {
                            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [20 : 682->695)] { 
lbl140:
                    // 1 sources

                    if (in != null) {
                        in.close();
                    }
                    break block87;
lbl143:
                    // 1 sources

                    catch (Exception e) {
                        ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                    }
                }
                ** try [egrp 7[TRYBLOCK] [21 : 715->732)] { 
lbl147:
                // 1 sources

                if (this.is != null) {
                    this.is.close();
                }
                break block88;
lbl150:
                // 1 sources

                catch (Exception e) {
                    ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                }
            }
            try {}
            catch (Exception e) {
                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
                return;
            }
            if (socket == null) return;
            socket.close();
            return;
        }
        {
            block100: {
                block99: {
                    block98: {
                        block97: {
                            block96: {
                                block95: {
                                    block94: {
                                        block93: {
                                            block92: {
                                                catch (Throwable var12_31) {
                                                    block91: {
                                                        block90: {
                                                            block89: {
                                                                var13_23 = null;
                                                                ** try [egrp 5[TRYBLOCK] [19 : 651->662)] { 
lbl164:
                                                                // 1 sources

                                                                if (out != null) {
                                                                    out.close();
                                                                }
                                                                break block89;
lbl167:
                                                                // 1 sources

                                                                catch (Exception e) {
                                                                    ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
                                                                }
                                                            }
                                                            ** try [egrp 6[TRYBLOCK] [20 : 682->695)] { 
lbl171:
                                                            // 1 sources

                                                            if (in != null) {
                                                                in.close();
                                                            }
                                                            break block90;
lbl174:
                                                            // 1 sources

                                                            catch (Exception e) {
                                                                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                                                            }
                                                        }
                                                        ** try [egrp 7[TRYBLOCK] [21 : 715->732)] { 
lbl178:
                                                        // 1 sources

                                                        if (this.is != null) {
                                                            this.is.close();
                                                        }
                                                        break block91;
lbl181:
                                                        // 1 sources

                                                        catch (Exception e) {
                                                            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                                                        }
                                                    }
                                                    ** try [egrp 8[TRYBLOCK] [22 : 752->763)] { 
lbl185:
                                                    // 1 sources

                                                    if (socket == null) throw var12_31;
                                                    socket.close();
                                                    throw var12_31;
lbl188:
                                                    // 1 sources

                                                    catch (Exception e) {
                                                        ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
                                                    }
                                                    throw var12_31;
                                                }
lbl191:
                                                // 1 sources

                                                ** try [egrp 5[TRYBLOCK] [19 : 651->662)] { 
lbl192:
                                                // 1 sources

                                                if (out != null) {
                                                    out.close();
                                                }
                                                break block92;
lbl195:
                                                // 1 sources

                                                catch (Exception e) {
                                                    ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
                                                }
                                            }
                                            ** try [egrp 6[TRYBLOCK] [20 : 682->695)] { 
lbl199:
                                            // 1 sources

                                            if (in != null) {
                                                in.close();
                                            }
                                            break block93;
lbl202:
                                            // 1 sources

                                            catch (Exception e) {
                                                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                                            }
                                        }
                                        ** try [egrp 7[TRYBLOCK] [21 : 715->732)] { 
lbl206:
                                        // 1 sources

                                        if (this.is != null) {
                                            this.is.close();
                                        }
                                        break block94;
lbl209:
                                        // 1 sources

                                        catch (Exception e) {
                                            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                                        }
                                    }
                                    try {}
                                    catch (Exception e) {
                                        ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
                                        return;
                                    }
                                    if (socket == null) return;
                                    socket.close();
                                    return;
lbl219:
                                    // 1 sources

                                    var13_18 = null;
                                    ** try [egrp 5[TRYBLOCK] [19 : 651->662)] { 
lbl221:
                                    // 1 sources

                                    if (out != null) {
                                        out.close();
                                    }
                                    break block95;
lbl224:
                                    // 1 sources

                                    catch (Exception e) {
                                        ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
                                    }
                                }
                                ** try [egrp 6[TRYBLOCK] [20 : 682->695)] { 
lbl228:
                                // 1 sources

                                if (in != null) {
                                    in.close();
                                }
                                break block96;
lbl231:
                                // 1 sources

                                catch (Exception e) {
                                    ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                                }
                            }
                            ** try [egrp 7[TRYBLOCK] [21 : 715->732)] { 
lbl235:
                            // 1 sources

                            if (this.is != null) {
                                this.is.close();
                            }
                            break block97;
lbl238:
                            // 1 sources

                            catch (Exception e) {
                                ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                            }
                        }
                        try {}
                        catch (Exception e) {
                            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
                            return;
                        }
                        if (socket == null) return;
                        socket.close();
                        return;
lbl248:
                        // 1 sources

                        var13_19 = null;
                        ** try [egrp 5[TRYBLOCK] [19 : 651->662)] { 
lbl250:
                        // 1 sources

                        if (out != null) {
                            out.close();
                        }
                        break block98;
lbl253:
                        // 1 sources

                        catch (Exception e) {
                            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingOutputStream"), (Throwable)e);
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [20 : 682->695)] { 
lbl257:
                    // 1 sources

                    if (in != null) {
                        in.close();
                    }
                    break block99;
lbl260:
                    // 1 sources

                    catch (Exception e) {
                        ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                    }
                }
                ** try [egrp 7[TRYBLOCK] [21 : 715->732)] { 
lbl264:
                // 1 sources

                if (this.is != null) {
                    this.is.close();
                }
                break block100;
lbl267:
                // 1 sources

                catch (Exception e) {
                    ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingInputStream"), (Throwable)e);
                }
            }
            try {}
            catch (Exception e) {}
            ServiceThread.logger.debug((Object)ServiceThread.i18n.getMessage("errorClosingSocket"), (Throwable)e);
            return;
            if (socket == null) return;
            socket.close();
            return;
        }
    }

    private byte[] createHeaderReply(byte[] code, byte[] contentType, long length) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(this.http11 ? HTTP_11 : HTTP_10);
        out.write(code);
        if (contentType != null) {
            out.write(contentType);
        }
        if (length < 0L) {
            out.write(TRANSFER_ENCODING_CHUNKED);
        } else if (this.sendContentLength) {
            out.write(CONTENT_LENGTH);
            out.write(String.valueOf(length).getBytes());
        }
        if (this.http11) {
            out.write(CONNECTION_CLOSE);
        }
        out.write(SEPARATOR);
        return out.toByteArray();
    }

    protected void doWSDL(AxisEngine engine, MessageContext msgContext, OutputStream out, String filePart) throws IOException {
        try {
            engine.generateWSDL(msgContext);
        }
        catch (Exception e) {
            AxisFault fault;
            byte[] status = ISE;
            byte[] contentType = HTML_MIME_STUFF;
            byte[] msg = null;
            if (e instanceof AxisFault && (fault = (AxisFault)((Object)e)).getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                status = (FILE_NOT_FOUND + filePart).getBytes();
                msg = FILE_NOT_FOUND_MSG;
            }
            if (msg == null) {
                logger.debug((Object)"Get wsdl error", (Throwable)e);
                StringWriter sWriter = new StringWriter();
                PrintWriter pWriter = new PrintWriter(sWriter);
                pWriter.println("<html><body>");
                pWriter.println("<h2>Error getting wsdl:</h2><pre>");
                e.printStackTrace(pWriter);
                pWriter.println("</pre></body></html>");
                pWriter.flush();
                String encoding = XMLUtils.getEncoding((MessageContext)msgContext);
                contentType = ("\r\nContent-Type: text/html; charset=" + encoding.toLowerCase()).getBytes();
                msg = sWriter.toString().getBytes(encoding);
            }
            out.write(this.createHeaderReply(status, contentType, msg.length));
            out.write(msg);
            out.flush();
            return;
        }
        Document doc = (Document)msgContext.getProperty("WSDL");
        if (doc != null) {
            String encoding = XMLUtils.getEncoding((MessageContext)msgContext);
            String contentType = "\r\nContent-Type: text/xml; charset=" + encoding.toLowerCase();
            String response = XMLUtils.DocumentToString((Document)doc);
            byte[] respBytes = response.getBytes(encoding);
            out.write(this.createHeaderReply(OK, contentType.getBytes(), respBytes.length));
            out.write(respBytes);
            out.flush();
        }
    }

    protected void doGet(AxisEngine engine, MessageContext msgContext, OutputStream out, String filePart, boolean returnContent) {
        try {
            this.doGetSub(engine, msgContext, out, filePart, returnContent);
        }
        catch (FileNotFoundException e) {
            try {
                byte[] status = (FILE_NOT_FOUND + filePart).getBytes();
                out.write(this.createHeaderReply(status, HTML_MIME_STUFF, FILE_NOT_FOUND_MSG.length));
                out.write(FILE_NOT_FOUND_MSG);
                out.flush();
            }
            catch (IOException ee) {
                logger.debug((Object)i18n.getMessage("errorWritingResponse"), (Throwable)e);
            }
        }
        catch (SocketException e) {
        }
        catch (IOException e) {
            try {
                out.write(this.createHeaderReply(ISE, HTML_MIME_STUFF, 0L));
                out.flush();
            }
            catch (IOException ee) {
                logger.debug((Object)i18n.getMessage("errorWritingResponse"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGetSub(AxisEngine engine, MessageContext msgContext, OutputStream out, String filePart, boolean returnContent) throws IOException {
        File getFile = new File(this.webRootPath, filePart);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to retrieve file from:" + getFile));
        }
        if (!getFile.getCanonicalPath().startsWith(this.webRootPath)) {
            throw new FileNotFoundException(filePart);
        }
        boolean xmlContent = filePart.endsWith(".xsd") || filePart.endsWith(".wsdl") || filePart.endsWith(".gwsdl");
        boolean jnlpContent = filePart.endsWith(".jnlp");
        boolean jarContent = filePart.endsWith(".jar");
        if (!xmlContent && !jnlpContent && !jarContent || (jnlpContent || jarContent) && !this.webStartEnabled) {
            throw new FileNotFoundException(filePart);
        }
        FileInputStream getFileStream = new FileInputStream(getFile);
        try {
            int bytesRead;
            byte[] type = null;
            if (xmlContent) {
                type = XML_MIME_STUFF;
            } else if (jnlpContent) {
                type = JNLP_MIME_STUFF;
            } else if (jarContent) {
                type = JAR_MIME_STUFF;
            }
            out.write(this.createHeaderReply(OK, type, getFile.length()));
            if (!returnContent) {
                return;
            }
            byte[] fileBuffer = new byte[4096];
            while ((bytesRead = getFileStream.read(fileBuffer, 0, 4096)) > 0) {
                out.write(fileBuffer, 0, bytesRead);
            }
        }
        finally {
            getFileStream.close();
        }
    }

    protected void doPost(AxisEngine engine, MessageContext msgContext) throws AxisFault {
        String soapActionString = this.soapAction.toString();
        if (soapActionString != null) {
            msgContext.setUseSOAPAction(true);
            msgContext.setSOAPActionURI(soapActionString);
        }
        NonBlockingBufferedInputStream in = this.is;
        if (this.chunked) {
            in = new ChunkedInputStream((InputStream)this.is);
        }
        Message requestMsg = new Message((Object)in);
        msgContext.setRequestMessage(requestMsg);
        performanceLogger.start();
        engine.invoke(msgContext);
        performanceLogger.stop("Post: Engine Invoke");
        this.responseMsg = msgContext.getResponseMessage();
    }

    protected byte[] doFault(Exception e, MessageContext msgContext, String filepart) {
        AxisFault af;
        byte[] status = OK;
        if (e instanceof AxisFault) {
            af = (AxisFault)((Object)e);
            if (((Object)((Object)af)).getClass().equals(class$org$apache$axis$AxisFault == null ? (class$org$apache$axis$AxisFault = ServiceThread.class$("org.apache.axis.AxisFault")) : class$org$apache$axis$AxisFault) && af.detail instanceof InvocationTargetException) {
                Throwable rootException = ((InvocationTargetException)af.detail).getTargetException();
                if (rootException instanceof OutOfMemoryError) {
                    logger.error((Object)i18n.getMessage("memFault02"), rootException);
                    this.handleOutOfMemoryError();
                } else {
                    logger.debug((Object)i18n.getMessage("serverFault00"), rootException);
                }
                af = new AxisFault(i18n.getMessage("serverFault00"), rootException);
            } else {
                logger.debug((Object)i18n.getMessage("serverFault00"), (Throwable)af);
            }
            QName faultCode = af.getFaultCode();
            status = faultCode != null && "Server.Unauthorized".equals(faultCode.getLocalPart()) ? UNAUTH : ISE;
        } else {
            status = e instanceof IOException ? (FILE_NOT_FOUND + filepart).getBytes() : ISE;
            af = AxisFault.makeFault((Exception)e);
        }
        this.responseMsg = msgContext.getResponseMessage();
        if (this.responseMsg == null) {
            this.responseMsg = new Message((Object)af);
        } else {
            try {
                SOAPEnvelope env = this.responseMsg.getSOAPEnvelope();
                env.clearBody();
                env.addBodyElement((SOAPBodyElement)new SOAPFault(af));
            }
            catch (AxisFault fault) {
                logger.error((Object)i18n.getMessage("unexpectedError"), (Throwable)e);
            }
        }
        return status;
    }

    private int readLine(InputStream is, byte[] b, int off, int len) throws IOException {
        int c;
        int count = 0;
        while ((c = is.read()) != -1) {
            b[off++] = (byte)c;
            if (c != 10 && ++count != len) continue;
        }
        return count > 0 ? count : -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseRequest(StringBuffer fileName, byte[] buf, int n, int offset) throws IOException {
        char c;
        int i;
        fileName.delete(0, fileName.length());
        for (i = 0; i < n - offset && (c = (char)(buf[i + offset] & 0x7F)) != ' '; ++i) {
            fileName.append(c);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)i18n.getMessage("filename01", (Object[])new String[]{"ServiceThread", fileName.toString()}));
        }
        if (!this.matches(buf, i + offset + 1, HTTP_BASE_VERSION)) throw new IOException(i18n.getMessage("malformedHTTPVersion"));
        int j = i + offset + 1 + HTTP_BASE_VERSION.length;
        if (j + 3 > n) {
            throw new IOException(i18n.getMessage("malformedHTTPVersion"));
        }
        if (buf[j] != 49) {
            throw new IOException(i18n.getMessage("unsupportedHTTPMajor"));
        }
        if (buf[j + 2] == 48) {
            this.http11 = false;
            return;
        } else {
            if (buf[j + 2] != 49) throw new IOException(i18n.getMessage("unsupportedHTTMinor"));
            this.http11 = true;
        }
    }

    private int parseHeaders(InputStream is, StringBuffer soapAction, StringBuffer fileName) throws IOException {
        int n = this.readLine(is, this.buf, 0, this.buf.length);
        if (n < 0) {
            throw new IOException(i18n.getMessage("unexpectedEOS00"));
        }
        soapAction.delete(0, soapAction.length());
        this.httpRequest = -1;
        this.chunked = false;
        if (this.buf[0] == GET_HEADER[0]) {
            this.httpRequest = 1;
            this.parseRequest(fileName, this.buf, n, 5);
            return 0;
        }
        if (this.buf[0] == HEAD_HEADER[0]) {
            this.httpRequest = 2;
            this.parseRequest(fileName, this.buf, n, 5);
            return 0;
        }
        if (this.buf[0] != POST_HEADER[0]) {
            throw new IOException(i18n.getMessage("badRequest00"));
        }
        this.httpRequest = 3;
        this.parseRequest(fileName, this.buf, n, 6);
        int len = -1;
        while ((n = this.readLine(is, this.buf, 0, this.buf.length)) > 0 && (n > 2 || this.buf[0] != 10 && this.buf[0] != 13)) {
            int endHeaderIndex;
            for (endHeaderIndex = 0; endHeaderIndex < n && toLower[this.buf[endHeaderIndex]] != HEADER_ENDER[0]; ++endHeaderIndex) {
            }
            int i = (endHeaderIndex += 2) - 1;
            if (endHeaderIndex == LENGTH_HEADER.length && this.matches(this.buf, LENGTH_HEADER)) {
                len = 0;
                while (++i < n && this.buf[i] >= 48 && this.buf[i] <= 57) {
                    len = len * 10 + (this.buf[i] - 48);
                }
                continue;
            }
            if (endHeaderIndex == ACTION_HEADER.length && this.matches(this.buf, ACTION_HEADER)) {
                ++i;
                while (++i < n && this.buf[i] != 34) {
                    soapAction.append((char)(this.buf[i] & 0x7F));
                }
                continue;
            }
            if (endHeaderIndex != ENCODING_HEADER.length || !this.matches(this.buf, ENCODING_HEADER)) continue;
            this.chunked = this.matches(this.buf, i + 1, CHUNKED) && this.http11;
        }
        return len;
    }

    public boolean matches(byte[] buf, byte[] target) {
        for (int i = 0; i < target.length; ++i) {
            if (toLower[buf[i]] == target[i]) continue;
            return false;
        }
        return true;
    }

    public boolean matches(byte[] buf, int bufIdx, byte[] target) {
        for (int i = 0; i < target.length; ++i) {
            if (toLower[buf[bufIdx + i]] == target[i]) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ServiceThread.toLower[i] = (byte)i;
        }
        for (int lc = 97; lc <= 122; ++lc) {
            ServiceThread.toLower[lc + 65 - 97] = (byte)lc;
        }
        LENGTH_HEADER = "content-length: ".getBytes();
        ACTION_HEADER = "soapaction: ".getBytes();
        GET_HEADER = "GET".getBytes();
        HEAD_HEADER = "HEAD".getBytes();
        POST_HEADER = "POST".getBytes();
        HEADER_ENDER = ": ".getBytes();
        ENCODING_HEADER = "transfer-encoding: ".getBytes();
        CHUNKED = "chunked".getBytes();
        HTTP_BASE_VERSION = "http/".getBytes();
    }
}

