/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.util.Util;
import org.globus.common.CoGProperties;
import org.globus.wsrf.config.ContainerConfig;

public class ServiceHost {
    public static final String PROXY_PORT_PROPERTY = "org.globus.wsrf.proxy.port";
    private static final Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$container$ServiceHost == null ? (class$org$globus$wsrf$container$ServiceHost = ServiceHost.class$("org.globus.wsrf.container.ServiceHost")) : class$org$globus$wsrf$container$ServiceHost).getName());
    private static boolean defaultsSet = false;
    private static int defaultPort = 8443;
    private static String defaultProtocol = "https";
    private static String defaultHost;
    static /* synthetic */ Class class$org$globus$wsrf$container$ServiceHost;

    protected static synchronized void setDefaults(String protocol, String host, int port) {
        if (!defaultsSet) {
            logger.debug((Object)("Setting container defaults to: " + protocol + "://" + host + ":" + port));
            defaultProtocol = protocol;
            defaultHost = host;
            defaultPort = port;
            defaultsSet = true;
        }
    }

    private static URL getEndpoint(MessageContext messageContext) throws MalformedURLException {
        String address = (String)messageContext.getProperty("transport.url");
        return address == null ? null : new URL(address);
    }

    public static URL getDefaultBaseURL() throws IOException {
        return ServiceHost.getBaseURL(null);
    }

    public static URL getBaseURL() throws IOException {
        return ServiceHost.getBaseURL(MessageContext.getCurrentContext());
    }

    public static URL getBaseURL(MessageContext context) throws IOException {
        String host;
        int port;
        String protocol;
        ContainerConfig config = null;
        if (context == null) {
            config = ContainerConfig.getConfig();
            protocol = defaultProtocol;
            port = defaultPort;
            host = ServiceHost.getDefaultHost();
        } else {
            config = ContainerConfig.getConfig(context.getAxisEngine());
            URL address = ServiceHost.getEndpoint(context);
            if (address == null) {
                protocol = defaultProtocol;
                port = defaultPort;
            } else {
                protocol = address.getProtocol();
                port = address.getPort();
            }
            host = ServiceHost.getHost(config);
        }
        String proxyPort = System.getProperty(PROXY_PORT_PROPERTY);
        if (proxyPort != null) {
            port = Integer.parseInt(proxyPort);
        }
        return new URL(protocol, host, port, "/" + config.getWSRFLocation());
    }

    public static int getDefaultPort() {
        return ServiceHost.getPort(null);
    }

    public static int getPort() {
        return ServiceHost.getPort(MessageContext.getCurrentContext());
    }

    public static int getPort(MessageContext context) {
        if (context == null) {
            return defaultPort;
        }
        URL url = null;
        try {
            url = ServiceHost.getEndpoint(context);
        }
        catch (IOException e) {
            logger.debug((Object)"", (Throwable)e);
            return defaultPort;
        }
        if (url == null) {
            return defaultPort;
        }
        int port = url.getPort();
        if (port == -1) {
            String protocol = url.getProtocol();
            port = protocol.equalsIgnoreCase("http") ? 80 : (protocol.equalsIgnoreCase("https") ? 443 : defaultPort);
        }
        return port;
    }

    public static String getDefaultProtocol() {
        return ServiceHost.getProtocol(null);
    }

    public static String getProtocol() {
        return ServiceHost.getProtocol(MessageContext.getCurrentContext());
    }

    public static String getProtocol(MessageContext context) {
        if (context == null) {
            return defaultProtocol;
        }
        URL url = null;
        try {
            url = ServiceHost.getEndpoint(context);
        }
        catch (IOException e) {
            logger.debug((Object)"", (Throwable)e);
            return defaultProtocol;
        }
        return url == null ? defaultProtocol : url.getProtocol();
    }

    public static synchronized String getDefaultHost() throws IOException {
        if (defaultHost == null) {
            defaultHost = ServiceHost.getHost(ContainerConfig.getConfig());
        }
        return defaultHost;
    }

    public static String getHost() throws IOException {
        return ServiceHost.getHost(MessageContext.getCurrentContext());
    }

    public static String getHost(MessageContext context) throws IOException {
        if (context == null) {
            return ServiceHost.getDefaultHost();
        }
        return ServiceHost.getHost(context.getAxisEngine());
    }

    public static String getHost(AxisEngine engine) throws IOException {
        if (engine == null) {
            return ServiceHost.getDefaultHost();
        }
        return ServiceHost.getHost(ContainerConfig.getConfig(engine));
    }

    public static String getHost(ContainerConfig config) throws IOException {
        String domainName;
        InetAddress localHost = null;
        String disableDNSConfig = config.getOption("disableDNS");
        boolean disableDNS = disableDNSConfig == null ? false : disableDNSConfig.equalsIgnoreCase("true");
        String logicalHostName = config.getOption("logicalHost");
        if (logicalHostName == null) {
            logicalHostName = CoGProperties.getDefault().getHostName();
        }
        String host = null;
        if (!disableDNS) {
            boolean publishHostName;
            localHost = logicalHostName != null ? InetAddress.getByName(logicalHostName) : InetAddress.getLocalHost();
            String publishHost = config.getOption("publishHostName");
            boolean bl = publishHostName = publishHost != null && publishHost.equalsIgnoreCase("true");
            host = publishHostName ? localHost.getHostName() : localHost.getHostAddress();
        } else if (logicalHostName != null) {
            host = logicalHostName;
        }
        if (host == null) {
            host = "localhost";
        } else if (host.indexOf(".") == -1 && (domainName = config.getOption("domainName")) != null) {
            host = host + "." + domainName;
        }
        return host;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Util.registerTransport();
    }
}

