/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.config;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.server.AxisServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.container.BaseContainerConfig;
import org.globus.wsrf.container.ServiceHost;

public class ContainerConfig
extends BaseContainerConfig {
    static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = ContainerConfig.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    public static final String WSRF_LOCATION = "wsrfLocation";
    public static final String CONTAINER_THREADS = "containerThreads";
    public static final String CONTAINER_THREADS_MAX = "containerThreadsMax";
    public static final String CONTAINER_THREADS_WATERMARK = "containerThreadsHighWaterMark";
    public static final String CONTAINER_TIMEOUT = "containerTimeout";
    public static final String LOGICAL_HOST = "logicalHost";
    public static final String PUBLISH_HOST_NAME = "publishHostName";
    public static final String DOMAIN_NAME = "domainName";
    public static final String DISABLE_DNS = "disableDNS";
    public static final String WEB_CONTEXT = "webContext";
    public static final String CONTAINER_ID = "server.id";
    public static final String CONTAINER_ID_PROPERTY = "org.globus.wsrf.container.server.id";
    public static final String EXTERNAL_WEB_ROOT = "webroot.external";
    public static final String EXTERNAL_WEB_ROOT_PROPERTY = "org.globus.wsrf.container.webroot.external";
    public static final String INTERNAL_WEB_ROOT = "webroot.internal";
    public static final String INTERNAL_WEB_ROOT_PROPERTY = "org.globus.wsrf.container.webroot.internal";
    public static final String WEB_START_PROPERTY = "org.globus.wsrf.container.webstart";
    public static final String CONFIG_PROFILE = "config.profile";
    private static AxisEngine axisClientEngine = null;
    private static Hashtable serverEngines = new Hashtable();
    public static final String DEFAULT_SERVER_CONFIG = "server-config.wsdd";
    private static ContainerConfig config;
    private AxisEngine engine;
    private WSDDGlobalConfiguration globalConfig;
    static Log logger;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;
    static /* synthetic */ Class class$org$globus$wsrf$config$ContainerConfig;
    static /* synthetic */ Class class$org$apache$axis$WSDDEngineConfiguration;

    protected ContainerConfig(AxisEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        EngineConfiguration config = engine.getConfig();
        if (!(config instanceof WSDDEngineConfiguration)) {
            Object[] args = new Object[]{class$org$apache$axis$WSDDEngineConfiguration == null ? (class$org$apache$axis$WSDDEngineConfiguration = ContainerConfig.class$("org.apache.axis.WSDDEngineConfiguration")) : class$org$apache$axis$WSDDEngineConfiguration, config == null ? null : config.getClass()};
            throw new IllegalArgumentException(i18n.getMessage("expectedType", args));
        }
        WSDDDeployment deployment = ((WSDDEngineConfiguration)config).getDeployment();
        this.globalConfig = deployment.getGlobalConfiguration();
        this.engine = engine;
    }

    public static synchronized ContainerConfig getConfig() {
        if (config == null) {
            config = new ContainerConfig((AxisEngine)ContainerConfig.getEngine());
        }
        return config;
    }

    public static ContainerConfig getConfig(AxisEngine engine) {
        return new ContainerConfig(engine);
    }

    public String getOption(String name) {
        return this.getOption(name, null);
    }

    public String getOption(String name, String defaultValue) {
        if (this.globalConfig == null) {
            return defaultValue;
        }
        String value = this.globalConfig.getParameter(name);
        return value != null ? value : defaultValue;
    }

    public void setOption(String name, String value) {
        if (this.globalConfig == null) {
            this.globalConfig = new WSDDGlobalConfiguration();
        }
        this.globalConfig.setParameter(name, value);
    }

    public String getWSRFLocation() {
        String location = this.getOption(WSRF_LOCATION);
        if (location == null) {
            String webContext = this.getOption(WEB_CONTEXT);
            if (webContext == null) {
                webContext = "wsrf";
            }
            location = webContext + "/services/";
        }
        return location;
    }

    public static String getExternalWebRoot(MessageContext ctx) throws IOException {
        ContainerConfig config;
        String webRoot = System.getProperty(EXTERNAL_WEB_ROOT_PROPERTY);
        if (webRoot == null && (webRoot = (config = new ContainerConfig(ctx.getAxisEngine())).getOption(EXTERNAL_WEB_ROOT)) == null) {
            String webContext = config.getOption(WEB_CONTEXT);
            webContext = webContext == null ? "/" : "/" + webContext + "/";
            URL webRootUrl = new URL(ServiceHost.getProtocol(ctx), ServiceHost.getHost(ctx), ServiceHost.getPort(ctx), webContext);
            webRoot = webRootUrl.toExternalForm();
        }
        return webRoot;
    }

    public String getInternalWebRoot() {
        String webRoot = System.getProperty(INTERNAL_WEB_ROOT_PROPERTY);
        if (webRoot == null && (webRoot = this.getOption(INTERNAL_WEB_ROOT)) == null) {
            webRoot = ContainerConfig.getGlobusLocation();
        }
        return webRoot;
    }

    public static String getGlobusLocation() {
        String value = System.getProperty("GLOBUS_LOCATION");
        return value == null ? "." : value;
    }

    public static String getBaseDirectory() {
        return baseDirectory;
    }

    public static String getSchemaDirectory() {
        return schemaDirectory;
    }

    public static String getContainerID() {
        return containerID == null ? "unknown" : containerID;
    }

    public static synchronized AxisEngine getClientEngine() {
        if (axisClientEngine == null) {
            axisClientEngine = new AxisClient();
        }
        return axisClientEngine;
    }

    public static AxisServer getEngine() {
        return serverEngine == null ? ContainerConfig.getServerEngine(null) : serverEngine;
    }

    public static synchronized AxisServer getServerEngine(String config) {
        AxisServer engine = (AxisServer)serverEngines.get(config = config == null ? DEFAULT_SERVER_CONFIG : config);
        if (engine == null) {
            engine = new AxisServer((EngineConfiguration)new FileProvider(config));
            serverEngines.put(config, engine);
        }
        return engine;
    }

    public static MessageContext getContext() {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx == null) {
            ctx = new MessageContext(ContainerConfig.getClientEngine());
            ctx.setEncodingStyle("");
            ctx.setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        }
        return ctx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = LogFactory.getLog((String)(class$org$globus$wsrf$config$ContainerConfig == null ? (class$org$globus$wsrf$config$ContainerConfig = ContainerConfig.class$("org.globus.wsrf.config.ContainerConfig")) : class$org$globus$wsrf$config$ContainerConfig).getName());
    }
}

