/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.client;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.xml.rpc.Stub;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.utils.FaultHelper;
import org.oasis.wsrf.lifetime.ScheduledResourceTermination;
import org.oasis.wsrf.lifetime.SetTerminationTimeResponse;
import org.oasis.wsrf.lifetime.WSResourceLifetimeServiceAddressingLocator;

public class SetTerminationTime
extends BaseClient {
    private static final Option UTC_OPTION;

    public SetTerminationTime() {
        this.options.addOption(UTC_OPTION);
    }

    public static void main(String[] args) {
        SetTerminationTime client = new SetTerminationTime();
        client.setCustomUsage("seconds | 'infinity'");
        Calendar termTime = null;
        CommandLine line = null;
        try {
            line = client.parse(args);
            List options = line.getArgList();
            if (options == null || options.isEmpty()) {
                throw new ParseException("Expected timeout value");
            }
            String value = (String)options.get(0);
            if (!value.equalsIgnoreCase("infinity")) {
                termTime = Calendar.getInstance();
                termTime.add(13, Integer.parseInt(value));
            }
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        WSResourceLifetimeServiceAddressingLocator locator = new WSResourceLifetimeServiceAddressingLocator();
        try {
            ScheduledResourceTermination port = locator.getScheduledResourceTerminationPort(client.getEPR());
            client.setOptions((Stub)port);
            org.oasis.wsrf.lifetime.SetTerminationTime request = new org.oasis.wsrf.lifetime.SetTerminationTime();
            request.setRequestedTerminationTime(termTime);
            SetTerminationTimeResponse response = port.setTerminationTime(request);
            Calendar newTermTime = response.getNewTerminationTime();
            SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            if (line.hasOption("u")) {
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
                System.out.println("set timizzone");
            }
            System.out.println("requested: " + (termTime == null ? "infinity" : df.format(termTime.getTime())));
            System.out.println("scheduled: " + (newTermTime == null ? "infinity" : df.format(newTermTime.getTime())));
        }
        catch (Exception e) {
            if (client.isDebugMode()) {
                FaultHelper.printStackTrace(e);
            } else {
                System.err.println("Error: " + FaultHelper.getMessage(e));
            }
            System.exit(2);
        }
    }

    static {
        OptionBuilder.withDescription((String)"Display time in UTC");
        OptionBuilder.withLongOpt((String)"utc");
        UTC_OPTION = OptionBuilder.create((String)"u");
    }
}

