/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.soap.SOAPElement;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.server.AxisServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.NotificationConsumerCallbackManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.container.ContainerException;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.notification.ClientNotificationConsumerManager;
import org.globus.wsrf.impl.notification.NotificationConsumerHome;
import org.globus.wsrf.impl.notification.ServerNotificationConsumerManager;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.utils.AddressingUtils;

public abstract class NotificationConsumerManager {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$NotificationConsumerManager == null ? (class$org$globus$wsrf$NotificationConsumerManager = NotificationConsumerManager.class$("org.globus.wsrf.NotificationConsumerManager")) : class$org$globus$wsrf$NotificationConsumerManager).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = NotificationConsumerManager.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    protected NotificationConsumerHome notificationConsumerHome;
    protected Map consumers = new HashMap();
    static /* synthetic */ Class class$org$globus$wsrf$NotificationConsumerManager;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;

    protected NotificationConsumerManager() {
    }

    public static synchronized NotificationConsumerManager getInstance() {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx != null && ctx.getProperty("transport.url") != null && ctx.getAxisEngine() instanceof AxisServer) {
            return new ServerNotificationConsumerManager();
        }
        return new ClientNotificationConsumerManager();
    }

    public static synchronized NotificationConsumerManager getInstance(Map properties) {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx != null && ctx.getProperty("transport.url") != null && ctx.getAxisEngine() instanceof AxisServer) {
            return new ServerNotificationConsumerManager();
        }
        return new ClientNotificationConsumerManager(properties);
    }

    protected void initializeConsumerHome() throws ContainerException {
        try {
            InitialContext initialContext = new InitialContext();
            this.notificationConsumerHome = (NotificationConsumerHome)initialContext.lookup("java:comp/env//services/" + this.getNotificationConsumerServiceName() + "/home");
        }
        catch (NamingException e) {
            throw new ContainerException(i18n.getMessage("notificationConsumerHomeLookupFailure"), e);
        }
    }

    public abstract void startListening() throws ContainerException;

    public abstract void stopListening() throws ContainerException;

    public abstract boolean isListening();

    public abstract URL getURL();

    public EndpointReferenceType createNotificationConsumer(List[] topicPaths, NotifyCallback[] callbacks) throws ResourceException {
        return this.createNotificationConsumer(topicPaths, callbacks, null);
    }

    public EndpointReferenceType createNotificationConsumer(List[] topicPaths, NotifyCallback[] callbacks, ResourceSecurityDescriptor desc) throws ResourceException {
        if (topicPaths == null && callbacks != null || topicPaths != null && callbacks == null || topicPaths != null && callbacks != null && topicPaths.length != callbacks.length) {
            throw new IllegalArgumentException(i18n.getMessage("notificationConsumerArgumentMismatch"));
        }
        if (!this.isListening()) {
            throw new ResourceException(i18n.getMessage("notificationConsumerNotListening"));
        }
        ResourceKey key = this.notificationConsumerHome.create(desc);
        this.consumers.put(key, "");
        EndpointReferenceType epr = null;
        NotificationConsumerCallbackManager manager = null;
        try {
            String address = this.getURL().toString() + this.getNotificationConsumerServiceName();
            epr = AddressingUtils.createEndpointReference(address, key);
            manager = (NotificationConsumerCallbackManager)this.notificationConsumerHome.find(key);
        }
        catch (ResourceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceException("", e);
        }
        if (topicPaths != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                manager.registerCallback(topicPaths[i], callbacks[i]);
            }
        }
        return epr;
    }

    public EndpointReferenceType createNotificationConsumer(NotifyCallback callback) throws ResourceException {
        return this.createNotificationConsumer(callback, null);
    }

    public EndpointReferenceType createNotificationConsumer(NotifyCallback callback, ResourceSecurityDescriptor desc) throws ResourceException {
        return this.createNotificationConsumer(new List[]{null}, new NotifyCallback[]{callback}, desc);
    }

    public EndpointReferenceType createNotificationConsumer(List topicPath, NotifyCallback callback) throws ResourceException {
        return this.createNotificationConsumer(topicPath, callback, null);
    }

    public EndpointReferenceType createNotificationConsumer(List topicPath, NotifyCallback callback, ResourceSecurityDescriptor desc) throws ResourceException {
        return this.createNotificationConsumer(new List[]{topicPath}, new NotifyCallback[]{callback}, desc);
    }

    public EndpointReferenceType createNotificationConsumer() throws ResourceException {
        return this.createNotificationConsumer((List[])null, null);
    }

    private ResourceKey getKey(EndpointReferenceType consumerEndpointReference) throws InvalidResourceKeyException {
        ReferencePropertiesType referenceProperties = consumerEndpointReference.getProperties();
        return new SimpleResourceKey((SOAPElement)referenceProperties.get_any()[0], this.notificationConsumerHome.getKeyTypeClass());
    }

    public NotificationConsumerCallbackManager getNotificationConsumerCallbackManager(EndpointReferenceType consumerEndpointReference) throws ResourceException {
        ResourceKey key = this.getKey(consumerEndpointReference);
        return (NotificationConsumerCallbackManager)this.notificationConsumerHome.find(key);
    }

    public synchronized void removeNotificationConsumer(EndpointReferenceType consumerEndpointReference) throws ResourceException {
        ResourceKey key = this.getKey(consumerEndpointReference);
        this.notificationConsumerHome.remove(key);
        this.consumers.remove(key);
    }

    protected String getNotificationConsumerServiceName() {
        return "NotificationConsumerService";
    }

    protected synchronized void removeNotificationConsumers() {
        Iterator iter = this.consumers.keySet().iterator();
        while (iter.hasNext()) {
            ResourceKey key = (ResourceKey)iter.next();
            try {
                this.notificationConsumerHome.remove(key);
            }
            catch (Exception e) {
                logger.debug((Object)i18n.getMessage("notificationConsumerCleanupFailed"), (Throwable)e);
            }
        }
        this.consumers.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

