/*
 * Decompiled with CFR 0.152.
 */
package secconv.components;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.axis.security.util.AxisUtil;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.conversation.ConversationEngine;
import org.apache.ws.security.conversation.DerivedKeyCallbackHandler;
import org.apache.ws.security.conversation.message.info.SecurityContextInfo;
import org.apache.ws.security.conversation.message.token.RequestSecurityTokenResponse;
import org.apache.ws.security.conversation.message.token.RequestedProofToken;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.Init;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestRSTR
extends TestCase
implements CallbackHandler {
    private static Log log = LogFactory.getLog((Class)(class$secconv$components$TestRSTR == null ? (class$secconv$components$TestRSTR = TestRSTR.class$("secconv.components.TestRSTR")) : class$secconv$components$TestRSTR));
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test10/LogTestService10\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    MessageContext msgContext;
    Message message;
    String uuid;
    DerivedKeyCallbackHandler dkcbHandler;
    HashMap config;
    Crypto crypto = CryptoFactory.getInstance();
    static /* synthetic */ Class class$secconv$components$TestRSTR;

    public TestRSTR(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$secconv$components$TestRSTR == null ? (class$secconv$components$TestRSTR = TestRSTR.class$("secconv.components.TestRSTR")) : class$secconv$components$TestRSTR);
    }

    protected void setUp() throws Exception {
        AxisClient tmpEngine = new AxisClient((EngineConfiguration)new NullProvider());
        this.msgContext = new MessageContext((AxisEngine)tmpEngine);
        this.message = this.getSOAPMessage();
        this.dkcbHandler = new DerivedKeyCallbackHandler();
        SecurityContextToken secConTok = this.getSCT();
        this.uuid = secConTok.getIdentifier();
        SecurityContextInfo info = new SecurityContextInfo(secConTok, "DumbShredSecret".getBytes(), 1);
        DerivedKeyCallbackHandler.addSecurtiyContext(this.uuid, info);
        DerivedKeyCallbackHandler.setDerivedKeyLength(this.uuid, 24L);
        DerivedKeyCallbackHandler.setLabelForSession(this.uuid, "WSSecureConversationWSSecureConversation");
        this.config = new HashMap();
        this.config.put("keyFrequency", new Integer(1));
        this.config.put("useFixedKeyLegnth", new Boolean(true));
        this.config.put("keyLegnth", new Long(24L));
        this.config.put("decryptionPropFile", "crypto.properties");
    }

    protected Message getSOAPMessage() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapMsg.getBytes());
        Message msg = new Message((Object)in);
        msg.setMessageContext(this.msgContext);
        return msg;
    }

    protected SecurityContextToken getSCT() throws Exception {
        DocumentBuilderFactory buidler = DocumentBuilderFactory.newInstance();
        Document nulldoc = buidler.newDocumentBuilder().newDocument();
        SecurityContextToken sctTok = new SecurityContextToken(nulldoc);
        return sctTok;
    }

    public void testPerformRSTR() throws Exception {
        SOAPEnvelope unsignedEnvelope = this.message.getSOAPEnvelope();
        Object envelope = null;
        log.info((Object)"Before RequestedSecurityTokenResponse....");
        Document doc = unsignedEnvelope.getAsDocument();
        Element securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(WSSConfig.getDefaultWSConfig(), doc, doc.getDocumentElement(), true);
        RequestSecurityTokenResponse stRes = new RequestSecurityTokenResponse(doc, true);
        this.uuid = stRes.getRequestedSecurityToken().getSct().getIdentifier();
        stRes.build(doc);
        RequestedProofToken reqProof = stRes.getRequestedProofToken();
        reqProof.doEncryptProof(doc, this.crypto, "16c73ab6-b892-458f-abf5-2f875f74882e");
        Message rstrMsg = (Message)AxisUtil.toSOAPMessage(doc);
        XMLUtils.PrettyElementToWriter((Element)rstrMsg.getSOAPEnvelope().getAsDOM(), (Writer)new PrintWriter(System.out));
        this.verifyRSTR(doc);
    }

    private void verifyRSTR(Document doc) throws Exception {
        log.info((Object)"Before verifying RSTR............");
        ConversationEngine engine = new ConversationEngine(this.config);
        Vector results = engine.processSecConvHeader(doc, "", this.dkcbHandler, "secconv.components.PWCallback");
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
            pc.setPassword("secret");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Init.init();
    }
}

