/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust;

import java.net.URL;
import java.util.Properties;
import org.apache.axis.message.MessageElement;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.trust.message.token.BaseToken;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class STSUtil {
    public static MessageElement[] generateMessgaeElemArray(Element[] elem) {
        MessageElement[] meArr = new MessageElement[elem.length];
        for (int i = 0; i < elem.length; ++i) {
            meArr[i] = new MessageElement(elem[i]);
        }
        return meArr;
    }

    public static MessageElement generateMessgaeElement(Element elem) {
        MessageElement me = new MessageElement(elem);
        return me;
    }

    public static BinarySecurity findBinarySecurityToken(Document doc) {
        try {
            Element elemBase = (Element)WSSecurityUtil.findElement(doc, BaseToken.TOKEN.getLocalPart(), BaseToken.TOKEN.getNamespaceURI());
            Element elemBaseChild = (Element)elemBase.getFirstChild();
            if (elemBaseChild == null) {
                return null;
            }
            if (elemBaseChild.getLocalName().equals("BinarySecurityToken")) {
                BinarySecurity binarySecurity = new BinarySecurity(WSSConfig.getDefaultWSConfig(), elemBaseChild);
                return binarySecurity;
            }
            if (elemBaseChild.getLocalName().equals("SecurityTokenReference")) {
                return null;
            }
            return null;
        }
        catch (WSSecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static UsernameToken findUsernameToken(Document doc) {
        try {
            Element elemBase = (Element)WSSecurityUtil.findElement(doc, BaseToken.TOKEN.getLocalPart(), BaseToken.TOKEN.getNamespaceURI());
            Element elemBaseChild = (Element)elemBase.getFirstChild();
            if (elemBaseChild == null) {
                return null;
            }
            if (elemBaseChild.getLocalName().equals("UsernameToken")) {
                UsernameToken unt = new UsernameToken(WSSConfig.getDefaultWSConfig(), elemBaseChild);
                return unt;
            }
            return null;
        }
        catch (WSSecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void replaceSecurityTokenReferences(Document doc) throws WSSecurityException {
        NodeList nList = doc.getElementsByTagName("SecurityTokenReference");
        for (int i = 0; i < nList.getLength(); ++i) {
            SecurityTokenReference secTokRef = (SecurityTokenReference)((Object)nList.item(i));
            Reference ref = secTokRef.getReference();
            String uri = ref.getURI();
            Element elemFound = WSSecurityUtil.getElementByWsuId(WSSConfig.getDefaultWSConfig(), doc, uri);
            doc.replaceChild(secTokRef.getElement(), elemFound);
        }
    }

    public static Properties getProperties(String propFilename) {
        Properties properties = new Properties();
        try {
            URL url = Loader.getResource(propFilename);
            properties.load(url.openStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }
}

