/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.transform;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class STRTransform
extends TransformSpi {
    public static final String implementedTransformURI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$transform$STRTransform == null ? (class$org$apache$ws$security$transform$STRTransform = STRTransform.class$("org.apache.ws.security.transform.STRTransform")) : class$org$apache$ws$security$transform$STRTransform).getName());
    private static boolean doDebug = false;
    private WSDocInfo wsDocInfo = null;
    static /* synthetic */ Class class$org$apache$ws$security$transform$STRTransform;

    public boolean wantsOctetStream() {
        return false;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws IOException, CanonicalizationException, InvalidCanonicalizerException {
        doDebug = log.isDebugEnabled();
        if (doDebug) {
            log.debug((Object)("Beginning STRTransform..." + input.toString()));
        }
        try {
            Document thisDoc = this._transformObject.getDocument();
            int docHash = thisDoc.hashCode();
            if (doDebug) {
                log.debug((Object)("doc: " + thisDoc.toString() + ", " + docHash));
            }
            this.wsDocInfo = WSDocInfoStore.lookup(docHash);
            if (this.wsDocInfo == null) {
                throw new CanonicalizationException("no WSDocInfo found");
            }
            String canonAlgo = null;
            if (this._transformObject.length(WSConstants.WSSE_NS, "TransformationParameters") == 1) {
                Element tmpE = XMLUtils.selectNode((Node)this._transformObject.getElement().getFirstChild(), (String)WSConstants.WSSE_NS, (String)"TransformationParameters", (int)0);
                Element canonElem = (Element)WSSecurityUtil.getDirectChild(tmpE, "CanonicalizationMethod", "http://www.w3.org/2000/09/xmldsig#");
                canonAlgo = canonElem.getAttribute("Algorithm");
                if (doDebug) {
                    log.debug((Object)("CanonAlgo: " + canonAlgo));
                }
            }
            Canonicalizer canon = Canonicalizer.getInstance(canonAlgo);
            byte[] buf = canon.canonicalizeXPathNodeSet(input.getNodeSet());
            ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
            bos.write(buf, 0, buf.length);
            if (doDebug) {
                log.debug((Object)("canon bos: " + bos.toString()));
            }
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setValidating(false);
            dfactory.setNamespaceAware(true);
            DocumentBuilder db = dfactory.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(bos.toByteArray()));
            NodeList nodeList = doc.getElementsByTagNameNS(WSConstants.WSSE_NS, "SecurityTokenReference");
            Element str = null;
            Element tmpEl = (Element)nodeList.item(0);
            if (doDebug) {
                log.debug((Object)("STR: " + tmpEl.toString()));
            }
            SecurityTokenReference secRef = new SecurityTokenReference(WSSConfig.getDefaultWSConfig(), tmpEl);
            str = this.dereferenceSTR(thisDoc, secRef);
            str = (Element)doc.importNode(str, true);
            Node parent = tmpEl.getParentNode();
            Element tmpEl1 = doc.createElement("temp");
            tmpEl1.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:X");
            parent.replaceChild(tmpEl1, tmpEl);
            tmpEl1.appendChild(str);
            buf = canon.canonicalizeSubtree((Node)doc, "#default");
            bos = new ByteArrayOutputStream(buf.length);
            bos.write(buf, 0, buf.length);
            if (doDebug) {
                log.debug((Object)("after c14n: " + bos.toString()));
            }
            StringBuffer bf = new StringBuffer(bos.toString());
            String bf1 = bf.substring("<temp xmlns=\"urn:X\">".length(), bf.length() - "</temp>".length());
            if (doDebug) {
                log.debug((Object)"last result: ");
                log.debug((Object)bf1.toString());
            }
            return new XMLSignatureInput(bf1.getBytes());
        }
        catch (IOException ex) {
            throw new CanonicalizationException("empty", (Exception)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new CanonicalizationException("empty", (Exception)ex);
        }
        catch (XMLSecurityException ex) {
            throw new CanonicalizationException("empty", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new CanonicalizationException("empty", (Exception)ex);
        }
        catch (TransformerException ex) {
            throw new CanonicalizationException("empty", (Exception)ex);
        }
        catch (Exception ex) {
            throw new CanonicalizationException("empty", ex);
        }
    }

    private Element dereferenceSTR(Document doc, SecurityTokenReference secRef) throws Exception {
        Element tokElement = null;
        if (secRef.containsReference()) {
            if (doDebug) {
                log.debug((Object)"STR: Reference");
            }
            if ((tokElement = secRef.getTokenElement(doc, this.wsDocInfo)) == null) {
                throw new CanonicalizationException("empty");
            }
        } else if (secRef.containsX509IssuerSerial()) {
            if (doDebug) {
                log.debug((Object)"STR: IssuerSerial");
            }
            X509Certificate cert = null;
            X509Security x509token = null;
            if (x509token != null) {
                cert = x509token.getX509Certificate(this.wsDocInfo.getCrypto());
            } else {
                X509Certificate[] certs = secRef.getX509IssuerSerial(this.wsDocInfo.getCrypto());
                if (certs == null || certs.length == 0 || certs[0] == null) {
                    throw new CanonicalizationException("empty");
                }
                cert = certs[0];
            }
            tokElement = this.createBST(doc, cert, secRef.getElement());
        } else if (secRef.containsKeyIdentifier()) {
            if (doDebug) {
                log.debug((Object)"STR: KeyIdentifier");
            }
            X509Certificate cert = null;
            X509Security x509token = null;
            if (x509token != null) {
                cert = x509token.getX509Certificate(this.wsDocInfo.getCrypto());
            } else {
                X509Certificate[] certs = secRef.getKeyIdentifier(this.wsDocInfo.getCrypto());
                if (certs == null || certs.length == 0 || certs[0] == null) {
                    throw new CanonicalizationException("empty");
                }
                cert = certs[0];
            }
            tokElement = this.createBST(doc, cert, secRef.getElement());
        }
        return tokElement;
    }

    private Element createBST(Document doc, X509Certificate cert, Element secRefE) throws Exception {
        byte[] data = cert.getEncoded();
        String prefix = WSSecurityUtil.getPrefixNS(WSConstants.WSSE_NS, secRefE);
        Element elem = doc.createElementNS(WSConstants.WSSE_NS, prefix + ":BinarySecurityToken");
        WSSecurityUtil.setNamespace(elem, WSConstants.WSSE_NS, prefix);
        elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        elem.setAttributeNS(null, "ValueType", X509Security.getType(WSSConfig.getDefaultWSConfig()));
        Text certText = doc.createTextNode(Base64.encode((byte[])data, (int)0));
        elem.appendChild(certText);
        return elem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

