/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.DOM2Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Reference {
    public static final String TOKEN_LNAME = "Reference";
    protected Element element = null;
    protected WSSConfig wssConfig;

    public Reference(WSSConfig wssConfig, Element elem) throws WSSecurityException {
        if (elem == null) {
            throw new WSSecurityException(3, "noReference");
        }
        this.element = elem;
        this.wssConfig = wssConfig;
        boolean nsOK = false;
        if (wssConfig.getProcessNonCompliantMessages()) {
            for (int i = 0; i < WSConstants.WSSE_NS_ARRAY.length; ++i) {
                if (!WSConstants.WSSE_NS_ARRAY[i].equals(this.element.getNamespaceURI())) continue;
                nsOK = true;
                break;
            }
        } else if (wssConfig.getWsseNS().equals(this.element.getNamespaceURI())) {
            nsOK = true;
        }
        if (!nsOK || !this.element.getLocalName().equals(TOKEN_LNAME)) {
            QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
            QName token = new QName(wssConfig.getWsseNS(), TOKEN_LNAME);
            throw new WSSecurityException(0, "badElement", new Object[]{token, el});
        }
    }

    public Reference(WSSConfig wssConfig, Document doc) {
        this.wssConfig = wssConfig;
        this.element = doc.createElementNS(wssConfig.getWsseNS(), "wsse:Reference");
    }

    public Element getElement() {
        return this.element;
    }

    public String getValueType() {
        return this.element.getAttribute("ValueType");
    }

    public String getURI() {
        return this.element.getAttribute("URI");
    }

    public void setValueType(String valueType) {
        this.element.setAttribute("ValueType", valueType);
    }

    public void setURI(String uri) {
        this.element.setAttribute("URI", uri);
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }
}

